/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.ExceptionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringComparison;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerHelpers;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.AstKeys;
import com.strobel.decompiler.ast.AstOptimizer;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.CaseBlock;
import com.strobel.decompiler.ast.CatchBlock;
import com.strobel.decompiler.ast.Condition;
import com.strobel.decompiler.ast.Label;
import com.strobel.decompiler.ast.Lambda;
import com.strobel.decompiler.ast.Loop;
import com.strobel.decompiler.ast.LoopType;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.Range;
import com.strobel.decompiler.ast.Switch;
import com.strobel.decompiler.ast.TryCatchBlock;
import com.strobel.decompiler.ast.TypeAnalysis;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.Languages;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayInitializerExpression;
import com.strobel.decompiler.languages.java.ast.ArraySpecifier;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.CommentStatement;
import com.strobel.decompiler.languages.java.ast.CommentType;
import com.strobel.decompiler.languages.java.ast.ComposedType;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.ContinueStatement;
import com.strobel.decompiler.languages.java.ast.ConvertTypeOptions;
import com.strobel.decompiler.languages.java.ast.DoWhileStatement;
import com.strobel.decompiler.languages.java.ast.EmptyStatement;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.GotoStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.IndexerExpression;
import com.strobel.decompiler.languages.java.ast.InstanceOfExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaPrimitiveCast;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.NameVariables;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.semantics.ResolveResult;
import com.strobel.util.ContractUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class AstMethodBodyBuilder {
    private final AstBuilder _astBuilder;
    private final MethodDefinition _method;
    private final MetadataParser _parser;
    private final DecompilerContext _context;
    private final Set<Variable> _localVariablesToDefine = new LinkedHashSet<Variable>();
    private static final INode LAMBDA_BODY_PATTERN = new Choice(new BlockStatement(new ExpressionStatement(new AnyNode("body").toExpression()), new OptionalNode(new ReturnStatement(-34)).toStatement()), new BlockStatement(new ReturnStatement(-34, new AnyNode("body").toExpression())), new AnyNode("body").toBlockStatement());
    private static final INode EMPTY_LAMBDA_BODY_PATTERN = new BlockStatement(new ReturnStatement(-34));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockStatement createMethodBody(AstBuilder astBuilder, MethodDefinition method, DecompilerContext context, Iterable<ParameterDeclaration> parameters) {
        VerifyArgument.notNull(astBuilder, "astBuilder");
        VerifyArgument.notNull(method, "method");
        VerifyArgument.notNull(context, "context");
        MethodDefinition oldCurrentMethod = context.getCurrentMethod();
        context.setCurrentMethod(method);
        try {
            AstMethodBodyBuilder builder = new AstMethodBodyBuilder(astBuilder, method, context);
            BlockStatement blockStatement = builder.createMethodBody(parameters);
            return blockStatement;
        }
        catch (Throwable t) {
            BlockStatement blockStatement = AstMethodBodyBuilder.createErrorBlock(astBuilder, context, method, t);
            return blockStatement;
        }
        finally {
            context.setCurrentMethod(oldCurrentMethod);
        }
    }

    private static BlockStatement createErrorBlock(AstBuilder astBuilder, DecompilerContext context, MethodDefinition method, Throwable t) {
        BlockStatement block = new BlockStatement();
        List<String> lines = StringUtilities.split(ExceptionUtilities.getStackTraceString(t), true, '\r', '\n');
        block.addChild(new Comment(" ", CommentType.SingleLine), Roles.COMMENT);
        block.addChild(new Comment(" This method could not be decompiled.", CommentType.SingleLine), Roles.COMMENT);
        block.addChild(new Comment(" ", CommentType.SingleLine), Roles.COMMENT);
        try {
            PlainTextOutput bytecodeOutput = new PlainTextOutput();
            DecompilationOptions bytecodeOptions = new DecompilationOptions();
            bytecodeOptions.getSettings().setIncludeLineNumbersInBytecode(false);
            Languages.bytecode().decompileMethod(method, bytecodeOutput, bytecodeOptions);
            List<String> bytecodeLines = StringUtilities.split(bytecodeOutput.toString(), true, '\r', '\n');
            block.addChild(new Comment(" Original Bytecode:", CommentType.SingleLine), Roles.COMMENT);
            block.addChild(new Comment(" ", CommentType.SingleLine), Roles.COMMENT);
            for (int i = 4; i < bytecodeLines.size(); ++i) {
                String line = StringUtilities.removeLeft(bytecodeLines.get(i), "      ");
                block.addChild(new Comment(line.replace("\t", "  "), CommentType.SingleLine), Roles.COMMENT);
            }
            block.addChild(new Comment(" ", CommentType.SingleLine), Roles.COMMENT);
        }
        catch (Throwable ignored) {
            block.addChild(new Comment(" Could not show original bytecode, likely due to the same error.", CommentType.SingleLine), Roles.COMMENT);
            block.addChild(new Comment(" ", CommentType.SingleLine), Roles.COMMENT);
        }
        if (context.getSettings().getIncludeErrorDiagnostics()) {
            block.addChild(new Comment(" The error that occurred was:", CommentType.SingleLine), Roles.COMMENT);
            block.addChild(new Comment(" ", CommentType.SingleLine), Roles.COMMENT);
            for (String line : lines) {
                block.addChild(new Comment(" " + line.replace("\t", "    "), CommentType.SingleLine), Roles.COMMENT);
            }
            block.addChild(new Comment(" ", CommentType.SingleLine), Roles.COMMENT);
        }
        try {
            TypeDefinition currentType = astBuilder.getContext().getCurrentType();
            IMetadataResolver resolver = currentType != null ? currentType.getResolver() : MetadataSystem.instance();
            MetadataParser parser = new MetadataParser(resolver);
            block.add(new ThrowStatement(new ObjectCreationExpression(-34, astBuilder.convertType(parser.parseTypeDescriptor("java/lang/IllegalStateException")), new PrimitiveExpression(-34, "An error occurred while decompiling this method."))));
        }
        catch (Throwable ignored) {
            block.add(new EmptyStatement());
        }
        return block;
    }

    private AstMethodBodyBuilder(AstBuilder astBuilder, MethodDefinition method, DecompilerContext context) {
        this._astBuilder = astBuilder;
        this._method = method;
        this._context = context;
        this._parser = new MetadataParser(method.getDeclaringType());
    }

    private BlockStatement createMethodBody(Iterable<ParameterDeclaration> parameters) {
        MethodBody body = this._method.getBody();
        if (body == null) {
            return null;
        }
        Block method = new Block();
        method.getBody().addAll(com.strobel.decompiler.ast.AstBuilder.build(body, true, this._context));
        AstOptimizer.optimize(this._context, method);
        LinkedHashSet<ParameterDefinition> unmatchedParameters = new LinkedHashSet<ParameterDefinition>(this._method.getParameters());
        LinkedHashSet<Variable> methodParameters = new LinkedHashSet<Variable>();
        LinkedHashSet<Variable> localVariables = new LinkedHashSet<Variable>();
        List<com.strobel.decompiler.ast.Expression> expressions = method.getSelfAndChildrenRecursive(com.strobel.decompiler.ast.Expression.class);
        for (com.strobel.decompiler.ast.Expression expression : expressions) {
            Object object = expression.getOperand();
            if (!(object instanceof Variable)) continue;
            Variable variable = (Variable)object;
            if (variable.isParameter()) {
                methodParameters.add(variable);
                unmatchedParameters.remove(variable.getOriginalParameter());
                continue;
            }
            localVariables.add(variable);
        }
        ArrayList<Variable> orderedParameters = new ArrayList<Variable>();
        for (ParameterDefinition parameterDefinition : unmatchedParameters) {
            Variable v = new Variable();
            v.setName(parameterDefinition.getName());
            v.setOriginalParameter(parameterDefinition);
            v.setType(parameterDefinition.getParameterType());
            orderedParameters.add(v);
        }
        for (Variable variable : methodParameters) {
            orderedParameters.add(variable);
        }
        Collections.sort(orderedParameters, new Comparator<Variable>(){

            @Override
            public int compare(@NotNull Variable p1, @NotNull Variable p2) {
                return Integer.compare(p1.getOriginalParameter().getSlot(), p2.getOriginalParameter().getSlot());
            }
        });
        List<CatchBlock> list = method.getSelfAndChildrenRecursive(CatchBlock.class);
        for (CatchBlock catchBlock : list) {
            Variable exceptionVariable = catchBlock.getExceptionVariable();
            if (exceptionVariable == null) continue;
            localVariables.add(exceptionVariable);
        }
        NameVariables.assignNamesToVariables(this._context, orderedParameters, localVariables, method);
        for (final Variable p : orderedParameters) {
            ParameterDeclaration declaration = CollectionUtilities.firstOrDefault(parameters, new Predicate<ParameterDeclaration>(){

                @Override
                public boolean test(ParameterDeclaration pd) {
                    return pd.getUserData(Keys.PARAMETER_DEFINITION) == p.getOriginalParameter();
                }
            });
            if (declaration == null) continue;
            declaration.setName(p.getName());
        }
        BlockStatement blockStatement = this.transformBlock(method);
        CommentStatement.replaceAll(blockStatement);
        AstNodeCollection<Statement> statements = blockStatement.getStatements();
        Statement insertionPoint = CollectionUtilities.firstOrDefault(statements);
        for (Variable v : this._localVariablesToDefine) {
            TypeReference variableType = v.getType();
            TypeDefinition resolvedType = variableType.resolve();
            if (resolvedType != null && resolvedType.isAnonymous()) {
                variableType = resolvedType.getExplicitInterfaces().isEmpty() ? resolvedType.getBaseType() : resolvedType.getExplicitInterfaces().get(0);
            }
            AstType type = this._astBuilder.convertType(variableType);
            VariableDeclarationStatement declaration = new VariableDeclarationStatement(type, v.getName(), -34);
            declaration.putUserData(Keys.VARIABLE, v);
            statements.insertBefore(insertionPoint, declaration);
        }
        return blockStatement;
    }

    private BlockStatement transformBlock(Block block) {
        BlockStatement astBlock = new BlockStatement();
        if (block != null) {
            List<Node> children = block.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Node node = children.get(i);
                Statement statement = this.transformNode(node, i < children.size() - 1 ? children.get(i + 1) : null);
                astBlock.getStatements().add(statement);
                if (!(statement instanceof SynchronizedStatement)) continue;
                ++i;
            }
        }
        return astBlock;
    }

    private Statement transformNode(Node node, Node next) {
        com.strobel.decompiler.ast.Expression testCondition;
        if (node instanceof Label) {
            return new LabelStatement(-34, ((Label)node).getName());
        }
        if (node instanceof Block) {
            return this.transformBlock((Block)node);
        }
        if (node instanceof com.strobel.decompiler.ast.Expression) {
            Object finallyNode;
            TryCatchBlock tryCatch;
            Block finallyBlock;
            com.strobel.decompiler.ast.Expression expression = (com.strobel.decompiler.ast.Expression)node;
            if (expression.getCode() == AstCode.MonitorEnter && next instanceof TryCatchBlock && (finallyBlock = (tryCatch = (TryCatchBlock)next).getFinallyBlock()) != null && finallyBlock.getBody().size() == 1 && (finallyNode = finallyBlock.getBody().get(0)) instanceof com.strobel.decompiler.ast.Expression && ((com.strobel.decompiler.ast.Expression)finallyNode).getCode() == AstCode.MonitorExit) {
                return this.transformSynchronized(expression, tryCatch);
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            List<com.strobel.decompiler.ast.Expression> childExpressions = node.getSelfAndChildrenRecursive(com.strobel.decompiler.ast.Expression.class);
            for (com.strobel.decompiler.ast.Expression e : childExpressions) {
                ranges.addAll(e.getRanges());
            }
            List<Range> orderedAndJoinedRanges = Range.orderAndJoint(ranges);
            AstNode codeExpression = this.transformExpression((com.strobel.decompiler.ast.Expression)node, true);
            if (codeExpression != null) {
                if (codeExpression instanceof Expression) {
                    return new ExpressionStatement((Expression)codeExpression);
                }
                return (Statement)codeExpression;
            }
        }
        if (node instanceof Loop) {
            WhileStatement whileStatement;
            Statement loopStatement;
            Loop loop = (Loop)node;
            com.strobel.decompiler.ast.Expression loopCondition = loop.getCondition();
            if (loopCondition != null) {
                if (loop.getLoopType() == LoopType.PostCondition) {
                    DoWhileStatement doWhileStatement = new DoWhileStatement(loopCondition.getOffset());
                    doWhileStatement.setCondition((Expression)this.transformExpression(loopCondition, false));
                    loopStatement = doWhileStatement;
                } else {
                    whileStatement = new WhileStatement(loopCondition.getOffset());
                    whileStatement.setCondition((Expression)this.transformExpression(loopCondition, false));
                    loopStatement = whileStatement;
                }
            } else {
                loopStatement = whileStatement = new WhileStatement(-34);
                whileStatement.setCondition(new PrimitiveExpression(-34, true));
            }
            loopStatement.setChildByRole(Roles.EMBEDDED_STATEMENT, this.transformBlock(loop.getBody()));
            return loopStatement;
        }
        if (node instanceof Condition) {
            Condition condition = (Condition)node;
            testCondition = condition.getCondition();
            Block trueBlock = condition.getTrueBlock();
            Block falseBlock = condition.getFalseBlock();
            boolean hasFalseBlock = falseBlock.getEntryGoto() != null || !falseBlock.getBody().isEmpty();
            return new IfElseStatement(testCondition.getOffset(), (Expression)this.transformExpression(testCondition, false), this.transformBlock(trueBlock), hasFalseBlock ? this.transformBlock(falseBlock) : null);
        }
        if (node instanceof Switch) {
            Switch switchNode = (Switch)node;
            testCondition = switchNode.getCondition();
            if (TypeAnalysis.isBoolean(testCondition.getInferredType())) {
                testCondition.setExpectedType(BuiltinTypes.Integer);
            }
            List<CaseBlock> caseBlocks = switchNode.getCaseBlocks();
            SwitchStatement switchStatement = new SwitchStatement((Expression)this.transformExpression(testCondition, false));
            for (CaseBlock caseBlock : caseBlocks) {
                SwitchSection section = new SwitchSection();
                AstNodeCollection<CaseLabel> caseLabels = section.getCaseLabels();
                if (caseBlock.getValues().isEmpty()) {
                    caseLabels.add(new CaseLabel());
                } else {
                    TypeReference referenceType = testCondition.getExpectedType() != null ? testCondition.getExpectedType() : testCondition.getInferredType();
                    for (Integer value : caseBlock.getValues()) {
                        CaseLabel caseLabel = new CaseLabel();
                        caseLabel.setExpression(AstBuilder.makePrimitive(value.intValue(), referenceType));
                        caseLabels.add(caseLabel);
                    }
                }
                section.getStatements().add(this.transformBlock(caseBlock));
                switchStatement.getSwitchSections().add(section);
            }
            return switchStatement;
        }
        if (node instanceof TryCatchBlock) {
            TryCatchBlock tryCatchNode = (TryCatchBlock)node;
            Block finallyBlock = tryCatchNode.getFinallyBlock();
            List<CatchBlock> catchBlocks = tryCatchNode.getCatchBlocks();
            TryCatchStatement tryCatch = new TryCatchStatement(-34);
            tryCatch.setTryBlock(this.transformBlock(tryCatchNode.getTryBlock()));
            for (CatchBlock catchBlock : catchBlocks) {
                CatchClause catchClause = new CatchClause(this.transformBlock(catchBlock));
                for (TypeReference caughtType : catchBlock.getCaughtTypes()) {
                    catchClause.getExceptionTypes().add(this._astBuilder.convertType(caughtType));
                }
                Variable exceptionVariable = catchBlock.getExceptionVariable();
                if (exceptionVariable != null) {
                    catchClause.setVariableName(exceptionVariable.getName());
                    catchClause.putUserData(Keys.VARIABLE, exceptionVariable);
                }
                tryCatch.getCatchClauses().add(catchClause);
            }
            if (finallyBlock != null && (!finallyBlock.getBody().isEmpty() || catchBlocks.isEmpty())) {
                tryCatch.setFinallyBlock(this.transformBlock(finallyBlock));
            }
            return tryCatch;
        }
        throw new IllegalArgumentException("Unknown node type: " + node);
    }

    private SynchronizedStatement transformSynchronized(com.strobel.decompiler.ast.Expression expression, TryCatchBlock tryCatch) {
        SynchronizedStatement s2 = new SynchronizedStatement(expression.getOffset());
        s2.setExpression((Expression)this.transformExpression(expression.getArguments().get(0), false));
        if (tryCatch.getCatchBlocks().isEmpty()) {
            s2.setEmbeddedStatement(this.transformBlock(tryCatch.getTryBlock()));
        } else {
            tryCatch.setFinallyBlock(null);
            s2.setEmbeddedStatement(new BlockStatement(this.transformNode(tryCatch, null)));
        }
        return s2;
    }

    private AstNode transformExpression(com.strobel.decompiler.ast.Expression e, boolean isTopLevel) {
        return this.transformByteCode(e, isTopLevel);
    }

    private AstNode transformByteCode(com.strobel.decompiler.ast.Expression byteCode, boolean isTopLevel) {
        Object operand = byteCode.getOperand();
        Label label = operand instanceof Label ? (Label)operand : null;
        AstType operandType = operand instanceof TypeReference ? this._astBuilder.convertType((TypeReference)operand) : AstType.NULL;
        Variable variableOperand = operand instanceof Variable ? (Variable)operand : null;
        FieldReference fieldOperand = operand instanceof FieldReference ? (FieldReference)operand : null;
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        for (com.strobel.decompiler.ast.Expression e : byteCode.getArguments()) {
            arguments.add((Expression)this.transformExpression(e, false));
        }
        Expression arg1 = arguments.size() >= 1 ? (Expression)arguments.get(0) : null;
        Expression arg2 = arguments.size() >= 2 ? (Expression)arguments.get(1) : null;
        Expression arg3 = arguments.size() >= 3 ? (Expression)arguments.get(2) : null;
        switch (byteCode.getCode()) {
            case Nop: {
                return null;
            }
            case AConstNull: {
                return new NullReferenceExpression(byteCode.getOffset());
            }
            case LdC: {
                TypeReference type;
                if (operand instanceof TypeReference) {
                    operandType.getChildrenByRole(Roles.TYPE_ARGUMENT).clear();
                    return new ClassOfExpression(byteCode.getOffset(), operandType);
                }
                TypeReference typeReference = type = byteCode.getInferredType() != null ? byteCode.getInferredType() : byteCode.getExpectedType();
                if (type != null) {
                    switch (type.getSimpleType()) {
                        case Byte: 
                        case Short: {
                            return new PrimitiveExpression(byteCode.getOffset(), JavaPrimitiveCast.cast(JvmType.Integer, operand));
                        }
                    }
                    return new PrimitiveExpression(byteCode.getOffset(), JavaPrimitiveCast.cast(type.getSimpleType(), operand));
                }
                return new PrimitiveExpression(byteCode.getOffset(), operand);
            }
            case Pop: 
            case Pop2: 
            case Dup: 
            case DupX1: 
            case DupX2: 
            case Dup2: 
            case Dup2X1: 
            case Dup2X2: {
                return arg1;
            }
            case Swap: {
                return arg1;
            }
            case I2L: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Long), arg1);
            }
            case I2F: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Float), arg1);
            }
            case I2D: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Double), arg1);
            }
            case L2I: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Integer), arg1);
            }
            case L2F: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Float), arg1);
            }
            case L2D: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Double), arg1);
            }
            case F2I: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Integer), arg1);
            }
            case F2L: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Long), arg1);
            }
            case F2D: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Double), arg1);
            }
            case D2I: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Integer), arg1);
            }
            case D2L: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Long), arg1);
            }
            case D2F: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Float), arg1);
            }
            case I2B: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Byte), arg1);
            }
            case I2C: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Character), arg1);
            }
            case I2S: {
                return new CastExpression(this._astBuilder.convertType(BuiltinTypes.Short), arg1);
            }
            case Goto: {
                return new GotoStatement(byteCode.getOffset(), ((Label)operand).getName());
            }
            case GetStatic: {
                ConvertTypeOptions options = new ConvertTypeOptions();
                options.setIncludeTypeParameterDefinitions(false);
                MemberReferenceExpression fieldReference = this._astBuilder.convertType(fieldOperand.getDeclaringType(), options).member(fieldOperand.getName());
                fieldReference.putUserData(Keys.MEMBER_REFERENCE, fieldOperand);
                return fieldReference;
            }
            case PutStatic: {
                ConvertTypeOptions options = new ConvertTypeOptions();
                options.setIncludeTypeParameterDefinitions(false);
                FieldDefinition resolvedField = fieldOperand.resolve();
                Expression fieldReference = resolvedField != null && resolvedField.isFinal() && StringUtilities.equals(resolvedField.getDeclaringType().getInternalName(), this._context.getCurrentType().getInternalName()) ? new IdentifierExpression(byteCode.getOffset(), fieldOperand.getName()) : this._astBuilder.convertType(fieldOperand.getDeclaringType(), options).member(fieldOperand.getName());
                fieldReference.putUserData(Keys.MEMBER_REFERENCE, fieldOperand);
                return new AssignmentExpression(fieldReference, arg1);
            }
            case GetField: {
                MemberReferenceExpression fieldReference = arg1 instanceof ThisReferenceExpression && MetadataHelper.isSubType(this._context.getCurrentType(), fieldOperand.getDeclaringType()) && !StringUtilities.equals(fieldOperand.getDeclaringType().getInternalName(), this._context.getCurrentType().getInternalName()) ? new SuperReferenceExpression(arg1.getOffset()).member(fieldOperand.getName()) : arg1.member(fieldOperand.getName());
                fieldReference.putUserData(Keys.MEMBER_REFERENCE, fieldOperand);
                return fieldReference;
            }
            case PutField: {
                MemberReferenceExpression fieldReference = arg1 instanceof ThisReferenceExpression && MetadataHelper.isSubType(this._context.getCurrentType(), fieldOperand.getDeclaringType()) && !StringUtilities.equals(fieldOperand.getDeclaringType().getInternalName(), this._context.getCurrentType().getInternalName()) ? new SuperReferenceExpression(arg1.getOffset()).member(fieldOperand.getName()) : arg1.member(fieldOperand.getName());
                fieldReference.putUserData(Keys.MEMBER_REFERENCE, fieldOperand);
                return new AssignmentExpression(fieldReference, arg2);
            }
            case InvokeSpecial: 
            case InvokeStatic: {
                return this.transformCall(false, byteCode, arguments);
            }
            case InvokeVirtual: 
            case InvokeInterface: {
                return this.transformCall(true, byteCode, arguments);
            }
            case InvokeDynamic: {
                boolean hasInstanceArgument;
                DynamicCallSite callSite = (DynamicCallSite)operand;
                MethodReference bootstrapMethod = callSite.getBootstrapMethod();
                if (!"java/lang/invoke/LambdaMetafactory".equals(bootstrapMethod.getDeclaringType().getInternalName()) || !StringUtilities.equals("metafactory", bootstrapMethod.getName(), StringComparison.OrdinalIgnoreCase) && !StringUtilities.equals("altMetafactory", bootstrapMethod.getName(), StringComparison.OrdinalIgnoreCase) || callSite.getBootstrapArguments().size() < 3 || !(callSite.getBootstrapArguments().get(1) instanceof MethodHandle)) break;
                MethodHandle targetMethodHandle = (MethodHandle)callSite.getBootstrapArguments().get(1);
                MethodReference targetMethod = targetMethodHandle.getMethod();
                TypeReference declaringType = targetMethod.getDeclaringType();
                String methodName = targetMethod.isConstructor() ? "new" : targetMethod.getName();
                switch (targetMethodHandle.getHandleType()) {
                    case GetField: 
                    case PutField: 
                    case InvokeVirtual: 
                    case InvokeInterface: 
                    case InvokeSpecial: {
                        hasInstanceArgument = arg1 != null;
                        break;
                    }
                    default: {
                        hasInstanceArgument = false;
                    }
                }
                MethodGroupExpression methodGroup = new MethodGroupExpression(byteCode.getOffset(), hasInstanceArgument ? arg1 : new TypeReferenceExpression(byteCode.getOffset(), this._astBuilder.convertType(declaringType)), methodName);
                methodGroup.getClosureArguments().addAll(hasInstanceArgument ? arguments.subList(1, arguments.size()) : arguments);
                methodGroup.putUserData(Keys.DYNAMIC_CALL_SITE, callSite);
                methodGroup.putUserData(Keys.MEMBER_REFERENCE, targetMethod);
                if (byteCode.getInferredType() != null) {
                    methodGroup.putUserData(Keys.TYPE_REFERENCE, byteCode.getInferredType());
                }
                return methodGroup;
            }
            case Bind: {
                Lambda lambda = (Lambda)byteCode.getOperand();
                LambdaExpression lambdaExpression = new LambdaExpression(byteCode.getOffset());
                AstNodeCollection<ParameterDeclaration> declarations = lambdaExpression.getParameters();
                for (Variable v : lambda.getParameters()) {
                    ParameterDefinition p = v.getOriginalParameter();
                    ParameterDeclaration d = new ParameterDeclaration(v.getName(), null);
                    d.putUserData(Keys.PARAMETER_DEFINITION, p);
                    d.putUserData(Keys.VARIABLE, v);
                    for (CustomAnnotation annotation : p.getAnnotations()) {
                        d.getAnnotations().add(this._astBuilder.createAnnotation(annotation));
                    }
                    declarations.add(d);
                    if (!p.isFinal()) continue;
                    EntityDeclaration.addModifier(d, Modifier.FINAL);
                }
                BlockStatement body = this.transformBlock(lambda.getBody());
                Match m3 = LAMBDA_BODY_PATTERN.match(body);
                if (m3.success()) {
                    AstNode bodyNode = (AstNode)CollectionUtilities.first(m3.get("body"));
                    bodyNode.remove();
                    lambdaExpression.setBody(bodyNode);
                    if (EMPTY_LAMBDA_BODY_PATTERN.matches(bodyNode)) {
                        bodyNode.getChildrenByRole(BlockStatement.STATEMENT_ROLE).clear();
                    }
                } else {
                    lambdaExpression.setBody(body);
                }
                lambdaExpression.putUserData(Keys.TYPE_REFERENCE, byteCode.getInferredType());
                DynamicCallSite callSite = lambda.getCallSite();
                if (callSite != null) {
                    lambdaExpression.putUserData(Keys.DYNAMIC_CALL_SITE, callSite);
                }
                return lambdaExpression;
            }
            case ArrayLength: {
                MemberReferenceExpression length = arg1.member("length");
                TypeReference arrayType = CollectionUtilities.single(byteCode.getArguments()).getInferredType();
                if (arrayType != null) {
                    length.putUserData(Keys.MEMBER_REFERENCE, this._parser.parseField(arrayType, "length", "I"));
                }
                return length;
            }
            case AThrow: {
                return new ThrowStatement(arg1);
            }
            case CheckCast: {
                return new CastExpression(operandType, arg1);
            }
            case InstanceOf: {
                return new InstanceOfExpression(byteCode.getOffset(), arg1, operandType);
            }
            case MonitorEnter: 
            case MonitorExit: {
                break;
            }
            case MultiANewArray: {
                int i;
                ArrayCreationExpression arrayCreation = new ArrayCreationExpression(byteCode.getOffset());
                int rank = 0;
                AstType elementType = operandType;
                while (elementType instanceof ComposedType) {
                    rank += ((ComposedType)elementType).getArraySpecifiers().size();
                    elementType = ((ComposedType)elementType).getBaseType();
                }
                arrayCreation.setType(elementType.clone());
                for (i = 0; i < arguments.size(); ++i) {
                    arrayCreation.getDimensions().add((Expression)((AstNode)arguments.get(i)));
                    --rank;
                }
                for (i = 0; i < rank; ++i) {
                    arrayCreation.getAdditionalArraySpecifiers().add(new ArraySpecifier());
                }
                return arrayCreation;
            }
            case Breakpoint: {
                return null;
            }
            case Load: {
                if (!variableOperand.isParameter()) {
                    this._localVariablesToDefine.add(variableOperand);
                }
                if (variableOperand.isParameter() && variableOperand.getOriginalParameter().getPosition() < 0) {
                    ThisReferenceExpression self = new ThisReferenceExpression(byteCode.getOffset());
                    self.putUserData(Keys.TYPE_REFERENCE, this._context.getCurrentType());
                    return self;
                }
                IdentifierExpression name = new IdentifierExpression(byteCode.getOffset(), variableOperand.getName());
                name.putUserData(Keys.VARIABLE, variableOperand);
                return name;
            }
            case Store: {
                if (!variableOperand.isParameter()) {
                    this._localVariablesToDefine.add(variableOperand);
                }
                IdentifierExpression name = new IdentifierExpression(byteCode.getOffset(), variableOperand.getName());
                name.putUserData(Keys.VARIABLE, variableOperand);
                return new AssignmentExpression(name, arg1);
            }
            case LoadElement: {
                return new IndexerExpression(byteCode.getOffset(), arg1, arg2);
            }
            case StoreElement: {
                return new AssignmentExpression(new IndexerExpression(byteCode.getOffset(), arg1, arg2), arg3);
            }
            case Add: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.ADD, arg2);
            }
            case Sub: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.SUBTRACT, arg2);
            }
            case Mul: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.MULTIPLY, arg2);
            }
            case Div: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.DIVIDE, arg2);
            }
            case Rem: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.MODULUS, arg2);
            }
            case Neg: {
                return new UnaryOperatorExpression(UnaryOperatorType.MINUS, arg1);
            }
            case Shl: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.SHIFT_LEFT, arg2);
            }
            case Shr: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.SHIFT_RIGHT, arg2);
            }
            case UShr: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.UNSIGNED_SHIFT_RIGHT, arg2);
            }
            case And: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.BITWISE_AND, arg2);
            }
            case Or: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.BITWISE_OR, arg2);
            }
            case Not: {
                return new UnaryOperatorExpression(UnaryOperatorType.NOT, arg1);
            }
            case Xor: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.EXCLUSIVE_OR, arg2);
            }
            case Inc: {
                if (!variableOperand.isParameter()) {
                    this._localVariablesToDefine.add(variableOperand);
                }
                IdentifierExpression name = new IdentifierExpression(byteCode.getOffset(), variableOperand.getName());
                name.getIdentifierToken().putUserData(Keys.VARIABLE, variableOperand);
                name.putUserData(Keys.VARIABLE, variableOperand);
                PrimitiveExpression deltaExpression = (PrimitiveExpression)arg1;
                int delta = (Integer)JavaPrimitiveCast.cast(JvmType.Integer, deltaExpression.getValue());
                switch (delta) {
                    case -1: {
                        return new UnaryOperatorExpression(UnaryOperatorType.DECREMENT, name);
                    }
                    case 1: {
                        return new UnaryOperatorExpression(UnaryOperatorType.INCREMENT, name);
                    }
                }
                return new AssignmentExpression(name, AssignmentOperatorType.ADD, arg1);
            }
            case CmpEq: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.EQUALITY, arg2);
            }
            case CmpNe: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.INEQUALITY, arg2);
            }
            case CmpLt: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.LESS_THAN, arg2);
            }
            case CmpGe: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.GREATER_THAN_OR_EQUAL, arg2);
            }
            case CmpGt: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.GREATER_THAN, arg2);
            }
            case CmpLe: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.LESS_THAN_OR_EQUAL, arg2);
            }
            case Return: {
                return new ReturnStatement(byteCode.getOffset(), arg1);
            }
            case NewArray: {
                ArrayCreationExpression arrayCreation = new ArrayCreationExpression(byteCode.getOffset());
                TypeReference elementType = operandType.getUserData(Keys.TYPE_REFERENCE);
                while (elementType.isArray()) {
                    arrayCreation.getAdditionalArraySpecifiers().add(new ArraySpecifier());
                    elementType = elementType.getElementType();
                }
                arrayCreation.setType(this._astBuilder.convertType(elementType));
                arrayCreation.getDimensions().add(arg1);
                return arrayCreation;
            }
            case LogicalNot: {
                return new UnaryOperatorExpression(UnaryOperatorType.NOT, arg1);
            }
            case LogicalAnd: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.LOGICAL_AND, arg2);
            }
            case LogicalOr: {
                return new BinaryOperatorExpression(arg1, BinaryOperatorType.LOGICAL_OR, arg2);
            }
            case InitObject: {
                return this.transformCall(false, byteCode, arguments);
            }
            case InitArray: {
                ArrayCreationExpression arrayCreation = new ArrayCreationExpression(byteCode.getOffset());
                TypeReference elementType = operandType.getUserData(Keys.TYPE_REFERENCE);
                while (elementType.isArray()) {
                    arrayCreation.getAdditionalArraySpecifiers().add(new ArraySpecifier());
                    elementType = elementType.getElementType();
                }
                arrayCreation.setType(this._astBuilder.convertType(elementType));
                arrayCreation.setInitializer(new ArrayInitializerExpression(arguments));
                return arrayCreation;
            }
            case Wrap: {
                return null;
            }
            case TernaryOp: {
                return new ConditionalExpression(arg1, arg2, arg3);
            }
            case LoopOrSwitchBreak: {
                return label != null ? new GotoStatement(byteCode.getOffset(), label.getName()) : new BreakStatement(byteCode.getOffset());
            }
            case LoopContinue: {
                return label != null ? new ContinueStatement(byteCode.getOffset(), label.getName()) : new ContinueStatement(byteCode.getOffset());
            }
            case CompoundAssignment: {
                throw ContractUtils.unreachable();
            }
            case PreIncrement: {
                Integer incrementAmount = (Integer)operand;
                if (incrementAmount < 0) {
                    return new UnaryOperatorExpression(UnaryOperatorType.DECREMENT, arg1);
                }
                return new UnaryOperatorExpression(UnaryOperatorType.INCREMENT, arg1);
            }
            case PostIncrement: {
                Integer incrementAmount = (Integer)operand;
                if (incrementAmount < 0) {
                    return new UnaryOperatorExpression(UnaryOperatorType.POST_DECREMENT, arg1);
                }
                return new UnaryOperatorExpression(UnaryOperatorType.POST_INCREMENT, arg1);
            }
            case Box: 
            case Unbox: {
                throw ContractUtils.unreachable();
            }
            case Leave: 
            case EndFinally: {
                return null;
            }
            case DefaultValue: {
                return AstBuilder.makeDefaultValue((TypeReference)operand);
            }
        }
        Expression inlinedAssembly = AstMethodBodyBuilder.inlineAssembly(byteCode, arguments);
        if (isTopLevel) {
            return new CommentStatement(" " + inlinedAssembly.toString());
        }
        return inlinedAssembly;
    }

    private Expression transformCall(boolean isVirtual, com.strobel.decompiler.ast.Expression byteCode, List<Expression> arguments) {
        MethodDefinition resolvedMethod;
        Expression target;
        MethodReference methodReference = (MethodReference)byteCode.getOperand();
        boolean hasThis = byteCode.getCode() == AstCode.InvokeVirtual || byteCode.getCode() == AstCode.InvokeInterface || byteCode.getCode() == AstCode.InvokeSpecial;
        TypeReference declaringType = methodReference.getDeclaringType();
        if (hasThis) {
            target = arguments.remove(0);
            if (target instanceof NullReferenceExpression) {
                target = new CastExpression(this._astBuilder.convertType(declaringType), target);
            }
        } else if (!(byteCode.getCode() != AstCode.InvokeStatic || !declaringType.isEquivalentTo(this._context.getCurrentType()) || this._context.getSettings().getForceExplicitTypeArguments() && (resolvedMethod = methodReference.resolve()) != null && resolvedMethod.isGenericMethod())) {
            target = Expression.NULL;
        } else {
            ConvertTypeOptions options = new ConvertTypeOptions();
            options.setIncludeTypeArguments(false);
            options.setIncludeTypeParameterDefinitions(false);
            options.setAllowWildcards(false);
            target = new TypeReferenceExpression(byteCode.getOffset(), this._astBuilder.convertType(declaringType, options));
        }
        if (target instanceof ThisReferenceExpression) {
            if (!isVirtual && !declaringType.isEquivalentTo(this._method.getDeclaringType())) {
                target = new SuperReferenceExpression(byteCode.getOffset());
                target.putUserData(Keys.TYPE_REFERENCE, declaringType);
            }
        } else if (methodReference.isConstructor()) {
            ObjectCreationExpression creation;
            TypeDefinition resolvedType = declaringType.resolve();
            if (resolvedType != null) {
                TypeReference instantiatedType = resolvedType.isAnonymous() ? (resolvedType.getExplicitInterfaces().isEmpty() ? resolvedType.getBaseType() : resolvedType.getExplicitInterfaces().get(0)) : resolvedType;
                List<TypeReference> typeArguments = byteCode.getUserData(AstKeys.TYPE_ARGUMENTS);
                if (typeArguments != null && resolvedType.isGenericDefinition() && typeArguments.size() == resolvedType.getGenericParameters().size()) {
                    instantiatedType = instantiatedType.makeGenericType(typeArguments);
                }
                AstType declaredType = this._astBuilder.convertType(instantiatedType);
                creation = resolvedType.isAnonymous() ? new AnonymousObjectCreationExpression(byteCode.getOffset(), this._astBuilder.createType(resolvedType).clone(), declaredType) : new ObjectCreationExpression(byteCode.getOffset(), declaredType);
            } else {
                ConvertTypeOptions options = new ConvertTypeOptions();
                options.setIncludeTypeParameterDefinitions(false);
                creation = new ObjectCreationExpression(byteCode.getOffset(), this._astBuilder.convertType(declaringType, options));
            }
            creation.getArguments().addAll(this.adjustArgumentsForMethodCall(methodReference, arguments));
            creation.putUserData(Keys.MEMBER_REFERENCE, methodReference);
            return creation;
        }
        InvocationExpression invocation = methodReference.isConstructor() ? new InvocationExpression(byteCode.getOffset(), target, this.adjustArgumentsForMethodCall(methodReference, arguments)) : target.invoke(methodReference.getName(), this.convertTypeArguments(methodReference), this.adjustArgumentsForMethodCall(methodReference, arguments));
        invocation.putUserData(Keys.MEMBER_REFERENCE, methodReference);
        return invocation;
    }

    private List<AstType> convertTypeArguments(MethodReference methodReference) {
        List<TypeReference> typeArguments;
        if (this._context.getSettings().getForceExplicitTypeArguments() && methodReference instanceof IGenericInstance && !(typeArguments = ((IGenericInstance)((Object)methodReference)).getTypeArguments()).isEmpty()) {
            ArrayList<AstType> astTypeArguments = new ArrayList<AstType>();
            for (TypeReference type : typeArguments) {
                astTypeArguments.add(this._astBuilder.convertType(type));
            }
            return astTypeArguments;
        }
        return Collections.emptyList();
    }

    private List<Expression> adjustArgumentsForMethodCall(MethodReference method, List<Expression> arguments) {
        TypeDefinition resolvedType;
        TypeReference declaringType;
        if (!arguments.isEmpty() && method.isConstructor() && (declaringType = method.getDeclaringType()).isNested() && (resolvedType = declaringType.resolve()) != null) {
            MethodDefinition resolvedMethod;
            if (resolvedType.isLocalClass()) {
                return arguments;
            }
            if (resolvedType.isInnerClass() && (resolvedMethod = method.resolve()) != null && resolvedMethod.isSynthetic() && (resolvedMethod.getFlags() & 7L) == 0L) {
                TypeReference parameterType;
                TypeDefinition resolvedParameterType;
                List<ParameterDefinition> parameters = resolvedMethod.getParameters();
                int start = 0;
                int end = arguments.size();
                for (int i = parameters.size() - 1; i >= 0 && (resolvedParameterType = (parameterType = parameters.get(i).getParameterType()).resolve()) != null && resolvedParameterType.isAnonymous(); --i) {
                    --end;
                }
                if (!resolvedType.isStatic() && !this._context.getSettings().getShowSyntheticMembers()) {
                    ++start;
                }
                if (start > end) {
                    return Collections.emptyList();
                }
                return this.adjustArgumentsForMethodCallCore(method.getParameters().subList(start, end), arguments.subList(start, end));
            }
        }
        return this.adjustArgumentsForMethodCallCore(method.getParameters(), arguments);
    }

    private List<Expression> adjustArgumentsForMethodCallCore(List<ParameterDefinition> parameters, List<Expression> arguments) {
        int first;
        int parameterCount = parameters.size();
        assert (parameterCount == arguments.size());
        JavaResolver resolver = new JavaResolver(this._context);
        ConvertTypeOptions options = new ConvertTypeOptions();
        options.setAllowWildcards(false);
        int n = arguments.size();
        for (int i = 0; i < n; ++i) {
            Expression argument = arguments.get(i);
            ResolveResult resolvedArgument = resolver.apply(argument);
            if (resolvedArgument == null || argument instanceof LambdaExpression) continue;
            ParameterDefinition p = parameters.get(i);
            TypeReference aType = resolvedArgument.getType();
            TypeReference pType = p.getParameterType();
            if (!this.isCastRequired(pType, aType, true)) continue;
            arguments.set(i, new CastExpression(this._astBuilder.convertType(pType, options), argument));
        }
        int last = parameterCount - 1;
        for (first = 0; first < parameterCount && parameters.get(first).isSynthetic(); ++first) {
        }
        while (last >= 0 && parameters.get(last).isSynthetic()) {
            --last;
        }
        if (first >= parameterCount || last < 0) {
            return Collections.emptyList();
        }
        if (first == 0 && last == parameterCount - 1) {
            return arguments;
        }
        return arguments.subList(first, last + 1);
    }

    private boolean isCastRequired(TypeReference targetType, TypeReference sourceType, boolean exactMatch) {
        if (targetType == null || sourceType == null) {
            return false;
        }
        if (targetType.isPrimitive()) {
            return sourceType.getSimpleType() != targetType.getSimpleType();
        }
        if (exactMatch) {
            return !MetadataHelper.isSameType(targetType, sourceType, true);
        }
        return !MetadataHelper.isAssignableFrom(targetType, sourceType);
    }

    private static Expression inlineAssembly(com.strobel.decompiler.ast.Expression byteCode, List<Expression> arguments) {
        if (byteCode.getOperand() != null) {
            arguments.add(0, new IdentifierExpression(byteCode.getOffset(), AstMethodBodyBuilder.formatByteCodeOperand(byteCode.getOperand())));
        }
        return new IdentifierExpression(byteCode.getOffset(), byteCode.getCode().getName()).invoke(arguments);
    }

    private static String formatByteCodeOperand(Object operand) {
        if (operand == null) {
            return "";
        }
        PlainTextOutput output = new PlainTextOutput();
        DecompilerHelpers.writeOperand(output, operand);
        return output.toString();
    }
}

