/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;
import java.util.List;
import javax.lang.model.element.Modifier;

public class VariableDeclarationStatement
extends Statement {
    public static final Role<JavaModifierToken> MODIFIER_ROLE = EntityDeclaration.MODIFIER_ROLE;
    private boolean _anyModifiers;

    public VariableDeclarationStatement() {
        super(-34);
    }

    public VariableDeclarationStatement(AstType type, String name, int offset) {
        this(type, name, offset, null);
    }

    public VariableDeclarationStatement(AstType type, String name, Expression initializer) {
        this(type, name, -34, initializer);
    }

    public VariableDeclarationStatement(AstType type, String name, int offset, Expression initializer) {
        super(initializer == null ? offset : initializer.getOffset());
        this.setType(type);
        this.getVariables().add(new VariableInitializer(name, initializer));
    }

    public final boolean isAnyModifiers() {
        return this._anyModifiers;
    }

    public final void setAnyModifiers(boolean value) {
        this.verifyNotFrozen();
        this._anyModifiers = value;
    }

    public final List<Modifier> getModifiers() {
        return EntityDeclaration.getModifiers(this);
    }

    public final void addModifier(Modifier modifier) {
        EntityDeclaration.addModifier(this, modifier);
    }

    public final void removeModifier(Modifier modifier) {
        EntityDeclaration.removeModifier(this, modifier);
    }

    public final void setModifiers(List<Modifier> modifiers) {
        EntityDeclaration.setModifiers(this, modifiers);
    }

    public final AstType getType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setType(AstType value) {
        this.setChildByRole(Roles.TYPE, value);
    }

    public final JavaTokenNode getSemicolonToken() {
        return this.getChildByRole(Roles.SEMICOLON);
    }

    public final AstNodeCollection<VariableInitializer> getVariables() {
        return this.getChildrenByRole(Roles.VARIABLE);
    }

    public final VariableInitializer getVariable(final String name) {
        return this.getVariables().firstOrNullObject(new Predicate<VariableInitializer>(){

            @Override
            public boolean test(VariableInitializer variable) {
                return StringUtilities.equals(variable.getName(), name);
            }
        });
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitVariableDeclaration(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement otherDeclaration = (VariableDeclarationStatement)other;
            return !other.isNull() && this.getType().matches(otherDeclaration.getType(), match) && (this.isAnyModifiers() || otherDeclaration.isAnyModifiers() || this.getChildrenByRole(MODIFIER_ROLE).matches(otherDeclaration.getChildrenByRole(MODIFIER_ROLE), match)) && this.getVariables().matches(otherDeclaration.getVariables(), match);
        }
        return false;
    }
}

