/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.Lists;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ITypeLoader;
import cuchaz.enigma.CachingClasspathTypeLoader;
import cuchaz.enigma.CachingTypeLoader;
import cuchaz.enigma.ITranslatingTypeLoader;
import cuchaz.enigma.analysis.ParsedJar;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.bytecode.translators.TranslationClassVisitor;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.ReferencedEntryPool;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class TranslatingTypeLoader
extends CachingTypeLoader
implements ITranslatingTypeLoader {
    private static final ITypeLoader defaultTypeLoader = new CachingClasspathTypeLoader();
    private final ParsedJar jar;
    private final JarIndex jarIndex;
    private final ReferencedEntryPool entryPool;
    private final Translator obfuscatingTranslator;
    private final Translator deobfuscatingTranslator;

    public TranslatingTypeLoader(ParsedJar jar, JarIndex jarIndex, ReferencedEntryPool entryPool, Translator obfuscatingTranslator, Translator deobfuscatingTranslator) {
        this.jar = jar;
        this.jarIndex = jarIndex;
        this.entryPool = entryPool;
        this.obfuscatingTranslator = obfuscatingTranslator;
        this.deobfuscatingTranslator = deobfuscatingTranslator;
    }

    @Override
    protected byte[] doLoad(String className) {
        byte[] data = this.loadType(className);
        if (data == null) {
            Buffer parentBuf = new Buffer();
            if (defaultTypeLoader.tryLoadType(className, parentBuf)) {
                return parentBuf.array();
            }
            return EMPTY_ARRAY;
        }
        return data;
    }

    private byte[] loadType(String className) {
        ClassEntry classEntry = new ClassEntry(className);
        ClassEntry obfClassEntry = this.obfuscatingTranslator.translate(classEntry);
        if (!this.jarIndex.getEntryIndex().hasClass(obfClassEntry)) {
            return null;
        }
        ClassNode node = this.findClassInJar(obfClassEntry);
        if (node == null) {
            return null;
        }
        for (MethodNode methodNode : node.methods) {
            for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
                if (!(insnNode instanceof MethodInsnNode) || insnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                if (!methodInsnNode.name.equals("getClass") || !methodInsnNode.owner.equals("java/lang/Object") || !methodInsnNode.desc.equals("()Ljava/lang/Class;")) continue;
                AbstractInsnNode previous = methodInsnNode.getPrevious();
                AbstractInsnNode next = methodInsnNode.getNext();
                if (previous.getOpcode() != 89 || next.getOpcode() != 87) continue;
                insnNode = previous.getPrevious();
                methodNode.instructions.remove(previous);
                methodNode.instructions.remove(methodInsnNode);
                methodNode.instructions.remove(next);
            }
        }
        ClassWriter writer = new ClassWriter(0);
        this.transformInto(node, writer);
        return writer.toByteArray();
    }

    private ClassNode findClassInJar(ClassEntry obfClassEntry) {
        for (String className : this.getClassNamesToTry(obfClassEntry)) {
            ClassNode node = this.jar.getClassNode(className);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public List<String> getClassNamesToTry(String className) {
        return this.getClassNamesToTry(this.obfuscatingTranslator.translate(new ClassEntry(className)));
    }

    @Override
    public List<String> getClassNamesToTry(ClassEntry obfClassEntry) {
        ArrayList<String> classNamesToTry = Lists.newArrayList();
        classNamesToTry.add(obfClassEntry.getFullName());
        ClassEntry outerClass = obfClassEntry.getOuterClass();
        if (outerClass != null) {
            classNamesToTry.addAll(this.getClassNamesToTry(outerClass));
        }
        return classNamesToTry;
    }

    @Override
    public String transformInto(ClassNode node, ClassWriter writer) {
        node.accept(new TranslationClassVisitor(this.deobfuscatingTranslator, this.entryPool, 327680, writer));
        return this.deobfuscatingTranslator.translate(new ClassEntry(node.name)).getFullName();
    }
}

