/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class MethodInheritanceTreeNode
extends DefaultMutableTreeNode {
    private final Translator translator;
    private MethodEntry entry;
    private boolean isImplemented;

    public MethodInheritanceTreeNode(Translator translator, MethodEntry entry, boolean isImplemented) {
        this.translator = translator;
        this.entry = entry;
        this.isImplemented = isImplemented;
    }

    public static MethodInheritanceTreeNode findNode(MethodInheritanceTreeNode node, MethodEntry entry) {
        if (node.getMethodEntry().equals(entry)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            MethodInheritanceTreeNode foundNode = MethodInheritanceTreeNode.findNode((MethodInheritanceTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public MethodEntry getMethodEntry() {
        return this.entry;
    }

    public boolean isImplemented() {
        return this.isImplemented;
    }

    @Override
    public String toString() {
        MethodEntry translatedEntry = this.translator.translate(this.entry);
        String className = translatedEntry.getContainingClass().getFullName();
        if (!this.isImplemented) {
            return className;
        }
        String methodName = translatedEntry.getName();
        return className + "." + methodName + "()";
    }

    public void load(JarIndex index, boolean recurse) {
        ArrayList<MethodInheritanceTreeNode> nodes = Lists.newArrayList();
        EntryIndex entryIndex = index.getEntryIndex();
        InheritanceIndex inheritanceIndex = index.getInheritanceIndex();
        for (ClassEntry inheritorEntry : inheritanceIndex.getChildren((ClassEntry)this.entry.getParent())) {
            MethodEntry methodEntry = new MethodEntry(inheritorEntry, this.entry.getName(), this.entry.getDesc());
            nodes.add(new MethodInheritanceTreeNode(this.translator, methodEntry, entryIndex.hasMethod(methodEntry)));
        }
        nodes.forEach(this::add);
        if (recurse) {
            for (MethodInheritanceTreeNode node : nodes) {
                node.load(index, true);
            }
        }
    }
}

