/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import com.google.common.collect.Maps;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.analysis.index.RemappableIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class BridgeMethodIndex
implements JarIndexer,
RemappableIndex {
    private final EntryIndex entryIndex;
    private final ReferenceIndex referenceIndex;
    private Map<MethodEntry, MethodEntry> accessedToBridge = Maps.newHashMap();

    public BridgeMethodIndex(EntryIndex entryIndex, ReferenceIndex referenceIndex) {
        this.entryIndex = entryIndex;
        this.referenceIndex = referenceIndex;
    }

    @Override
    public void remap(Translator translator) {
        this.accessedToBridge = translator.translate(this.accessedToBridge);
    }

    @Override
    public BridgeMethodIndex remapped(Translator translator) {
        BridgeMethodIndex index = new BridgeMethodIndex(this.entryIndex, this.referenceIndex);
        index.accessedToBridge = translator.translate(this.accessedToBridge);
        return index;
    }

    @Override
    public void processIndex(EntryResolver resolver) {
        for (MethodEntry methodEntry : this.entryIndex.getMethods()) {
            AccessFlags access = this.entryIndex.getMethodAccess(methodEntry);
            if (access == null || !access.isSynthetic()) continue;
            this.indexSyntheticMethod(methodEntry, access);
        }
    }

    private void indexSyntheticMethod(MethodEntry syntheticMethod, AccessFlags access) {
        MethodEntry accessedMethod;
        if (access.isBridge() && (accessedMethod = this.findAccessMethod(syntheticMethod)) != null) {
            this.accessedToBridge.put(accessedMethod, syntheticMethod);
        }
    }

    private MethodEntry findAccessMethod(MethodEntry method) {
        Collection<MethodEntry> referencedMethods = this.referenceIndex.getMethodsReferencedBy(method);
        if (referencedMethods.size() != 1) {
            return null;
        }
        return referencedMethods.stream().findFirst().orElse(null);
    }

    @Nullable
    public MethodEntry getBridgeFromAccessed(MethodEntry entry) {
        return this.accessedToBridge.get(entry);
    }
}

