/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.ClassReferenceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.api.EnigmaPlugin;
import cuchaz.enigma.config.Config;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.dialog.ProgressDialog;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.ReadableToken;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GuiController {
    private Deobfuscator deobfuscator;
    private Gui gui;
    private SourceIndex index;
    private ClassEntry currentObfClass;
    private Deque<EntryReference<Entry<?>, Entry<?>>> referenceStack;
    private Path loadedMappingPath;
    private MappingFormat loadedMappingFormat;

    public GuiController(Gui gui) {
        this.gui = gui;
        this.deobfuscator = null;
        this.index = null;
        this.currentObfClass = null;
        this.referenceStack = Queues.newArrayDeque();
    }

    public boolean isDirty() {
        return this.deobfuscator.getMapper().isDirty();
    }

    public void openJar(JarFile jar) throws IOException {
        this.gui.onStartOpenJar("Loading JAR...");
        this.deobfuscator = new Deobfuscator(jar, this.gui::onStartOpenJar);
        this.gui.onFinishOpenJar(jar.getName());
        this.refreshClasses();
    }

    public void closeJar() {
        this.deobfuscator = null;
        this.gui.onCloseJar();
    }

    public void openMappings(MappingFormat format, Path path) throws IOException, MappingParseException {
        EntryTree<EntryMapping> mappings = format.read(path);
        this.deobfuscator.setMappings(mappings);
        this.gui.setMappingsFile(path);
        this.loadedMappingFormat = format;
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public void saveMappings(Path path) {
        this.saveMappings(this.loadedMappingFormat, path);
    }

    public void saveMappings(MappingFormat format, Path path) {
        EntryRemapper mapper = this.deobfuscator.getMapper();
        MappingDelta delta = mapper.takeMappingDelta();
        boolean saveAll = !path.equals(this.loadedMappingPath);
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> {
            if (saveAll) {
                format.write(mapper.getObfToDeobf(), path, progress);
            } else {
                format.write(mapper.getObfToDeobf(), delta, path, progress);
            }
        });
        this.loadedMappingFormat = format;
        this.loadedMappingPath = path;
    }

    public void closeMappings() {
        this.deobfuscator.setMappings(null);
        this.gui.setMappingsFile(null);
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public void exportSource(File dirOut) {
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> this.deobfuscator.writeSources(dirOut, progress));
    }

    public void exportJar(File fileOut) {
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> this.deobfuscator.writeJar(fileOut, progress));
    }

    public Token getToken(int pos) {
        if (this.index == null) {
            return null;
        }
        return this.index.getReferenceToken(pos);
    }

    @Nullable
    public EntryReference<Entry<?>, Entry<?>> getDeobfReference(Token token) {
        if (this.index == null) {
            return null;
        }
        return this.index.getDeobfReference(token);
    }

    public ReadableToken getReadableToken(Token token) {
        if (this.index == null) {
            return null;
        }
        return new ReadableToken(this.index.getLineNumber(token.start), this.index.getColumnNumber(token.start), this.index.getColumnNumber(token.end));
    }

    public boolean entryHasDeobfuscatedName(Entry<?> deobfEntry) {
        EntryResolver resolver = this.deobfuscator.getMapper().getDeobfResolver();
        Entry<?> resolvedEntry = resolver.resolveFirstEntry(deobfEntry, ResolutionStrategy.RESOLVE_ROOT);
        return this.deobfuscator.hasDeobfuscatedName(this.deobfuscator.getMapper().obfuscate(resolvedEntry));
    }

    public boolean entryIsInJar(Entry<?> deobfEntry) {
        if (deobfEntry == null) {
            return false;
        }
        return this.deobfuscator.isObfuscatedIdentifier(this.deobfuscator.getMapper().obfuscate(deobfEntry));
    }

    public boolean referenceIsRenameable(EntryReference<Entry<?>, Entry<?>> deobfReference) {
        if (deobfReference == null) {
            return false;
        }
        return this.deobfuscator.isRenameable(this.deobfuscator.getMapper().obfuscate(deobfReference));
    }

    public ClassInheritanceTreeNode getClassInheritance(ClassEntry deobfClassEntry) {
        ClassEntry obfClassEntry = this.deobfuscator.getMapper().obfuscate(deobfClassEntry);
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        ClassInheritanceTreeNode rootNode = this.deobfuscator.getIndexTreeBuilder().buildClassInheritance(translator, obfClassEntry);
        return ClassInheritanceTreeNode.findNode(rootNode, obfClassEntry);
    }

    public ClassImplementationsTreeNode getClassImplementations(ClassEntry deobfClassEntry) {
        ClassEntry obfClassEntry = this.deobfuscator.getMapper().obfuscate(deobfClassEntry);
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        return this.deobfuscator.getIndexTreeBuilder().buildClassImplementations(translator, obfClassEntry);
    }

    public MethodInheritanceTreeNode getMethodInheritance(MethodEntry deobfMethodEntry) {
        MethodEntry obfMethodEntry = this.deobfuscator.getMapper().obfuscate(deobfMethodEntry);
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        MethodInheritanceTreeNode rootNode = this.deobfuscator.getIndexTreeBuilder().buildMethodInheritance(translator, obfMethodEntry);
        return MethodInheritanceTreeNode.findNode(rootNode, obfMethodEntry);
    }

    public MethodImplementationsTreeNode getMethodImplementations(MethodEntry deobfMethodEntry) {
        MethodEntry obfMethodEntry = this.deobfuscator.getMapper().obfuscate(deobfMethodEntry);
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        List<MethodImplementationsTreeNode> rootNodes = this.deobfuscator.getIndexTreeBuilder().buildMethodImplementations(translator, obfMethodEntry);
        if (rootNodes.isEmpty()) {
            return null;
        }
        if (rootNodes.size() > 1) {
            System.err.println("WARNING: Method " + deobfMethodEntry + " implements multiple interfaces. Only showing first one.");
        }
        return MethodImplementationsTreeNode.findNode(rootNodes.get(0), obfMethodEntry);
    }

    public ClassReferenceTreeNode getClassReferences(ClassEntry deobfClassEntry) {
        ClassEntry obfClassEntry = this.deobfuscator.getMapper().obfuscate(deobfClassEntry);
        Translator deobfuscator = this.deobfuscator.getMapper().getDeobfuscator();
        ClassReferenceTreeNode rootNode = new ClassReferenceTreeNode(deobfuscator, obfClassEntry);
        rootNode.load(this.deobfuscator.getJarIndex(), true);
        return rootNode;
    }

    public FieldReferenceTreeNode getFieldReferences(FieldEntry deobfFieldEntry) {
        FieldEntry obfFieldEntry = this.deobfuscator.getMapper().obfuscate(deobfFieldEntry);
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        FieldReferenceTreeNode rootNode = new FieldReferenceTreeNode(translator, obfFieldEntry);
        rootNode.load(this.deobfuscator.getJarIndex(), true);
        return rootNode;
    }

    public MethodReferenceTreeNode getMethodReferences(MethodEntry deobfMethodEntry, boolean recursive) {
        MethodEntry obfMethodEntry = this.deobfuscator.getMapper().obfuscate(deobfMethodEntry);
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        MethodReferenceTreeNode rootNode = new MethodReferenceTreeNode(translator, obfMethodEntry);
        rootNode.load(this.deobfuscator.getJarIndex(), true, recursive);
        return rootNode;
    }

    public void rename(EntryReference<Entry<?>, Entry<?>> deobfReference, String newName, boolean refreshClassTree) {
        EntryReference<Entry<?>, Entry<?>> obfReference = this.deobfuscator.getMapper().obfuscate(deobfReference);
        this.deobfuscator.rename(obfReference.getNameableEntry(), newName);
        if (refreshClassTree && deobfReference.entry instanceof ClassEntry && !((ClassEntry)deobfReference.entry).isInnerClass()) {
            this.gui.moveClassTree(deobfReference, newName);
        }
        this.refreshCurrentClass(obfReference);
    }

    public void removeMapping(EntryReference<Entry<?>, Entry<?>> deobfReference) {
        EntryReference<Entry<?>, Entry<?>> obfReference = this.deobfuscator.getMapper().obfuscate(deobfReference);
        this.deobfuscator.removeMapping(obfReference.getNameableEntry());
        if (deobfReference.entry instanceof ClassEntry) {
            this.gui.moveClassTree(deobfReference, obfReference.entry.getName(), false, true);
        }
        this.refreshCurrentClass(obfReference);
    }

    public void markAsDeobfuscated(EntryReference<Entry<?>, Entry<?>> deobfReference) {
        EntryReference<Entry<?>, Entry<?>> obfReference = this.deobfuscator.getMapper().obfuscate(deobfReference);
        this.deobfuscator.markAsDeobfuscated(obfReference.getNameableEntry());
        if (deobfReference.entry instanceof ClassEntry && !((ClassEntry)deobfReference.entry).isInnerClass()) {
            this.gui.moveClassTree(deobfReference, obfReference.entry.getName(), true, false);
        }
        this.refreshCurrentClass(obfReference);
    }

    public void openDeclaration(Entry<?> deobfEntry) {
        if (deobfEntry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.openReference(new EntryReference(deobfEntry, deobfEntry.getName()));
    }

    public void openReference(EntryReference<Entry<?>, Entry<?>> deobfReference) {
        if (deobfReference == null) {
            throw new IllegalArgumentException("Reference cannot be null!");
        }
        EntryReference<Entry<?>, Entry<?>> obfReference = this.deobfuscator.getMapper().obfuscate(deobfReference);
        ClassEntry obfClassEntry = obfReference.getLocationClassEntry();
        if (!this.deobfuscator.isObfuscatedIdentifier(obfClassEntry)) {
            throw new IllegalArgumentException("Obfuscated class " + obfClassEntry + " was not found in the jar!");
        }
        if (this.currentObfClass == null || !this.currentObfClass.equals(obfClassEntry)) {
            this.currentObfClass = obfClassEntry;
            this.deobfuscate(this.currentObfClass, obfReference);
        } else {
            this.showReference(obfReference);
        }
    }

    private void showReference(EntryReference<Entry<?>, Entry<?>> obfReference) {
        EntryRemapper mapper = this.deobfuscator.getMapper();
        Collection tokens = mapper.getObfResolver().resolveReference(obfReference, ResolutionStrategy.RESOLVE_ROOT).stream().map(mapper::deobfuscate).flatMap(reference -> this.index.getReferenceTokens((EntryReference<Entry<?>, Entry<?>>)reference).stream()).collect(Collectors.toList());
        if (tokens.isEmpty()) {
            System.err.println(String.format("WARNING: no tokens found for %s in %s", tokens, this.currentObfClass));
        } else {
            this.gui.showTokens(tokens);
        }
    }

    public void savePreviousReference(EntryReference<Entry<?>, Entry<?>> deobfReference) {
        this.referenceStack.push(this.deobfuscator.getMapper().obfuscate(deobfReference));
    }

    public void openPreviousReference() {
        if (this.hasPreviousLocation()) {
            this.openReference((EntryReference)this.deobfuscator.getMapper().deobfuscate((Translatable)this.referenceStack.pop()));
        }
    }

    public boolean hasPreviousLocation() {
        return !this.referenceStack.isEmpty();
    }

    private void refreshClasses() {
        ArrayList<ClassEntry> obfClasses = Lists.newArrayList();
        ArrayList<ClassEntry> deobfClasses = Lists.newArrayList();
        this.deobfuscator.getSeparatedClasses(obfClasses, deobfClasses);
        this.gui.setObfClasses(obfClasses);
        this.gui.setDeobfClasses(deobfClasses);
    }

    public void refreshCurrentClass() {
        this.refreshCurrentClass(null);
    }

    private void refreshCurrentClass(EntryReference<Entry<?>, Entry<?>> obfReference) {
        if (this.currentObfClass != null) {
            this.deobfuscate(this.currentObfClass, obfReference);
        }
    }

    private void deobfuscate(ClassEntry classEntry, EntryReference<Entry<?>, Entry<?>> obfReference) {
        this.gui.setSource("(deobfuscating...)");
        new Thread(() -> {
            CompilationUnit sourceTree = this.deobfuscator.getSourceTree(classEntry.getFullName());
            if (sourceTree == null) {
                this.gui.setSource("Unable to find class: " + classEntry);
                return;
            }
            String source = this.deobfuscator.getSource(sourceTree);
            this.index = this.deobfuscator.getSourceIndex(sourceTree, source);
            String sourceString = this.index.getSource();
            ArrayList<Token> obfuscatedTokens = Lists.newArrayList();
            ArrayList<Token> proposedTokens = Lists.newArrayList();
            ArrayList<Token> deobfuscatedTokens = Lists.newArrayList();
            ArrayList<Token> otherTokens = Lists.newArrayList();
            int offset = 0;
            HashMap<Token, Token> tokenRemap = new HashMap<Token, Token>();
            boolean remapped = false;
            for (Token inToken : this.index.referenceTokens()) {
                Token token = inToken.move(offset);
                EntryReference<Entry<?>, Entry<?>> reference = this.index.getDeobfReference(inToken);
                if (this.referenceIsRenameable(reference)) {
                    Entry<?> obfEntry;
                    boolean added = false;
                    if (!this.entryHasDeobfuscatedName(reference.getNameableEntry()) && (obfEntry = this.deobfuscator.getMapper().obfuscate(reference.getNameableEntry())) instanceof FieldEntry) {
                        for (EnigmaPlugin plugin : this.deobfuscator.getPlugins()) {
                            String owner;
                            String proposal = plugin.proposeFieldName(owner = obfEntry.getContainingClass().getFullName(), obfEntry.getName(), ((FieldEntry)obfEntry).getDesc().toString());
                            if (proposal == null) continue;
                            proposedTokens.add(token);
                            offset += token.getRenameOffset(proposal);
                            sourceString = token.rename(sourceString, proposal);
                            added = true;
                            remapped = true;
                            break;
                        }
                    }
                    if (!added) {
                        if (this.entryHasDeobfuscatedName(reference.getNameableEntry())) {
                            deobfuscatedTokens.add(token);
                        } else {
                            obfuscatedTokens.add(token);
                        }
                    }
                } else {
                    otherTokens.add(token);
                }
                tokenRemap.put(inToken, token);
            }
            if (remapped) {
                this.index.remap(sourceString, tokenRemap);
            }
            this.gui.setSource(sourceString);
            if (obfReference != null) {
                this.showReference(obfReference);
            }
            this.gui.setEditorTheme(Config.getInstance().lookAndFeel);
            this.gui.setHighlightedTokens(ImmutableMap.of("obfuscated", obfuscatedTokens, "proposed", proposedTokens, "deobfuscated", deobfuscatedTokens, "other", otherTokens));
        }).start();
    }

    public Deobfuscator getDeobfuscator() {
        return this.deobfuscator;
    }

    public void modifierChange(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.deobfuscator.changeModifier((Entry<?>)this.gui.reference.entry, (AccessModifier)((Object)event.getItem()));
            this.refreshCurrentClass();
        }
    }
}

