/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.MappingTranslator;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.MappingValidator;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.VoidEntryResolver;
import cuchaz.enigma.translation.mapping.tree.DeltaTrackingTree;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.Collection;
import javax.annotation.Nullable;

public class EntryRemapper {
    private final EntryTree<EntryMapping> obfToDeobf;
    private final DeltaTrackingTree<EntryMapping> deobfToObf;
    private final JarIndex obfIndex;
    private final EntryResolver obfResolver;
    private EntryResolver deobfResolver;
    private final Translator deobfuscator;
    private Translator obfuscator;
    private final MappingValidator validator;

    private EntryRemapper(JarIndex jarIndex, EntryTree<EntryMapping> obfToDeobf, EntryTree<EntryMapping> deobfToObf) {
        this.obfToDeobf = obfToDeobf;
        this.deobfToObf = new DeltaTrackingTree<EntryMapping>(deobfToObf);
        this.obfIndex = jarIndex;
        this.obfResolver = jarIndex.getEntryResolver();
        this.deobfuscator = new MappingTranslator(obfToDeobf, this.obfResolver);
        this.rebuildDeobfIndex();
        this.validator = new MappingValidator(this.deobfToObf, this.deobfuscator, this.obfResolver);
    }

    public EntryRemapper(JarIndex jarIndex) {
        this(jarIndex, new HashEntryTree<EntryMapping>(), new HashEntryTree<EntryMapping>());
    }

    public EntryRemapper(JarIndex jarIndex, EntryTree<EntryMapping> deobfuscationTrees) {
        this(jarIndex, deobfuscationTrees, EntryRemapper.inverse(deobfuscationTrees));
    }

    private static EntryTree<EntryMapping> inverse(EntryTree<EntryMapping> tree) {
        MappingTranslator translator = new MappingTranslator(tree, VoidEntryResolver.INSTANCE);
        HashEntryTree<EntryMapping> inverse = new HashEntryTree<EntryMapping>();
        Collection<Entry<?>> entries = tree.getAllEntries();
        for (Entry<?> sourceEntry : entries) {
            Entry<?> targetEntry = translator.translate(sourceEntry);
            inverse.insert(targetEntry, new EntryMapping(sourceEntry.getName()));
        }
        return inverse;
    }

    private void rebuildDeobfIndex() {
        JarIndex deobfIndex = this.obfIndex.remapped(this.deobfuscator);
        this.deobfResolver = deobfIndex.getEntryResolver();
        this.obfuscator = new MappingTranslator(this.deobfToObf, this.deobfResolver);
    }

    public <E extends Entry<?>> void mapFromObf(E obfuscatedEntry, @Nullable EntryMapping deobfMapping) {
        Collection<E> resolvedEntries = this.obfResolver.resolveEntry(obfuscatedEntry, ResolutionStrategy.RESOLVE_ROOT);
        for (E resolvedEntry : resolvedEntries) {
            if (deobfMapping != null) {
                this.validator.validateRename(resolvedEntry, deobfMapping.getTargetName());
            }
            this.setObfToDeobf(resolvedEntry, deobfMapping);
        }
        this.rebuildDeobfIndex();
    }

    public <E extends Entry<?>> void mapFromDeobf(E deobfuscatedEntry, @Nullable EntryMapping deobfMapping) {
        E obfuscatedEntry = this.obfuscate(deobfuscatedEntry);
        this.mapFromObf(obfuscatedEntry, deobfMapping);
    }

    public void removeByObf(Entry<?> obfuscatedEntry) {
        this.mapFromObf(obfuscatedEntry, null);
    }

    public void removeByDeobf(Entry<?> deobfuscatedEntry) {
        this.mapFromObf(this.obfuscate(deobfuscatedEntry), null);
    }

    private <E extends Entry<?>> void setObfToDeobf(E obfuscatedEntry, @Nullable EntryMapping deobfMapping) {
        E prevDeobf = this.deobfuscate(obfuscatedEntry);
        this.obfToDeobf.insert(obfuscatedEntry, deobfMapping);
        E newDeobf = this.deobfuscate(obfuscatedEntry);
        EntryTreeNode<EntryMapping> node = this.deobfToObf.findNode(prevDeobf);
        if (node != null) {
            for (EntryTreeNode<EntryMapping> child : node.getNodesRecursively()) {
                Entry<?> entry = child.getEntry();
                EntryMapping mapping = new EntryMapping(this.obfuscate(entry).getName());
                this.deobfToObf.insert(entry.replaceAncestor(prevDeobf, newDeobf), mapping);
                this.deobfToObf.remove(entry);
            }
        } else {
            this.deobfToObf.insert(newDeobf, new EntryMapping(obfuscatedEntry.getName()));
        }
    }

    @Nullable
    public EntryMapping getDeobfMapping(Entry<?> entry) {
        return (EntryMapping)this.obfToDeobf.get(entry);
    }

    @Nullable
    public EntryMapping getObfMapping(Entry<?> entry) {
        return this.deobfToObf.get(entry);
    }

    public boolean hasDeobfMapping(Entry<?> obfEntry) {
        return this.obfToDeobf.contains(obfEntry);
    }

    public boolean hasObfMapping(Entry<?> deobfEntry) {
        return this.deobfToObf.contains(deobfEntry);
    }

    public <T extends Translatable> T deobfuscate(T translatable) {
        return this.deobfuscator.translate(translatable);
    }

    public <T extends Translatable> T obfuscate(T translatable) {
        return this.obfuscator.translate(translatable);
    }

    public Translator getDeobfuscator() {
        return this.deobfuscator;
    }

    public Translator getObfuscator() {
        return this.obfuscator;
    }

    public Collection<Entry<?>> getObfEntries() {
        return this.obfToDeobf.getAllEntries();
    }

    public Collection<Entry<?>> getObfRootEntries() {
        return this.obfToDeobf.getRootEntries();
    }

    public Collection<Entry<?>> getDeobfEntries() {
        return this.deobfToObf.getAllEntries();
    }

    public Collection<Entry<?>> getObfChildren(Entry<?> obfuscatedEntry) {
        return this.obfToDeobf.getChildren(obfuscatedEntry);
    }

    public Collection<Entry<?>> getDeobfChildren(Entry<?> deobfuscatedEntry) {
        return this.deobfToObf.getChildren(deobfuscatedEntry);
    }

    public EntryTree<EntryMapping> getObfToDeobf() {
        return this.obfToDeobf;
    }

    public DeltaTrackingTree<EntryMapping> getDeobfToObf() {
        return this.deobfToObf;
    }

    public MappingDelta takeMappingDelta() {
        MappingDelta delta = this.deobfToObf.takeDelta();
        return delta.translate(this.obfuscator, (EntryResolver)VoidEntryResolver.INSTANCE, this.deobfToObf);
    }

    public boolean isDirty() {
        return this.deobfToObf.isDirty();
    }

    public EntryResolver getObfResolver() {
        return this.obfResolver;
    }

    public EntryResolver getDeobfResolver() {
        return this.deobfResolver;
    }
}

