/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.mapping.NameValidator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public interface Entry<P extends Entry<?>>
extends Translatable {
    public String getName();

    @Nullable
    public P getParent();

    public Class<P> getParentType();

    public Entry<P> withParent(P var1);

    public boolean canConflictWith(Entry<?> var1);

    @Nullable
    default public ClassEntry getContainingClass() {
        P parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof ClassEntry) {
            return (ClassEntry)parent;
        }
        return parent.getContainingClass();
    }

    default public List<Entry<?>> getAncestry() {
        P parent = this.getParent();
        ArrayList entries = new ArrayList();
        if (parent != null) {
            entries.addAll(parent.getAncestry());
        }
        entries.add(this);
        return entries;
    }

    @Nullable
    default public <E extends Entry<?>> E findAncestor(Class<E> type) {
        List<Entry<?>> ancestry = this.getAncestry();
        for (int i = ancestry.size() - 1; i >= 0; --i) {
            Entry<?> ancestor = ancestry.get(i);
            if (!type.isAssignableFrom(ancestor.getClass())) continue;
            return (E)ancestor;
        }
        return null;
    }

    default public <E extends Entry<?>> Entry<P> replaceAncestor(E target, E replacement) {
        if (replacement.equals(target)) {
            return this;
        }
        if (this.equals(target)) {
            return replacement;
        }
        P parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return this.withParent(parent.replaceAncestor(target, replacement));
    }

    default public void validateName(String name) throws IllegalNameException {
        NameValidator.validateIdentifier(name);
    }

    @Nullable
    default public <C extends Entry<?>> Entry<C> castParent(Class<C> parentType) {
        if (parentType.equals(this.getParentType())) {
            return this;
        }
        return null;
    }
}

