/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula;

import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Graphics2D g3 = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig(g3);
        Color bg = c.getBackground();
        g3.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift(bg, 1.4), 0.0f, c.getHeight(), ColorUtil.shift(bg, 0.9)));
        int h2 = c.getHeight();
        int w = c.getWidth();
        g3.fillRect(0, 0, w, h2);
        g3.setPaint(ColorUtil.shift(bg, 0.75));
        g3.drawLine(0, h2 - 1, w, h2 - 1);
        g3.drawLine(w - 1, 0, w - 1, h2 - 1);
        Enumeration<TableColumn> columns = ((JTableHeader)c).getColumnModel().getColumns();
        Color lineColor = ColorUtil.shift(bg, 0.7);
        Color shadow = Gray._255.withAlpha(30);
        int offset = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (!columns.hasMoreElements() || column.getWidth() <= 0) continue;
            g3.setColor(lineColor);
            g3.drawLine((offset += column.getWidth()) - 1, 1, offset - 1, h2 - 3);
            g3.setColor(shadow);
            g3.drawLine(offset, 1, offset, h2 - 3);
        }
        config.restore();
        super.paint(g3, c);
    }
}

