/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Path2D;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import sun.swing.DefaultLookup;

public class DarculaComboBoxUI
extends BasicComboBoxUI
implements Border {
    private final JComboBox myComboBox;
    private Insets myPadding;

    public DarculaComboBoxUI(JComboBox comboBox) {
        this.myComboBox = comboBox;
        this.myComboBox.setBorder(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaComboBoxUI((JComboBox)c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.myPadding = UIManager.getInsets("ComboBox.padding");
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.myComboBox.getBackground();
        Color fg = this.myComboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g2) {
                Graphics2D g3 = (Graphics2D)g2;
                GraphicsConfig config = new GraphicsConfig(g3);
                int w = this.getWidth();
                int h2 = this.getHeight();
                if (!DarculaComboBoxUI.isTableCellEditor(DarculaComboBoxUI.this.myComboBox)) {
                    g3.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(UIUtil.getControlColor()));
                    g3.fillRect(0, 0, w, h2);
                }
                g3.setColor(DarculaComboBoxUI.this.comboBox.isEnabled() ? new DoubleColor(Gray._255, this.getForeground()) : new DoubleColor(Gray._255, this.getForeground().darker()));
                g3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g3.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g3.setStroke(new BasicStroke(1.0f, 0, 2));
                int xU = w / 4;
                int yU = h2 / 4;
                Path2D.Double path = new Path2D.Double();
                g3.translate(2, 0);
                path.moveTo(xU + 1, yU + 2);
                path.lineTo(3 * xU + 1, yU + 2);
                path.lineTo(2 * xU + 1, 3 * yU);
                path.lineTo(xU + 1, yU + 2);
                path.closePath();
                g3.fill(path);
                g3.translate(-2, 0);
                if (!DarculaComboBoxUI.isTableCellEditor(DarculaComboBoxUI.this.myComboBox)) {
                    g3.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(DarculaComboBoxUI.getBorderColor()));
                    g3.drawLine(0, -1, 0, h2);
                }
                config.restore();
            }

            @Override
            public Dimension getPreferredSize() {
                int size = this.getFont().getSize() + 4;
                if (size % 2 == 1) {
                    ++size;
                }
                return new DimensionUIResource(size, size);
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        return button;
    }

    protected Color getArrowButtonFillColor(Color defaultColor) {
        Color color;
        Color color2 = color = this.myComboBox.hasFocus() ? UIManager.getColor("ComboBox.darcula.arrowFocusedFillColor") : UIManager.getColor("ComboBox.darcula.arrowFillColor");
        return color == null ? defaultColor : (this.comboBox != null && !this.comboBox.isEnabled() ? UIUtil.getControlColor() : color);
    }

    @Override
    protected Insets getInsets() {
        return new InsetsUIResource(4, 7, 4, 5);
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Container parent = c.getParent();
        if (parent != null) {
            g2.setColor(parent.getBackground());
            g2.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Rectangle r = this.rectangleForCurrentValue();
        if (!DarculaComboBoxUI.isTableCellEditor(c)) {
            this.paintBorder(c, g2, 0, 0, c.getWidth(), c.getHeight());
            this.hasFocus = this.comboBox.hasFocus();
            this.paintCurrentValueBackground(g2, r, this.hasFocus);
        }
        this.paintCurrentValue(g2, r, this.hasFocus);
    }

    private static boolean isTableCellEditor(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty("JComboBox.isTableCellEditor"));
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle r = super.rectangleForCurrentValue();
        r.x -= 2;
        r.y = r.y - (DarculaComboBoxUI.isTableCellEditor(this.myComboBox) ? 0 : 1);
        return r;
    }

    @Override
    public void paintCurrentValue(Graphics g2, Rectangle bounds, boolean hasFocus) {
        boolean changeOpaque;
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getForeground());
            c.setBackground(this.listBox.getBackground());
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
            c.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        boolean bl = changeOpaque = c instanceof JComponent && DarculaComboBoxUI.isTableCellEditor(this.comboBox) && c.isOpaque();
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        Rectangle r = new Rectangle(bounds);
        if (this.myPadding != null) {
            r.x += this.myPadding.left;
            r.y += this.myPadding.top;
            r.width -= this.myPadding.left + this.myPadding.right;
            r.height -= this.myPadding.top + this.myPadding.bottom;
        }
        this.currentValuePane.paintComponent(g2, c, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() != null) {
            comboBoxEditor.getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code = e.getKeyCode();
                    if ((code == 38 || code == 40) && e.getModifiers() == 0) {
                        DarculaComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }
            });
            comboBoxEditor.getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    DarculaComboBoxUI.this.comboBox.revalidate();
                    DarculaComboBoxUI.this.comboBox.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    DarculaComboBoxUI.this.comboBox.revalidate();
                    DarculaComboBoxUI.this.comboBox.repaint();
                }
            });
        }
        return comboBoxEditor;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        this.hasFocus = false;
        this.checkFocus();
        Graphics2D g3 = (Graphics2D)g2;
        Rectangle arrowButtonBounds = this.arrowButton.getBounds();
        int xxx = arrowButtonBounds.x - 5;
        GraphicsConfig config = new GraphicsConfig(g3);
        g3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g3.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.editor != null && this.comboBox.isEditable()) {
            ((JComponent)this.editor).setBorder(null);
            g3.setColor(this.editor.getBackground());
            g3.fillRoundRect(x + 1, y + 1, width - 2, height - 4, 5, 5);
            g3.setColor(this.getArrowButtonFillColor(this.arrowButton.getBackground()));
            g3.fillRoundRect(xxx, y + 1, width - xxx, height - 4, 5, 5);
            g3.setColor(this.editor.getBackground());
            g3.fillRect(xxx, y + 1, 5, height - 4);
        } else {
            g3.setColor(UIUtil.getPanelBackground());
            g3.fillRoundRect(x + 1, y + 1, width - 2, height - 4, 5, 5);
            g3.setColor(this.getArrowButtonFillColor(this.arrowButton.getBackground()));
            g3.fillRoundRect(xxx, y + 1, width - xxx, height - 4, 5, 5);
            g3.setColor(UIUtil.getPanelBackground());
            g3.fillRect(xxx, y + 1, 5, height - 4);
        }
        Color borderColor = DarculaComboBoxUI.getBorderColor();
        g3.setColor(this.getArrowButtonFillColor(borderColor));
        int off = this.hasFocus ? 1 : 0;
        g3.drawLine(xxx + 5, y + 1 + off, xxx + 5, height - 3);
        Rectangle r = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(g3, r, this.hasFocus);
        this.paintCurrentValue(g3, r, false);
        if (this.hasFocus) {
            DarculaUIUtil.paintFocusRing(g3, 2, 2, width - 4, height - 5);
        } else {
            g3.setColor(borderColor);
            g3.drawRoundRect(1, 1, width - 2, height - 4, 5, 5);
        }
        config.restore();
    }

    private void checkFocus() {
        this.hasFocus = DarculaComboBoxUI.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        ComboBoxEditor ed = this.comboBox.getEditor();
        Component component = this.editor = ed == null ? null : ed.getEditorComponent();
        if (this.editor != null) {
            this.hasFocus = DarculaComboBoxUI.hasFocus(this.editor);
        }
    }

    private static boolean hasFocus(Component c) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    private static Color getBorderColor() {
        return new DoubleColor(Gray._150, Gray._100);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(4, 7, 4, 5);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        return super.getBaselineResizeBehavior(c);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return super.getBaseline(c, width, height);
    }
}

