/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jetbrains.annotations.NotNull;

public class DarculaSliderUI
extends BasicSliderUI {
    public DarculaSliderUI(JSlider b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaSliderUI((JSlider)c);
    }

    @Override
    public void paintFocus(Graphics g2) {
        super.paintFocus(g2);
    }

    @Override
    public void paintTrack(Graphics g2d) {
        Graphics2D g2 = (Graphics2D)g2d;
        Rectangle trackBounds = this.trackRect;
        int arc = JBUI.scale(6);
        int trackSize = JBUI.scale(6);
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
        Color bg = this.getTrackBackground();
        Color selection = this.getThumbColor();
        if (this.slider.getOrientation() == 0) {
            int cy = trackBounds.height / 2 - trackSize / 2;
            int cw = trackBounds.width;
            g2.translate(trackBounds.x, trackBounds.y + cy);
            Area shape = new Area(new RoundRectangle2D.Double(0.0, 0.0, cw, trackSize, arc, arc));
            g2.setColor(bg);
            g2.fill(shape);
            int x = this.thumbRect.x;
            shape.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, x, trackSize)));
            g2.setColor(selection);
            g2.fill(shape);
            g2.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            int cx = trackBounds.width / 2 - trackSize / 2;
            int ch = trackBounds.height;
            g2.translate(trackBounds.x + cx, trackBounds.y);
            Area shape = new Area(new RoundRectangle2D.Double(0.0, 0.0, cx, ch, arc, arc));
            g2.setColor(bg);
            g2.fill(shape);
            int y = this.thumbRect.y;
            shape.intersect(new Area(new Rectangle2D.Double(0.0, y, cx, ch)));
            g2.setColor(selection);
            g2.fill(shape);
            g2.translate(-(trackBounds.x + cx), -trackBounds.y);
        }
        config.restore();
    }

    @Override
    protected Dimension getThumbSize() {
        if (this.isPlainThumb()) {
            return new Dimension(JBUI.scale(20), JBUI.scale(20));
        }
        return this.slider.getOrientation() == 0 ? new JBDimension(12, 20) : new JBDimension(20, 12);
    }

    @NotNull
    protected Color getTrackBackground() {
        Color color = UIManager.getColor("Slider.trackBackground");
        if (color == null) {
            DarculaSliderUI.$$$reportNull$$$0(0);
        }
        return color;
    }

    @NotNull
    protected Color getSelectedTrackColor() {
        Color color = UIManager.getColor("Slider.selectedTrackColor");
        if (color == null) {
            DarculaSliderUI.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    protected Color getDisabledTickColor() {
        Color color = UIManager.getColor("Slider.disabledTickColor");
        if (color == null) {
            DarculaSliderUI.$$$reportNull$$$0(2);
        }
        return color;
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g2, Rectangle tickBounds, int x) {
        this.checkDisabled(g2);
        super.paintMinorTickForHorizSlider(g2, tickBounds, x);
    }

    private void checkDisabled(Graphics g2) {
        if (!this.slider.isEnabled()) {
            g2.setColor(this.getDisabledTickColor());
        }
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g2, Rectangle tickBounds, int x) {
        this.checkDisabled(g2);
        super.paintMajorTickForHorizSlider(g2, tickBounds, x);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g2, Rectangle tickBounds, int y) {
        this.checkDisabled(g2);
        super.paintMinorTickForVertSlider(g2, tickBounds, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g2, Rectangle tickBounds, int y) {
        this.checkDisabled(g2);
        super.paintMajorTickForVertSlider(g2, tickBounds, y);
    }

    @Override
    public void paintLabels(Graphics g2) {
        this.checkDisabled(g2);
        super.paintLabels(g2);
    }

    @Override
    protected void paintHorizontalLabel(Graphics g2, int value, Component label) {
        this.checkDisabled(g2);
        super.paintHorizontalLabel(g2, value, label);
    }

    @Override
    protected void paintVerticalLabel(Graphics g2, int value, Component label) {
        this.checkDisabled(g2);
        super.paintVerticalLabel(g2, value, label);
    }

    @Override
    public void paintThumb(Graphics g2) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
        Rectangle knobBounds = this.thumbRect;
        int w = knobBounds.width;
        int h2 = knobBounds.height;
        g2.translate(knobBounds.x, knobBounds.y);
        if (this.slider.isEnabled()) {
            g2.setColor(this.slider.getBackground());
        } else {
            g2.setColor(this.slider.getBackground().darker());
        }
        if (this.isPlainThumb()) {
            double r = this.slider.getOrientation() == 0 ? (double)h2 : (double)w;
            Ellipse2D.Double thumb = new Ellipse2D.Double(0.0, 0.0, r, r);
            Ellipse2D.Double innerThumb = new Ellipse2D.Double(1.0, 1.0, r - 2.0, r - 2.0);
            g2.setColor(this.getThumbBorderColor());
            ((Graphics2D)g2).fill(thumb);
            g2.setColor(this.getThumbColor());
            ((Graphics2D)g2).fill(innerThumb);
        } else if (this.slider.getOrientation() == 0) {
            int cw = w / 2;
            g2.setColor(this.getThumbBorderColor());
            Polygon p = new Polygon();
            p.addPoint(0, 0);
            p.addPoint(w - 1, 0);
            p.addPoint(w - 1, h2 - cw);
            p.addPoint(cw, h2 - 1);
            p.addPoint(0, h2 - cw);
            g2.fillPolygon(p);
            g2.setColor(this.getThumbColor());
            p = new Polygon();
            p.addPoint(1, 1);
            p.addPoint(w - 2, 1);
            p.addPoint(w - 2, h2 - cw - 1);
            p.addPoint(cw, h2 - 2);
            p.addPoint(1, h2 - cw - 1);
            g2.fillPolygon(p);
        } else {
            int cw = h2 / 2;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                g2.setColor(this.getThumbBorderColor());
                Polygon p = new Polygon();
                p.addPoint(0, 0);
                p.addPoint(w - cw, 0);
                p.addPoint(w - 1, h2 - cw);
                p.addPoint(w - cw, h2 - 1);
                p.addPoint(0, h2 - 1);
                g2.fillPolygon(p);
                g2.setColor(this.getThumbColor());
                p = new Polygon();
                p.addPoint(1, 1);
                p.addPoint(w - cw, 1);
                p.addPoint(w - 2, h2 - cw);
                p.addPoint(w - cw, h2 - 2);
                p.addPoint(1, h2 - 2);
                g2.fillPolygon(p);
            } else {
                g2.setColor(this.getThumbBorderColor());
                Polygon p = new Polygon();
                p.addPoint(w - 1, 0);
                p.addPoint(cw, 0);
                p.addPoint(0, h2 - cw);
                p.addPoint(cw, h2 - 1);
                p.addPoint(w - 1, h2 - 1);
                g2.fillPolygon(p);
                g2.setColor(this.getThumbColor());
                p = new Polygon();
                p.addPoint(w - 2, 1);
                p.addPoint(cw + 1, 1);
                p.addPoint(1, h2 - cw);
                p.addPoint(cw + 1, h2 - 2);
                p.addPoint(w - 2, h2 - 2);
                g2.fillPolygon(p);
            }
        }
        g2.translate(-knobBounds.x, -knobBounds.y);
        config.restore();
    }

    @NotNull
    protected Color getThumbColor() {
        Color color = this.slider.isEnabled() ? this.getSelectedTrackColor() : this.getDisabledTickColor();
        if (color == null) {
            DarculaSliderUI.$$$reportNull$$$0(3);
        }
        return color;
    }

    @NotNull
    protected Color getThumbBorderColor() {
        Color color = this.slider.isEnabled() ? UIManager.getColor("Slider.thumbBorderColor") : UIManager.getColor("Slider.thumbBorderColorDisabled");
        if (color == null) {
            DarculaSliderUI.$$$reportNull$$$0(4);
        }
        return color;
    }

    protected boolean isPlainThumb() {
        Boolean paintThumbArrowShape = (Boolean)this.slider.getClientProperty("Slider.paintThumbArrowShape");
        return !this.slider.getPaintTicks() && paintThumbArrowShape == null || paintThumbArrowShape == Boolean.FALSE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/bulenkov/darcula/ui/DarculaSliderUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackBackground";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTrackColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledTickColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThumbColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThumbBorderColor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

