/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaSpinnerBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        JSpinner spinner = (JSpinner)c;
        JFormattedTextField editor = UIUtil.findComponentOfType(spinner, JFormattedTextField.class);
        int x1 = x + 1;
        int y1 = y + 3;
        int width1 = width - 2;
        int height1 = height - 6;
        boolean focused = c.isEnabled() && c.isVisible() && editor != null && editor.hasFocus();
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
        if (c.isOpaque()) {
            g2.setColor(UIUtil.getPanelBackground());
            g2.fillRect(x, y, width, height);
        }
        g2.setColor(UIUtil.getTextFieldBackground());
        g2.fillRoundRect(x1, y1, width1, height1, 5, 5);
        g2.setColor(UIManager.getColor(spinner.isEnabled() ? "Spinner.darcula.enabledButtonColor" : "Spinner.darcula.disabledButtonColor"));
        if (editor != null) {
            int off = editor.getBounds().x + editor.getWidth() + ((JSpinner)c).getInsets().left + 1;
            Area rect = new Area(new RoundRectangle2D.Double(x1, y1, width1, height1, 5.0, 5.0));
            Area blueRect = new Area(new Rectangle(off, y1, 22, height1));
            rect.intersect(blueRect);
            ((Graphics2D)g2).fill(rect);
            if (UIUtil.isUnderDarcula()) {
                g2.setColor(Gray._100);
                g2.drawLine(off, y1, off, height1 + 2);
            }
        }
        if (!c.isEnabled()) {
            ((Graphics2D)g2).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        if (focused) {
            DarculaUIUtil.paintFocusRing(g2, x1 + 2, y1, width1 - 3, height1);
        } else {
            g2.setColor(new DoubleColor(Gray._149, Gray._100));
            g2.drawRoundRect(x1, y1, width1, height1, 5, 5);
        }
        config.restore();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(5, 7, 5, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

