/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.IsRetina;
import com.bulenkov.iconloader.JBHiDPIScaledImage;
import com.bulenkov.iconloader.RetinaImage;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.JBUI;
import com.bulenkov.iconloader.util.Pair;
import com.bulenkov.iconloader.util.Ref;
import com.bulenkov.iconloader.util.Registry;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.reflect.Field;
import javax.swing.GrayFilter;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private static volatile Pair<String, Integer> ourSystemFontData;
    public static final float DEF_SYSTEM_FONT_SIZE = 12.0f;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final Ref<Boolean> ourRetina;
    private static final GrayFilter DEFAULT_GRAY_FILTER;
    private static final GrayFilter DARCULA_GRAY_FILTER;

    public static <T extends JComponent> T findComponentOfType(JComponent parent, Class<T> cls) {
        if (parent == null || cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            return (T)t;
        }
        for (Component component : parent.getComponents()) {
            T comp;
            if (!(component instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    @Nullable
    public static Pair<String, Integer> getSystemFontData() {
        return ourSystemFontData;
    }

    public static <T> T getParentOfType(Class<? extends T> cls, Component c) {
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!cls.isAssignableFrom(eachParent.getClass())) continue;
            Component t = eachParent;
            return (T)t;
        }
        return null;
    }

    public static boolean isAppleRetina() {
        return UIUtil.isRetina() && SystemInfo.isAppleJvm;
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Color getPanelBackground() {
        return UIManager.getColor("Panel.background");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().equals("Darcula");
    }

    public static Color getListBackground() {
        return UIManager.getColor("List.background");
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Color getTreeSelectionForeground() {
        return UIManager.getColor("Tree.selectionForeground");
    }

    public static Color getTreeForeground() {
        return UIManager.getColor("Tree.foreground");
    }

    public static Color getDecoratedRowColor() {
        return DECORATED_ROW_BG_COLOR;
    }

    public static Color getTreeSelectionBackground(boolean focused) {
        return focused ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground();
    }

    private static Color getTreeSelectionBackground() {
        return UIManager.getColor("Tree.selectionBackground");
    }

    public static Color getTreeUnfocusedSelectionBackground() {
        Color background = UIUtil.getTreeTextBackground();
        return ColorUtil.isDark(background) ? new DoubleColor(Gray._30, new Color(13, 41, 62)) : Gray._212;
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static void drawImage(Graphics g2, Image image, int x, int y, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g2.create(x, y, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, 0, 0, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g2.drawImage(image, x, y, observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                if (SystemInfo.isJavaVersionAtLeast("1.6.0_33") && SystemInfo.isAppleJvm) {
                    if (!"false".equals(System.getProperty("ide.mac.retina"))) {
                        ourRetina.set(IsRetina.isRetina());
                        return ourRetina.get();
                    }
                } else if (SystemInfo.isJavaVersionAtLeast("1.7.0_40") && (SystemInfo.isOracleJvm || SystemInfo.isJetbrainsJvm)) {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    try {
                        Field field = device.getClass().getDeclaredField("scale");
                        if (field != null) {
                            field.setAccessible(true);
                            Object scale = field.get(device);
                            if (scale instanceof Integer && (Integer)scale == 2) {
                                ourRetina.set(true);
                                return true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ourRetina.set(false);
            }
            return ourRetina.get();
        }
    }

    public static BufferedImage createImage(int width, int height, int type) {
        if (UIUtil.isRetina()) {
            return RetinaImage.create(width, height, type);
        }
        return new BufferedImage(width, height, type);
    }

    public static GrayFilter getGrayFilter() {
        return UIUtil.isUnderDarcula() ? DARCULA_GRAY_FILTER : DEFAULT_GRAY_FILTER;
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static float getFontSize(FontSize size) {
        int defSize = UIUtil.getLabelFont().getSize();
        switch (size) {
            case SMALL: {
                return Math.max((float)defSize - JBUI.scale(2.0f), JBUI.scale(11.0f));
            }
            case MINI: {
                return Math.max((float)defSize - JBUI.scale(4.0f), JBUI.scale(9.0f));
            }
        }
        return defSize;
    }

    public static void initSystemFontData() {
        Font winFont;
        if (ourSystemFontData != null) {
            return;
        }
        Font font = UIUtil.getLabelFont();
        Float forcedScale = null;
        if (Registry.is("ide.ui.scale.override")) {
            forcedScale = Registry.getFloat("ide.ui.scale");
        } else if (SystemInfo.isLinux && !SystemInfo.isJetbrainsJvm) {
            float scale = UIUtil.getScreenScale();
            if (scale > 1.0f) {
                forcedScale = Float.valueOf(scale);
            }
        } else if (SystemInfo.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
        }
        if (forcedScale != null) {
            font = font.deriveFont(12.0f * forcedScale.floatValue());
        }
        ourSystemFontData = Pair.create(font.getName(), font.getSize());
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        float scale = 1.0f;
        scale = dpi < 120 ? 1.0f : (dpi < 144 ? 1.25f : (dpi < 168 ? 1.5f : (dpi < 192 ? 1.75f : 2.0f)));
        return scale;
    }

    static {
        DECORATED_ROW_BG_COLOR = new DoubleColor(new Color(242, 245, 249), new Color(65, 69, 71));
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        DEFAULT_GRAY_FILTER = new GrayFilter(true, 65);
        DARCULA_GRAY_FILTER = new GrayFilter(true, 30);
    }

    public static enum FontSize {
        NORMAL,
        SMALL,
        MINI;

    }
}

