/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.ArrayType;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.Error;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.ICapturedType;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterizedType;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.util.ContractUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class TypeReference
extends MemberReference
implements IGenericParameterProvider,
IGenericContext {
    private String _name;
    private TypeReference _declaringType;
    private ArrayType _arrayType;

    @Override
    public boolean containsGenericParameters() {
        if (this.isGenericType()) {
            if (this.isGenericDefinition()) {
                if (this.hasGenericParameters()) {
                    return true;
                }
            } else if (this instanceof IGenericInstance) {
                List<TypeReference> typeArguments = ((IGenericInstance)((Object)this)).getTypeArguments();
                int n = typeArguments.size();
                for (int i = 0; i < n; ++i) {
                    if (!typeArguments.get(i).containsGenericParameters()) continue;
                    return true;
                }
            }
        }
        return super.containsGenericParameters();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getPackageName() {
        return "";
    }

    @Override
    public TypeReference getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public boolean isEquivalentTo(MemberReference member) {
        return member instanceof TypeReference && MetadataResolver.areEquivalent(this, (TypeReference)member);
    }

    protected void setName(String name) {
        this._name = name;
    }

    protected final void setDeclaringType(TypeReference declaringType) {
        this._declaringType = declaringType;
    }

    public abstract String getSimpleName();

    @Override
    public String getFullName() {
        StringBuilder name = new StringBuilder();
        this.appendName(name, true, true);
        return name.toString();
    }

    public String getInternalName() {
        StringBuilder name = new StringBuilder();
        this.appendName(name, true, false);
        return name.toString();
    }

    public TypeReference getUnderlyingType() {
        return this;
    }

    public TypeReference getElementType() {
        return null;
    }

    public abstract <R, P> R accept(TypeMetadataVisitor<P, R> var1, P var2);

    public int hashCode() {
        return this.getInternalName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TypeReference && MetadataHelper.isSameType(this, (TypeReference)obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeReference makeArrayType() {
        if (this._arrayType == null) {
            TypeReference typeReference = this;
            synchronized (typeReference) {
                if (this._arrayType == null) {
                    this._arrayType = ArrayType.create(this);
                }
            }
        }
        return this._arrayType;
    }

    public TypeReference makeGenericType(List<? extends TypeReference> typeArguments) {
        VerifyArgument.notNull(typeArguments, "typeArguments");
        return this.makeGenericType(typeArguments.toArray(new TypeReference[typeArguments.size()]));
    }

    public TypeReference makeGenericType(TypeReference ... typeArguments) {
        VerifyArgument.noNullElementsAndNotEmpty(typeArguments, "typeArguments");
        TypeReference[] adjustedTypeArguments = Arrays.copyOf(typeArguments, typeArguments.length);
        if (TypeReference.checkRecursive(this, ArrayUtilities.asUnmodifiableList(adjustedTypeArguments))) {
            for (int i = 0; i < adjustedTypeArguments.length; ++i) {
                TypeReference t = adjustedTypeArguments[i];
                adjustedTypeArguments[i] = t.isGenericType() ? t.getRawType() : t;
            }
        }
        if (this.isGenericDefinition()) {
            return new ParameterizedType(this, ArrayUtilities.asUnmodifiableList(adjustedTypeArguments));
        }
        if (this instanceof IGenericInstance) {
            return new ParameterizedType((TypeReference)((IGenericInstance)((Object)this)).getGenericDefinition(), ArrayUtilities.asUnmodifiableList(adjustedTypeArguments));
        }
        throw Error.notGenericType(this);
    }

    public boolean isWildcardType() {
        return false;
    }

    public boolean isCompoundType() {
        return false;
    }

    public boolean isBoundedType() {
        return this.isGenericParameter() || this.isWildcardType() || this instanceof ICapturedType || this instanceof CompoundTypeReference;
    }

    public boolean isUnbounded() {
        return true;
    }

    public boolean hasExtendsBound() {
        return this.isGenericParameter() || this.isWildcardType() && !BuiltinTypes.Object.equals(this.getExtendsBound()) && MetadataResolver.areEquivalent(BuiltinTypes.Bottom, this.getSuperBound());
    }

    public boolean hasSuperBound() {
        return this.isWildcardType() && !MetadataResolver.areEquivalent(BuiltinTypes.Bottom, this.getSuperBound());
    }

    public TypeReference getExtendsBound() {
        throw ContractUtils.unsupported();
    }

    public TypeReference getSuperBound() {
        throw ContractUtils.unsupported();
    }

    public JvmType getSimpleType() {
        return JvmType.Object;
    }

    public boolean isNested() {
        return this.getDeclaringType() != null && !this.isGenericParameter();
    }

    public boolean isArray() {
        return this.getSimpleType() == JvmType.Array;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isVoid() {
        return false;
    }

    @Override
    public boolean hasGenericParameters() {
        return !this.getGenericParameters().isEmpty();
    }

    @Override
    public boolean isGenericDefinition() {
        return this.hasGenericParameters() && this.isDefinition();
    }

    @Override
    public List<GenericParameter> getGenericParameters() {
        return Collections.emptyList();
    }

    public boolean isGenericParameter() {
        return this.getSimpleType() == JvmType.TypeVariable;
    }

    public boolean isGenericType() {
        return this.hasGenericParameters();
    }

    public TypeReference getRawType() {
        if (this.isGenericType()) {
            TypeReference underlyingType = this.getUnderlyingType();
            if (underlyingType != this) {
                return underlyingType.getRawType();
            }
            return new RawType(this);
        }
        throw ContractUtils.unsupported();
    }

    @Override
    public GenericParameter findTypeVariable(String name) {
        for (GenericParameter genericParameter : this.getGenericParameters()) {
            if (!StringUtilities.equals(genericParameter.getName(), name)) continue;
            return genericParameter;
        }
        TypeReference declaringType = this.getDeclaringType();
        if (declaringType != null) {
            return declaringType.findTypeVariable(name);
        }
        return null;
    }

    public String getBriefDescription() {
        return this.appendBriefDescription(new StringBuilder()).toString();
    }

    public String getDescription() {
        return this.appendDescription(new StringBuilder()).toString();
    }

    public String getErasedDescription() {
        return this.appendErasedDescription(new StringBuilder()).toString();
    }

    public String getSimpleDescription() {
        return this.appendSimpleDescription(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        String packageName;
        String simpleName = this.getSimpleName();
        TypeReference declaringType = this.getDeclaringType();
        if (dottedName && simpleName != null && declaringType != null) {
            return declaringType.appendName(sb, fullName, true).append('.').append(simpleName);
        }
        String name = fullName ? this.getName() : simpleName;
        String string = packageName = fullName ? this.getPackageName() : null;
        if (StringUtilities.isNullOrEmpty(packageName)) {
            return sb.append(name);
        }
        if (dottedName) {
            return sb.append(packageName).append('.').append(name);
        }
        int packageEnd = packageName.length();
        for (int i = 0; i < packageEnd; ++i) {
            char c = packageName.charAt(i);
            sb.append(c == '.' ? (char)'/' : (char)c);
        }
        sb.append('/');
        return sb.append(name);
    }

    protected StringBuilder appendBriefDescription(StringBuilder sb) {
        StringBuilder s2 = this.appendName(sb, true, true);
        List<TypeReference> typeArguments = this instanceof IGenericInstance ? ((IGenericInstance)((Object)this)).getTypeArguments() : (this.isGenericDefinition() ? this.getGenericParameters() : Collections.emptyList());
        int count = typeArguments.size();
        if (count > 0) {
            s2.append('<');
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    s2.append(", ");
                }
                s2 = typeArguments.get(i).appendBriefDescription(s2);
            }
            s2.append('>');
        }
        return s2;
    }

    protected StringBuilder appendSimpleDescription(StringBuilder sb) {
        List<TypeReference> typeArguments;
        int count;
        StringBuilder s2 = sb.append(this.getSimpleName());
        if (this.isGenericType() && (count = (typeArguments = this instanceof IGenericInstance ? ((IGenericInstance)((Object)this)).getTypeArguments() : this.getGenericParameters()).size()) > 0) {
            s2.append('<');
            for (int i = 0; i < count; ++i) {
                TypeReference typeArgument;
                if (i != 0) {
                    s2.append(", ");
                }
                if ((typeArgument = typeArguments.get(i)) instanceof GenericParameter) {
                    s2.append(typeArgument.getSimpleName());
                    continue;
                }
                s2 = typeArgument.appendSimpleDescription(s2);
            }
            s2.append('>');
        }
        return s2;
    }

    protected StringBuilder appendErasedDescription(StringBuilder sb) {
        return this.appendName(sb, true, true);
    }

    protected StringBuilder appendDescription(StringBuilder sb) {
        List<TypeReference> typeArguments;
        int count;
        StringBuilder s2 = this.appendName(sb, false, true);
        if (this instanceof IGenericInstance && (count = (typeArguments = ((IGenericInstance)((Object)this)).getTypeArguments()).size()) > 0) {
            s2.append('<');
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    s2.append(", ");
                }
                s2 = typeArguments.get(i).appendBriefDescription(s2);
            }
            s2.append('>');
        }
        return s2;
    }

    @Override
    protected StringBuilder appendSignature(StringBuilder sb) {
        if (this.isGenericParameter()) {
            sb.append('T');
            sb.append(this.getName());
            sb.append(';');
            return sb;
        }
        return this.appendClassSignature(sb);
    }

    @Override
    protected StringBuilder appendErasedSignature(StringBuilder sb) {
        if (this.isGenericType() && !this.isGenericDefinition()) {
            return this.getUnderlyingType().appendErasedSignature(sb);
        }
        return this.appendErasedClassSignature(sb);
    }

    @Override
    public String toString() {
        return this.getBriefDescription();
    }

    protected StringBuilder appendGenericSignature(StringBuilder sb) {
        List<TypeReference> typeArguments;
        int count;
        StringBuilder s2 = sb;
        if (this.isGenericParameter()) {
            TypeReference extendsBound = this.getExtendsBound();
            TypeDefinition resolvedBound = extendsBound.resolve();
            s2.append(this.getName());
            if (resolvedBound != null && resolvedBound.isInterface()) {
                s2.append(':');
            }
            s2.append(':');
            s2 = extendsBound.appendSignature(s2);
            return s2;
        }
        if (this instanceof IGenericInstance && (count = (typeArguments = ((IGenericInstance)((Object)this)).getTypeArguments()).size()) > 0) {
            s2.append('<');
            for (int i = 0; i < count; ++i) {
                s2 = typeArguments.get(i).appendGenericSignature(s2);
            }
            s2.append('>');
        }
        return s2;
    }

    protected StringBuilder appendClassSignature(StringBuilder sb) {
        List<TypeReference> typeArguments;
        int count;
        StringBuilder s2 = sb;
        s2.append('L');
        s2 = this.appendName(s2, true, false);
        if (this instanceof IGenericInstance && (count = (typeArguments = ((IGenericInstance)((Object)this)).getTypeArguments()).size()) > 0) {
            s2.append('<');
            for (int i = 0; i < count; ++i) {
                TypeReference type = typeArguments.get(i);
                s2 = type.isGenericDefinition() ? type.appendErasedSignature(s2) : type.appendSignature(s2);
            }
            s2.append('>');
        }
        s2.append(';');
        return s2;
    }

    protected StringBuilder appendErasedClassSignature(StringBuilder sb) {
        sb.append('L');
        sb = this.appendName(sb, true, false);
        sb.append(';');
        return sb;
    }

    protected StringBuilder appendClassDescription(StringBuilder sb) {
        List<TypeReference> typeArguments;
        int count;
        StringBuilder s2 = sb;
        this.appendName(sb, true, true);
        if (this instanceof IGenericInstance && (count = (typeArguments = ((IGenericInstance)((Object)this)).getTypeArguments()).size()) > 0) {
            s2.append('<');
            for (int i = 0; i < count; ++i) {
                s2 = typeArguments.get(i).appendErasedClassSignature(s2);
            }
            s2.append('>');
        }
        return s2;
    }

    public TypeDefinition resolve() {
        TypeReference declaringType = this.getDeclaringType();
        return declaringType != null ? declaringType.resolve(this) : null;
    }

    public FieldDefinition resolve(FieldReference field) {
        TypeDefinition resolvedType = this.resolve();
        if (resolvedType != null) {
            return MetadataResolver.getField(resolvedType.getDeclaredFields(), field);
        }
        return null;
    }

    public MethodDefinition resolve(MethodReference method) {
        TypeDefinition resolvedType = this.resolve();
        if (resolvedType != null) {
            return MetadataResolver.getMethod(resolvedType.getDeclaredMethods(), method);
        }
        return null;
    }

    public TypeDefinition resolve(TypeReference type) {
        TypeDefinition resolvedType = this.resolve();
        if (resolvedType != null) {
            return MetadataResolver.getNestedType(resolvedType.getDeclaredTypes(), type);
        }
        return null;
    }

    protected static boolean checkRecursive(TypeReference type, List<? extends TypeReference> arguments) {
        if (type.isGenericParameter() || type.isWildcardType()) {
            return false;
        }
        return TypeReference.checkRecursiveCore(type.getInternalName(), arguments, 0);
    }

    private static boolean checkRecursiveCore(String typeName, List<? extends TypeReference> arguments, int depth) {
        for (TypeReference typeReference : arguments) {
            String argumentName;
            if (!(typeReference instanceof IGenericInstance) || !StringUtilities.equals(argumentName = typeReference.getInternalName(), typeName)) continue;
            if (depth > 3) {
                return true;
            }
            if (!TypeReference.checkRecursiveCore(typeName, ((IGenericInstance)((Object)typeReference)).getTypeArguments(), depth + 1)) continue;
            return true;
        }
        return false;
    }
}

