/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.ir.attributes.AnnotationDefaultAttribute;
import com.strobel.assembler.ir.attributes.LineNumberTableAttribute;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IMemberDefinition;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.PackageReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.AnnotationAnnotationElement;
import com.strobel.assembler.metadata.annotations.AnnotationElement;
import com.strobel.assembler.metadata.annotations.AnnotationParameter;
import com.strobel.assembler.metadata.annotations.ArrayAnnotationElement;
import com.strobel.assembler.metadata.annotations.ClassAnnotationElement;
import com.strobel.assembler.metadata.annotations.ConstantAnnotationElement;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.assembler.metadata.annotations.EnumAnnotationElement;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.Closeables;
import com.strobel.core.MutableInteger;
import com.strobel.core.Predicate;
import com.strobel.core.SafeCloseable;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.ast.TypeAnalysis;
import com.strobel.decompiler.languages.LineNumberPosition;
import com.strobel.decompiler.languages.java.JavaOutputVisitor;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.ArrayInitializerExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstMethodBodyBuilder;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ClassType;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.CommentType;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ConvertTypeOptions;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.ImportDeclaration;
import com.strobel.decompiler.languages.java.ast.InsertParenthesesVisitor;
import com.strobel.decompiler.languages.java.ast.JavaPrimitiveCast;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.PackageDeclaration;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TextNode;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.UnixNewLine;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.ast.WildcardType;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import com.strobel.decompiler.languages.java.ast.transforms.TransformationPipeline;
import com.strobel.util.ContractUtils;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

public final class AstBuilder {
    private final DecompilerContext _context;
    private final CompilationUnit _compileUnit = new CompilationUnit();
    private final Map<String, Reference<TypeDeclaration>> _typeDeclarations = new LinkedHashMap<String, Reference<TypeDeclaration>>();
    private final Map<String, String> _unqualifiedTypeNames = new LinkedHashMap<String, String>();
    private final TextNode _packagePlaceholder;
    private boolean _decompileMethodBodies = true;
    private boolean _haveTransformationsRun;
    private int _suppressImportsDepth;

    public AstBuilder(DecompilerContext context) {
        this._context = VerifyArgument.notNull(context, "context");
        String headerText = context.getSettings().getOutputFileHeaderText();
        if (!StringUtilities.isNullOrWhitespace(headerText)) {
            List<String> lines = StringUtilities.split(headerText, false, '\n', new char[0]);
            for (String line : lines) {
                this._compileUnit.addChild(new Comment(" " + line.trim(), CommentType.SingleLine), Roles.COMMENT);
            }
            this._compileUnit.addChild(new UnixNewLine(), Roles.NEW_LINE);
        }
        this._packagePlaceholder = new TextNode();
        this._compileUnit.addChild(this._packagePlaceholder, Roles.TEXT);
        if (this._context.getUserData(Keys.AST_BUILDER) == null) {
            this._context.putUserData(Keys.AST_BUILDER, this);
        }
    }

    final DecompilerContext getContext() {
        return this._context;
    }

    public final boolean areImportsSuppressed() {
        return this._suppressImportsDepth > 0;
    }

    public final SafeCloseable suppressImports() {
        ++this._suppressImportsDepth;
        return Closeables.create(new Runnable(){

            @Override
            public void run() {
                --AstBuilder.this._suppressImportsDepth;
            }
        });
    }

    public final boolean getDecompileMethodBodies() {
        return this._decompileMethodBodies;
    }

    public final void setDecompileMethodBodies(boolean decompileMethodBodies) {
        this._decompileMethodBodies = decompileMethodBodies;
    }

    public final CompilationUnit getCompilationUnit() {
        return this._compileUnit;
    }

    public final void runTransformations() {
        this.runTransformations(null);
    }

    public final void runTransformations(Predicate<IAstTransform> transformAbortCondition) {
        TransformationPipeline.runTransformationsUntil(this._compileUnit, transformAbortCondition, this._context);
        this._compileUnit.acceptVisitor(new InsertParenthesesVisitor(), null);
        this._haveTransformationsRun = true;
    }

    public final void addType(TypeDefinition type) {
        TypeDeclaration astType = this.createType(type);
        String packageName = type.getPackageName();
        if (this._compileUnit.getPackage().isNull() && !StringUtilities.isNullOrWhitespace(packageName)) {
            this._compileUnit.insertChildBefore(this._packagePlaceholder, new PackageDeclaration(packageName), Roles.PACKAGE);
            this._packagePlaceholder.remove();
        }
        this._compileUnit.addChild(astType, CompilationUnit.TYPE_ROLE);
    }

    public final TypeDeclaration createType(TypeDefinition type) {
        TypeDeclaration d;
        VerifyArgument.notNull(type, "type");
        Reference<TypeDeclaration> existingDeclaration = this._typeDeclarations.get(type.getInternalName());
        if (existingDeclaration != null && (d = existingDeclaration.get()) != null) {
            return d;
        }
        return this.createTypeNoCache(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TypeDeclaration createTypeNoCache(TypeDefinition type) {
        VerifyArgument.notNull(type, "type");
        TypeDefinition oldCurrentType = this._context.getCurrentType();
        this._context.setCurrentType(type);
        try {
            TypeDeclaration typeDeclaration = this.createTypeCore(type);
            return typeDeclaration;
        }
        finally {
            this._context.setCurrentType(oldCurrentType);
        }
    }

    public AstType convertType(TypeReference type) {
        return this.convertType(type, new ConvertTypeOptions());
    }

    public AstType convertType(TypeReference type, ConvertTypeOptions options) {
        return this.convertType(type, new MutableInteger(0), options);
    }

    public final List<ParameterDeclaration> createParameters(Iterable<ParameterDefinition> parameters) {
        ArrayList<ParameterDeclaration> declarations = new ArrayList<ParameterDeclaration>();
        for (ParameterDefinition p : parameters) {
            TypeReference type = p.getParameterType();
            AstType astType = this.convertType(type);
            ParameterDeclaration d = new ParameterDeclaration(p.getName(), astType);
            d.putUserData(Keys.PARAMETER_DEFINITION, p);
            for (CustomAnnotation annotation : p.getAnnotations()) {
                d.getAnnotations().add(this.createAnnotation(annotation));
            }
            declarations.add(d);
            if (!p.isFinal()) continue;
            EntityDeclaration.addModifier(d, Modifier.FINAL);
        }
        return Collections.unmodifiableList(declarations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AstType convertType(TypeReference type, MutableInteger typeIndex, ConvertTypeOptions options) {
        TypeReference nameSource;
        boolean allowWildcards;
        if (type == null) {
            return AstType.NULL;
        }
        if (type.isArray()) {
            return this.convertType(type.getElementType(), typeIndex.increment(), options).makeArrayType();
        }
        if (type.isGenericParameter()) {
            SimpleType simpleType = new SimpleType(type.getSimpleName());
            simpleType.putUserData(Keys.TYPE_REFERENCE, type);
            return simpleType;
        }
        if (type.isPrimitive()) {
            SimpleType simpleType = new SimpleType(type.getSimpleName());
            simpleType.putUserData(Keys.TYPE_REFERENCE, type.resolve());
            return simpleType;
        }
        if (type.isWildcardType()) {
            if (!options.getAllowWildcards()) {
                if (type.hasExtendsBound()) {
                    return this.convertType(type.getExtendsBound(), options);
                }
                return this.convertType(BuiltinTypes.Object, options);
            }
            WildcardType wildcardType = new WildcardType();
            if (type.hasExtendsBound()) {
                wildcardType.addChild(this.convertType(type.getExtendsBound()), Roles.EXTENDS_BOUND);
            } else if (type.hasSuperBound()) {
                wildcardType.addChild(this.convertType(type.getSuperBound()), Roles.SUPER_BOUND);
            }
            wildcardType.putUserData(Keys.TYPE_REFERENCE, type);
            return wildcardType;
        }
        boolean includeTypeArguments = options == null || options.getIncludeTypeArguments();
        boolean includeTypeParameterDefinitions = options == null || options.getIncludeTypeParameterDefinitions();
        boolean bl = allowWildcards = options == null || options.getAllowWildcards();
        if (type instanceof IGenericInstance && includeTypeArguments) {
            AstType baseType;
            IGenericInstance genericInstance = (IGenericInstance)((Object)type);
            if (options != null) {
                options.setIncludeTypeParameterDefinitions(false);
            }
            try {
                baseType = this.convertType((TypeReference)genericInstance.getGenericDefinition(), typeIndex.increment(), options);
            }
            finally {
                if (options != null) {
                    options.setIncludeTypeParameterDefinitions(includeTypeParameterDefinitions);
                }
            }
            if (options != null) {
                options.setAllowWildcards(true);
            }
            ArrayList<AstType> typeArguments = new ArrayList<AstType>();
            try {
                for (TypeReference typeArgument : genericInstance.getTypeArguments()) {
                    typeArguments.add(this.convertType(typeArgument, typeIndex.increment(), options));
                }
            }
            finally {
                if (options != null) {
                    options.setAllowWildcards(allowWildcards);
                }
            }
            AstBuilder.applyTypeArguments(baseType, typeArguments);
            baseType.putUserData(Keys.TYPE_REFERENCE, type);
            return baseType;
        }
        String name = null;
        PackageDeclaration packageDeclaration = this._compileUnit.getPackage();
        TypeDefinition resolvedType = type.resolve();
        TypeReference typeReference = nameSource = resolvedType != null ? resolvedType : type;
        if (options == null || options.getIncludePackage()) {
            String packageName = nameSource.getPackageName();
            name = StringUtilities.isNullOrEmpty(packageName) ? nameSource.getSimpleName() : packageName + "." + nameSource.getSimpleName();
        } else {
            TypeReference typeToImport;
            String unqualifiedName;
            if (packageDeclaration != null && StringUtilities.equals(packageDeclaration.getName(), nameSource.getPackageName())) {
                name = unqualifiedName = nameSource.getSimpleName();
            }
            if (nameSource.isNested()) {
                unqualifiedName = nameSource.getSimpleName();
                TypeReference current = nameSource;
                while (current.isNested() && !this.isContextWithinType(current = current.getDeclaringType())) {
                    unqualifiedName = current.getSimpleName() + "." + unqualifiedName;
                }
                name = unqualifiedName;
                typeToImport = current;
            } else {
                typeToImport = nameSource;
                unqualifiedName = nameSource.getSimpleName();
            }
            if (options.getAddImports() && !this.areImportsSuppressed() && !this._typeDeclarations.containsKey(typeToImport.getInternalName())) {
                String importedName = this._unqualifiedTypeNames.get(typeToImport.getSimpleName());
                if (importedName == null) {
                    SimpleType importedType = new SimpleType(typeToImport.getFullName());
                    importedType.putUserData(Keys.TYPE_REFERENCE, typeToImport);
                    if (packageDeclaration != null) {
                        this._compileUnit.insertChildAfter(packageDeclaration, new ImportDeclaration(importedType), CompilationUnit.IMPORT_ROLE);
                    } else {
                        this._compileUnit.getImports().add(new ImportDeclaration(importedType));
                    }
                    this._unqualifiedTypeNames.put(typeToImport.getSimpleName(), typeToImport.getFullName());
                    importedName = typeToImport.getFullName();
                }
                if (name == null) {
                    String packageName;
                    name = importedName.equals(typeToImport.getFullName()) ? unqualifiedName : (StringUtilities.isNullOrEmpty(packageName = nameSource.getPackageName()) ? nameSource.getSimpleName() : packageName + "." + nameSource.getSimpleName());
                }
            } else if (name != null) {
                name = nameSource.getSimpleName();
            }
        }
        SimpleType astType = new SimpleType(name);
        astType.putUserData(Keys.TYPE_REFERENCE, type);
        return astType;
    }

    private boolean isContextWithinType(TypeReference type) {
        TypeDefinition scope;
        for (TypeReference current = scope = this._context.getCurrentType(); current != null; current = current.getDeclaringType()) {
            if (MetadataResolver.areEquivalent(current, type)) {
                return true;
            }
            TypeDefinition resolved = ((TypeReference)current).resolve();
            if (resolved == null) continue;
            TypeReference baseType = resolved.getBaseType();
            while (baseType != null) {
                if (MetadataResolver.areEquivalent(baseType, type)) {
                    return true;
                }
                TypeDefinition resolvedBaseType = baseType.resolve();
                baseType = resolvedBaseType != null ? resolvedBaseType.getBaseType() : null;
            }
            for (TypeReference ifType : MetadataHelper.getInterfaces(current)) {
                if (!MetadataResolver.areEquivalent(ifType, type)) continue;
                return true;
            }
        }
        return false;
    }

    private TypeDeclaration createTypeCore(TypeDefinition type) {
        TypeReference baseType;
        TypeDeclaration astType = new TypeDeclaration();
        String packageName = type.getPackageName();
        if (this._compileUnit.getPackage().isNull() && !StringUtilities.isNullOrWhitespace(packageName)) {
            PackageDeclaration packageDeclaration = new PackageDeclaration(packageName);
            packageDeclaration.putUserData(Keys.PACKAGE_REFERENCE, PackageReference.parse(packageName));
            this._compileUnit.insertChildBefore(this._packagePlaceholder, packageDeclaration, Roles.PACKAGE);
            this._packagePlaceholder.remove();
        }
        this._typeDeclarations.put(type.getInternalName(), new SoftReference<TypeDeclaration>(astType));
        long flags = type.getFlags();
        flags = type.isInterface() || type.isEnum() ? (flags &= 7L) : (flags &= 0x7E1FL);
        EntityDeclaration.setModifiers(astType, Flags.asModifierSet(this.scrubAccessModifiers(flags)));
        astType.setName(type.getSimpleName());
        astType.putUserData(Keys.TYPE_DEFINITION, type);
        astType.putUserData(Keys.TYPE_REFERENCE, type);
        if (type.isEnum()) {
            astType.setClassType(ClassType.ENUM);
        } else if (type.isAnnotation()) {
            astType.setClassType(ClassType.ANNOTATION);
        } else if (type.isInterface()) {
            astType.setClassType(ClassType.INTERFACE);
        } else {
            astType.setClassType(ClassType.CLASS);
        }
        List<TypeParameterDeclaration> typeParameters = this.createTypeParameters(type.getGenericParameters());
        if (!typeParameters.isEmpty()) {
            astType.getTypeParameters().addAll(typeParameters);
        }
        if ((baseType = type.getBaseType()) != null && !type.isEnum() && !BuiltinTypes.Object.equals(baseType)) {
            astType.addChild(this.convertType(baseType), Roles.BASE_TYPE);
        }
        for (TypeReference interfaceType : type.getExplicitInterfaces()) {
            if (type.isAnnotation() && "java/lang/annotations/Annotation".equals(interfaceType.getInternalName())) continue;
            astType.addChild(this.convertType(interfaceType), Roles.IMPLEMENTED_INTERFACE);
        }
        for (CustomAnnotation annotation : type.getAnnotations()) {
            astType.getAnnotations().add(this.createAnnotation(annotation));
        }
        this.addTypeMembers(astType, type);
        return astType;
    }

    private long scrubAccessModifiers(long flags) {
        long result = flags & 0xFFFFFFFFFFFFFFF8L;
        if ((flags & 2L) != 0L) {
            return result | 2L;
        }
        if ((flags & 4L) != 0L) {
            return result | 4L;
        }
        if ((flags & 1L) != 0L) {
            return result | 1L;
        }
        return result;
    }

    private void addTypeMembers(TypeDeclaration astType, TypeDefinition type) {
        for (FieldDefinition field : type.getDeclaredFields()) {
            astType.addChild(this.createField(field), Roles.TYPE_MEMBER);
        }
        for (MethodDefinition method : type.getDeclaredMethods()) {
            if (method.isConstructor()) {
                astType.addChild(this.createConstructor(method), Roles.TYPE_MEMBER);
                continue;
            }
            astType.addChild(this.createMethod(method), Roles.TYPE_MEMBER);
        }
        ArrayList<TypeDefinition> nestedTypes = new ArrayList<TypeDefinition>();
        for (TypeDefinition nestedType : type.getDeclaredTypes()) {
            TypeReference declaringType = nestedType.getDeclaringType();
            if (nestedType.isLocalClass() || !type.isEquivalentTo(declaringType)) continue;
            if (nestedType.isAnonymous()) {
                this._typeDeclarations.put(type.getInternalName(), new SoftReference<TypeDeclaration>(astType));
                continue;
            }
            nestedTypes.add(nestedType);
        }
        AstBuilder.sortNestedTypes(nestedTypes);
        for (TypeDefinition nestedType : nestedTypes) {
            astType.addChild(this.createTypeNoCache(nestedType), Roles.TYPE_MEMBER);
        }
    }

    private static void sortNestedTypes(List<TypeDefinition> types) {
        final IdentityHashMap<TypeDefinition, Integer> minOffsets = new IdentityHashMap<TypeDefinition, Integer>();
        for (TypeDefinition type : types) {
            minOffsets.put(type, AstBuilder.findFirstLineNumber(type));
        }
        Collections.sort(types, new Comparator<TypeDefinition>(){

            @Override
            public int compare(TypeDefinition o1, TypeDefinition o2) {
                return Integer.compare((Integer)minOffsets.get(o1), (Integer)minOffsets.get(o2));
            }
        });
    }

    private static Integer findFirstLineNumber(TypeDefinition type) {
        int minLineNumber = Integer.MAX_VALUE;
        for (MethodDefinition method : type.getDeclaredMethods()) {
            int firstLineNumber;
            LineNumberTableAttribute attribute = (LineNumberTableAttribute)SourceAttribute.find("LineNumberTable", method.getSourceAttributes());
            if (attribute == null || attribute.getEntries().isEmpty() || (firstLineNumber = attribute.getEntries().get(0).getLineNumber()) >= minLineNumber) continue;
            minLineNumber = firstLineNumber;
        }
        return minLineNumber;
    }

    private FieldDeclaration createField(FieldDefinition field) {
        FieldDeclaration astField = new FieldDeclaration();
        VariableInitializer initializer = new VariableInitializer(field.getName());
        astField.setName(field.getName());
        astField.addChild(initializer, Roles.VARIABLE);
        astField.setReturnType(this.convertType(field.getFieldType()));
        astField.putUserData(Keys.FIELD_DEFINITION, field);
        astField.putUserData(Keys.MEMBER_REFERENCE, field);
        EntityDeclaration.setModifiers(astField, Flags.asModifierSet(this.scrubAccessModifiers(field.getFlags() & 0x40DFL)));
        if (field.hasConstantValue()) {
            initializer.setInitializer(new PrimitiveExpression(-34, field.getConstantValue()));
            initializer.putUserData(Keys.FIELD_DEFINITION, field);
            initializer.putUserData(Keys.MEMBER_REFERENCE, field);
        }
        for (CustomAnnotation annotation : field.getAnnotations()) {
            astField.getAnnotations().add(this.createAnnotation(annotation));
        }
        return astField;
    }

    private MethodDeclaration createMethod(MethodDefinition method) {
        Expression defaultValue;
        MethodDeclaration astMethod = new MethodDeclaration();
        Set<Object> modifiers = method.isTypeInitializer() ? Collections.singleton(Modifier.STATIC) : (method.getDeclaringType().isInterface() ? Collections.emptySet() : Flags.asModifierSet(this.scrubAccessModifiers(method.getFlags() & 0xD3FL)));
        EntityDeclaration.setModifiers(astMethod, modifiers);
        astMethod.setName(method.getName());
        astMethod.getParameters().addAll(this.createParameters(method.getParameters()));
        astMethod.getTypeParameters().addAll(this.createTypeParameters(method.getGenericParameters()));
        astMethod.setReturnType(this.convertType(method.getReturnType()));
        astMethod.putUserData(Keys.METHOD_DEFINITION, method);
        astMethod.putUserData(Keys.MEMBER_REFERENCE, method);
        for (TypeDefinition declaredType : method.getDeclaredTypes()) {
            if (declaredType.isAnonymous()) continue;
            astMethod.getDeclaredTypes().add(this.createType(declaredType));
        }
        if (!method.getDeclaringType().isInterface() || method.isTypeInitializer() || method.isDefault()) {
            astMethod.setBody(this.createMethodBody(method, astMethod.getParameters()));
        }
        for (TypeReference thrownType : method.getThrownTypes()) {
            astMethod.addChild(this.convertType(thrownType), Roles.THROWN_TYPE);
        }
        for (CustomAnnotation annotation : method.getAnnotations()) {
            astMethod.getAnnotations().add(this.createAnnotation(annotation));
        }
        AnnotationDefaultAttribute defaultAttribute = (AnnotationDefaultAttribute)SourceAttribute.find("AnnotationDefault", method.getSourceAttributes());
        if (defaultAttribute != null && (defaultValue = this.createAnnotationElement(defaultAttribute.getDefaultValue())) != null && !defaultValue.isNull()) {
            astMethod.setDefaultValue(defaultValue);
        }
        return astMethod;
    }

    private ConstructorDeclaration createConstructor(MethodDefinition method) {
        ConstructorDeclaration astMethod = new ConstructorDeclaration();
        EntityDeclaration.setModifiers(astMethod, Flags.asModifierSet(this.scrubAccessModifiers(method.getFlags() & 7L)));
        astMethod.setName(method.getDeclaringType().getName());
        astMethod.getParameters().addAll(this.createParameters(method.getParameters()));
        astMethod.getTypeParameters().addAll(this.createTypeParameters(method.getGenericParameters()));
        astMethod.setBody(this.createMethodBody(method, astMethod.getParameters()));
        astMethod.putUserData(Keys.METHOD_DEFINITION, method);
        astMethod.putUserData(Keys.MEMBER_REFERENCE, method);
        for (CustomAnnotation annotation : method.getAnnotations()) {
            astMethod.getAnnotations().add(this.createAnnotation(annotation));
        }
        for (TypeReference thrownType : method.getThrownTypes()) {
            astMethod.addChild(this.convertType(thrownType), Roles.THROWN_TYPE);
        }
        return astMethod;
    }

    final List<TypeParameterDeclaration> createTypeParameters(List<GenericParameter> genericParameters) {
        if (genericParameters.isEmpty()) {
            return Collections.emptyList();
        }
        int count = genericParameters.size();
        TypeParameterDeclaration[] typeParameters = new TypeParameterDeclaration[genericParameters.size()];
        for (int i = 0; i < count; ++i) {
            GenericParameter genericParameter = genericParameters.get(i);
            TypeParameterDeclaration typeParameter = new TypeParameterDeclaration(genericParameter.getName());
            if (genericParameter.hasExtendsBound()) {
                typeParameter.setExtendsBound(this.convertType(genericParameter.getExtendsBound()));
            }
            typeParameter.putUserData(Keys.TYPE_REFERENCE, genericParameter);
            typeParameter.putUserData(Keys.TYPE_DEFINITION, genericParameter);
            typeParameters[i] = typeParameter;
        }
        return ArrayUtilities.asUnmodifiableList(typeParameters);
    }

    static void addTypeArguments(TypeReference type, AstType astType) {
        if (type.hasGenericParameters()) {
            List<GenericParameter> genericParameters = type.getGenericParameters();
            int count = genericParameters.size();
            AstType[] typeArguments = new AstType[count];
            for (int i = 0; i < count; ++i) {
                GenericParameter genericParameter = genericParameters.get(i);
                SimpleType typeParameter = new SimpleType(genericParameter.getName());
                typeParameter.putUserData(Keys.TYPE_REFERENCE, genericParameter);
                typeArguments[i] = typeParameter;
            }
            AstBuilder.applyTypeArguments(astType, ArrayUtilities.asUnmodifiableList(typeArguments));
        }
    }

    static void applyTypeArguments(AstType baseType, List<AstType> typeArguments) {
        if (baseType instanceof SimpleType) {
            SimpleType st = (SimpleType)baseType;
            st.getTypeArguments().addAll(typeArguments);
        }
    }

    private BlockStatement createMethodBody(MethodDefinition method, Iterable<ParameterDeclaration> parameters) {
        if (this._decompileMethodBodies) {
            return AstMethodBodyBuilder.createMethodBody(this, method, this._context, parameters);
        }
        return null;
    }

    public static Expression makePrimitive(long val, TypeReference type) {
        if (TypeAnalysis.isBoolean(type)) {
            if (val == 0L) {
                return new PrimitiveExpression(-34, Boolean.FALSE);
            }
            return new PrimitiveExpression(-34, Boolean.TRUE);
        }
        if (type != null) {
            return new PrimitiveExpression(-34, JavaPrimitiveCast.cast(type.getSimpleType(), val));
        }
        return new PrimitiveExpression(-34, JavaPrimitiveCast.cast(JvmType.Integer, val));
    }

    public static Expression makeDefaultValue(TypeReference type) {
        if (type == null) {
            return new NullReferenceExpression(-34);
        }
        switch (type.getSimpleType()) {
            case Boolean: {
                return new PrimitiveExpression(-34, Boolean.FALSE);
            }
            case Byte: {
                return new PrimitiveExpression(-34, (byte)0);
            }
            case Character: {
                return new PrimitiveExpression(-34, Character.valueOf('\u0000'));
            }
            case Short: {
                return new PrimitiveExpression(-34, (short)0);
            }
            case Integer: {
                return new PrimitiveExpression(-34, 0);
            }
            case Long: {
                return new PrimitiveExpression(-34, 0L);
            }
            case Float: {
                return new PrimitiveExpression(-34, Float.valueOf(0.0f));
            }
            case Double: {
                return new PrimitiveExpression(-34, 0.0);
            }
        }
        return new NullReferenceExpression(-34);
    }

    public List<LineNumberPosition> generateCode(ITextOutput output) {
        if (!this._haveTransformationsRun) {
            this.runTransformations();
        }
        JavaOutputVisitor visitor = new JavaOutputVisitor(output, this._context.getSettings());
        this._compileUnit.acceptVisitor(visitor, null);
        return visitor.getLineNumberPositions();
    }

    public static boolean isMemberHidden(IMemberDefinition member, DecompilerContext context) {
        DecompilerSettings settings = context.getSettings();
        if (member.isSynthetic() && !settings.getShowSyntheticMembers()) {
            return !context.getForcedVisibleMembers().contains(member);
        }
        if (member instanceof TypeReference && ((TypeReference)((Object)member)).isNested() && settings.getExcludeNestedTypes()) {
            TypeDefinition resolvedType = ((TypeReference)((Object)member)).resolve();
            return resolvedType == null || !resolvedType.isAnonymous() && AstBuilder.findLocalType(resolvedType) == null;
        }
        return false;
    }

    private static TypeReference findLocalType(TypeReference type) {
        if (type != null) {
            TypeDefinition resolvedType = type.resolve();
            if (resolvedType != null && resolvedType.isLocalClass()) {
                return resolvedType;
            }
            TypeReference declaringType = type.getDeclaringType();
            if (declaringType != null) {
                return AstBuilder.findLocalType(declaringType);
            }
        }
        return null;
    }

    public Annotation createAnnotation(CustomAnnotation annotation) {
        Annotation a = new Annotation();
        AstNodeCollection<Expression> arguments = a.getArguments();
        a.setType(this.convertType(annotation.getAnnotationType()));
        List<AnnotationParameter> parameters = annotation.getParameters();
        for (AnnotationParameter p : parameters) {
            String member = p.getMember();
            Expression value = this.createAnnotationElement(p.getValue());
            if (StringUtilities.isNullOrEmpty(member) || parameters.size() == 1 && "value".equals(member)) {
                arguments.add(value);
                continue;
            }
            arguments.add(new AssignmentExpression(new IdentifierExpression(value.getOffset(), member), value));
        }
        return a;
    }

    public Expression createAnnotationElement(AnnotationElement element) {
        switch (element.getElementType()) {
            case Constant: {
                ConstantAnnotationElement constant = (ConstantAnnotationElement)element;
                return new PrimitiveExpression(-34, constant.getConstantValue());
            }
            case Enum: {
                EnumAnnotationElement enumElement = (EnumAnnotationElement)element;
                return new TypeReferenceExpression(-34, this.convertType(enumElement.getEnumType())).member(enumElement.getEnumConstantName());
            }
            case Array: {
                ArrayAnnotationElement arrayElement = (ArrayAnnotationElement)element;
                ArrayInitializerExpression initializer = new ArrayInitializerExpression();
                AstNodeCollection<Expression> elements = initializer.getElements();
                for (AnnotationElement e : arrayElement.getElements()) {
                    elements.add(this.createAnnotationElement(e));
                }
                return initializer;
            }
            case Class: {
                return new ClassOfExpression(-34, this.convertType(((ClassAnnotationElement)element).getClassType()));
            }
            case Annotation: {
                return this.createAnnotation(((AnnotationAnnotationElement)element).getAnnotation());
            }
        }
        throw ContractUtils.unreachable();
    }
}

