/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentAnalysis;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LocalTypeDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DeclareLocalClassesTransform
implements IAstTransform {
    protected final DecompilerContext context;
    protected final AstBuilder astBuilder;

    public DeclareLocalClassesTransform(DecompilerContext context) {
        this.context = VerifyArgument.notNull(context, "context");
        this.astBuilder = context.getUserData(Keys.AST_BUILDER);
    }

    @Override
    public void run(AstNode node) {
        if (this.astBuilder == null) {
            return;
        }
        this.run(node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(AstNode node, DefiniteAssignmentAnalysis daa) {
        DefiniteAssignmentAnalysis analysis = daa;
        if (node instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)node;
            ArrayList<TypeDeclaration> localTypes = new ArrayList<TypeDeclaration>();
            for (TypeDeclaration localType : method.getDeclaredTypes()) {
                localTypes.add(localType);
            }
            if (!localTypes.isEmpty()) {
                boolean madeProgress;
                for (TypeDeclaration localType : localTypes) {
                    localType.remove();
                }
                if (analysis == null) {
                    analysis = new DefiniteAssignmentAnalysis(method.getBody(), new JavaResolver(this.context));
                }
                LinkedHashSet<TypeToDeclare> typesToDeclare = new LinkedHashSet<TypeToDeclare>();
                do {
                    madeProgress = false;
                    Iterator iterator = localTypes.iterator();
                    while (iterator.hasNext()) {
                        TypeDeclaration localType = (TypeDeclaration)iterator.next();
                        if (!this.declareTypeInBlock(method.getBody(), localType, true, typesToDeclare)) continue;
                        madeProgress = true;
                        iterator.remove();
                    }
                    if (!madeProgress && !localTypes.isEmpty()) {
                        TypeDeclaration firstUndeclared = (TypeDeclaration)CollectionUtilities.first(localTypes);
                        method.getBody().insertChildBefore(method.getBody().getFirstChild(), new LocalTypeDeclarationStatement(-34, firstUndeclared), BlockStatement.STATEMENT_ROLE);
                        madeProgress = true;
                        localTypes.remove(0);
                    }
                    for (TypeToDeclare v : typesToDeclare) {
                        BlockStatement block = (BlockStatement)v.getInsertionPoint().getParent();
                        if (block == null) continue;
                        Statement insertionPoint = v.getInsertionPoint();
                        while (insertionPoint.getPreviousSibling() instanceof LabelStatement) {
                            insertionPoint = (Statement)insertionPoint.getPreviousSibling();
                        }
                        block.insertChildBefore(insertionPoint, new LocalTypeDeclarationStatement(-34, v.getDeclaration()), BlockStatement.STATEMENT_ROLE);
                    }
                    typesToDeclare.clear();
                } while (madeProgress && !localTypes.isEmpty());
            }
        }
        for (AstNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof TypeDeclaration) {
                TypeDefinition currentType = this.context.getCurrentType();
                MethodDefinition currentMethod = this.context.getCurrentMethod();
                this.context.setCurrentType(null);
                this.context.setCurrentMethod(null);
                try {
                    TypeDefinition type = child.getUserData(Keys.TYPE_DEFINITION);
                    if (type != null && type.isInterface()) continue;
                    new DeclareLocalClassesTransform(this.context).run(child);
                    continue;
                }
                finally {
                    this.context.setCurrentType(currentType);
                    this.context.setCurrentMethod(currentMethod);
                }
            }
            this.run(child, analysis);
        }
    }

    private boolean declareTypeInBlock(BlockStatement block, TypeDeclaration type, boolean allowPassIntoLoops, Set<TypeToDeclare> typesToDeclare) {
        StrongBox<Statement> declarationPoint = new StrongBox<Statement>();
        TypeDefinition typeDefinition = type.getUserData(Keys.TYPE_DEFINITION);
        boolean canMoveVariableIntoSubBlocks = DeclareLocalClassesTransform.findDeclarationPoint(typeDefinition, allowPassIntoLoops, block, declarationPoint, null);
        if (declarationPoint.get() == null) {
            return false;
        }
        if (canMoveVariableIntoSubBlocks) {
            for (Statement statement : block.getStatements()) {
                if (!DeclareLocalClassesTransform.referencesType(statement, (TypeReference)typeDefinition)) continue;
                for (AstNode child : statement.getChildren()) {
                    if (child instanceof BlockStatement) {
                        if (!this.declareTypeInBlock((BlockStatement)child, type, allowPassIntoLoops, typesToDeclare)) continue;
                        return true;
                    }
                    if (!DeclareLocalClassesTransform.hasNestedBlocks(child)) continue;
                    for (AstNode nestedChild : child.getChildren()) {
                        if (!(nestedChild instanceof BlockStatement) || !this.declareTypeInBlock((BlockStatement)nestedChild, type, allowPassIntoLoops, typesToDeclare)) continue;
                        return true;
                    }
                }
                boolean canStillMoveIntoSubBlocks = DeclareLocalClassesTransform.findDeclarationPoint(typeDefinition, allowPassIntoLoops, block, declarationPoint, statement);
                if (canStillMoveIntoSubBlocks || declarationPoint.get() == null) continue;
                TypeToDeclare vtd = new TypeToDeclare(type, typeDefinition, declarationPoint.get(), block);
                typesToDeclare.add(vtd);
                return true;
            }
            return false;
        }
        TypeToDeclare vtd = new TypeToDeclare(type, typeDefinition, declarationPoint.get(), block);
        typesToDeclare.add(vtd);
        return true;
    }

    public static boolean findDeclarationPoint(TypeDeclaration declaration, BlockStatement block, StrongBox<Statement> declarationPoint, Statement skipUpThrough) {
        return DeclareLocalClassesTransform.findDeclarationPoint(declaration.getUserData(Keys.TYPE_DEFINITION), true, block, declarationPoint, skipUpThrough);
    }

    static boolean findDeclarationPoint(TypeReference localType, boolean allowPassIntoLoops, BlockStatement block, StrongBox<Statement> declarationPoint, Statement skipUpThrough) {
        declarationPoint.set(null);
        Statement waitFor = skipUpThrough;
        for (Statement statement : block.getStatements()) {
            if (waitFor != null) {
                if (statement != waitFor) continue;
                waitFor = null;
                continue;
            }
            if (!DeclareLocalClassesTransform.referencesType(statement, localType)) continue;
            if (declarationPoint.get() != null) {
                return false;
            }
            declarationPoint.set(statement);
            if (!DeclareLocalClassesTransform.canMoveLocalTypeIntoSubBlock(statement, localType, allowPassIntoLoops)) {
                return false;
            }
            for (AstNode nextNode = statement.getNextSibling(); nextNode != null; nextNode = nextNode.getNextSibling()) {
                if (!DeclareLocalClassesTransform.referencesType(nextNode, localType)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canMoveLocalTypeIntoSubBlock(Statement statement, TypeReference localType, boolean allowPassIntoLoops) {
        if (!allowPassIntoLoops && AstNode.isLoop(statement)) {
            return false;
        }
        for (AstNode child = statement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof BlockStatement || !DeclareLocalClassesTransform.referencesType(child, localType)) continue;
            if (DeclareLocalClassesTransform.hasNestedBlocks(child)) {
                for (AstNode grandChild = child.getFirstChild(); grandChild != null; grandChild = grandChild.getNextSibling()) {
                    if (grandChild instanceof BlockStatement || !DeclareLocalClassesTransform.referencesType(grandChild, localType)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean referencesType(AstType reference, TypeReference localType) {
        return reference != null && DeclareLocalClassesTransform.referencesType(reference.getUserData(Keys.TYPE_REFERENCE), localType);
    }

    private static boolean referencesType(TypeReference reference, TypeReference localType) {
        block10: {
            TypeReference bound;
            if (reference == null || localType == null) {
                return false;
            }
            TypeReference type = reference;
            while (type.isArray()) {
                type = type.getElementType();
            }
            TypeReference target = localType;
            while (target.isArray()) {
                target = target.getElementType();
            }
            if (StringUtilities.equals(type.getInternalName(), target.getInternalName())) {
                return true;
            }
            if (type.hasExtendsBound() && !(bound = type.getExtendsBound()).isGenericParameter() && !MetadataHelper.isSameType(bound, type) && DeclareLocalClassesTransform.referencesType(bound, localType)) {
                return true;
            }
            if (type.hasSuperBound() && !(bound = type.getSuperBound()).isGenericParameter() && !MetadataHelper.isSameType(bound, type) && DeclareLocalClassesTransform.referencesType(bound, localType)) {
                return true;
            }
            if (!type.isGenericType()) break block10;
            if (type instanceof IGenericInstance) {
                List<TypeReference> typeArguments = ((IGenericInstance)((Object)type)).getTypeArguments();
                for (TypeReference typeArgument : typeArguments) {
                    if (MetadataHelper.isSameType(typeArgument, type) || !DeclareLocalClassesTransform.referencesType(typeArgument, localType)) continue;
                    return true;
                }
            } else {
                for (TypeReference typeReference : type.getGenericParameters()) {
                    if (MetadataHelper.isSameType(typeReference, type) || !DeclareLocalClassesTransform.referencesType(typeReference, localType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean referencesType(AstNode node, TypeReference localType) {
        ForEachStatement forEach;
        if (node instanceof AnonymousObjectCreationExpression) {
            for (Expression argument : ((AnonymousObjectCreationExpression)node).getArguments()) {
                if (!DeclareLocalClassesTransform.referencesType(argument, localType)) continue;
                return true;
            }
            return false;
        }
        if (node instanceof LocalTypeDeclarationStatement) {
            return DeclareLocalClassesTransform.referencesType(((LocalTypeDeclarationStatement)node).getTypeDeclaration(), localType);
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)node;
            AstType baseType = type.getBaseType();
            if (baseType != null && !baseType.isNull() && DeclareLocalClassesTransform.referencesType(baseType, localType)) {
                return true;
            }
            for (AstType ifType : type.getInterfaces()) {
                if (!DeclareLocalClassesTransform.referencesType(ifType, localType)) continue;
                return true;
            }
            for (FieldDeclaration field : CollectionUtilities.ofType(type.getMembers(), FieldDeclaration.class)) {
                FieldDefinition fieldDefinition = field.getUserData(Keys.FIELD_DEFINITION);
                if (fieldDefinition != null && StringUtilities.equals(fieldDefinition.getFieldType().getInternalName(), localType.getInternalName())) {
                    return true;
                }
                if (field.getVariables().isEmpty() || !DeclareLocalClassesTransform.referencesType(CollectionUtilities.first(field.getVariables()), localType)) continue;
                return true;
            }
            for (MethodDeclaration method : CollectionUtilities.ofType(type.getMembers(), MethodDeclaration.class)) {
                MethodDefinition methodDefinition = method.getUserData(Keys.METHOD_DEFINITION);
                if (methodDefinition != null) {
                    if (StringUtilities.equals(methodDefinition.getReturnType().getInternalName(), localType.getInternalName())) {
                        return true;
                    }
                    for (ParameterDefinition parameter : methodDefinition.getParameters()) {
                        if (!StringUtilities.equals(parameter.getParameterType().getInternalName(), localType.getInternalName())) continue;
                        return true;
                    }
                }
                if (!DeclareLocalClassesTransform.referencesType(method.getBody(), localType)) continue;
                return true;
            }
            return false;
        }
        if (node instanceof AstType) {
            return DeclareLocalClassesTransform.referencesType((AstType)node, localType);
        }
        if (node instanceof ForStatement) {
            ForStatement forLoop = (ForStatement)node;
            for (Statement statement : forLoop.getInitializers()) {
                AstType type;
                if (!(statement instanceof VariableDeclarationStatement) || !DeclareLocalClassesTransform.referencesType(type = ((VariableDeclarationStatement)statement).getType(), localType)) continue;
                return true;
            }
        }
        if (node instanceof ForEachStatement && DeclareLocalClassesTransform.referencesType((forEach = (ForEachStatement)node).getVariableType(), localType)) {
            return true;
        }
        if (node instanceof TryCatchStatement) {
            TryCatchStatement tryCatch = (TryCatchStatement)node;
            for (VariableDeclarationStatement resource : tryCatch.getResources()) {
                if (!DeclareLocalClassesTransform.referencesType(resource.getType(), localType)) continue;
                return true;
            }
        }
        if (node instanceof CatchClause) {
            for (AstType type : ((CatchClause)node).getExceptionTypes()) {
                if (!DeclareLocalClassesTransform.referencesType(type, localType)) continue;
                return true;
            }
        }
        for (AstNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!DeclareLocalClassesTransform.referencesType(child, localType)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNestedBlocks(AstNode node) {
        return node.getChildByRole(Roles.EMBEDDED_STATEMENT) instanceof BlockStatement || node instanceof TryCatchStatement || node instanceof CatchClause || node instanceof SwitchSection;
    }

    protected static final class TypeToDeclare {
        private final TypeDeclaration _declaration;
        private final TypeDefinition _typeDefinition;
        private final Statement _insertionPoint;
        private final BlockStatement _block;

        public TypeToDeclare(TypeDeclaration declaration, TypeDefinition definition, Statement insertionPoint, BlockStatement block) {
            this._declaration = declaration;
            this._typeDefinition = definition;
            this._insertionPoint = insertionPoint;
            this._block = block;
        }

        public BlockStatement getBlock() {
            return this._block;
        }

        public TypeDeclaration getDeclaration() {
            return this._declaration;
        }

        public TypeDefinition getTypeDefinition() {
            return this._typeDefinition;
        }

        public Statement getInsertionPoint() {
            return this._insertionPoint;
        }

        public String toString() {
            return "TypeToDeclare{Type=" + this._typeDefinition.getSignature() + ", InsertionPoint=" + this._insertionPoint + '}';
        }
    }
}

