/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.java.JavaOutputVisitor;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.InsertParenthesesVisitor;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import cuchaz.enigma.ITranslatingTypeLoader;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.SynchronizedTypeLoader;
import cuchaz.enigma.TranslatingTypeLoader;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.IndexTreeBuilder;
import cuchaz.enigma.analysis.ParsedJar;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.api.EnigmaPlugin;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.MappingsChecker;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.tree.DeltaTrackingTree;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.ReferencedEntryPool;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import oml.ast.transformers.InvalidIdentifierFix;
import oml.ast.transformers.Java8Generics;
import oml.ast.transformers.ObfuscatedEnumSwitchRewriterTransform;
import oml.ast.transformers.RemoveObjectCasts;
import oml.ast.transformers.VarargsFixer;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class Deobfuscator {
    private final ServiceLoader<EnigmaPlugin> plugins = ServiceLoader.load(EnigmaPlugin.class);
    private final ReferencedEntryPool entryPool = new ReferencedEntryPool();
    private final ParsedJar parsedJar;
    private final DecompilerSettings settings;
    private final JarIndex jarIndex;
    private final IndexTreeBuilder indexTreeBuilder;
    private EntryRemapper mapper;

    public Deobfuscator(ParsedJar jar, Consumer<String> listener) {
        this.parsedJar = jar;
        this.jarIndex = JarIndex.empty();
        this.jarIndex.indexJar(this.parsedJar, listener);
        listener.accept("Initializing plugins...");
        for (EnigmaPlugin plugin : this.getPlugins()) {
            plugin.onClassesLoaded(this.parsedJar.getClassDataMap(), this.parsedJar::getClassNode);
        }
        this.indexTreeBuilder = new IndexTreeBuilder(this.jarIndex);
        listener.accept("Preparing...");
        this.settings = DecompilerSettings.javaDefaults();
        this.settings.setMergeVariables(Utils.getSystemPropertyAsBoolean("enigma.mergeVariables", true));
        this.settings.setForceExplicitImports(Utils.getSystemPropertyAsBoolean("enigma.forceExplicitImports", true));
        this.settings.setForceExplicitTypeArguments(Utils.getSystemPropertyAsBoolean("enigma.forceExplicitTypeArguments", true));
        this.settings.setShowDebugLineNumbers(Utils.getSystemPropertyAsBoolean("enigma.showDebugLineNumbers", false));
        this.settings.setShowSyntheticMembers(Utils.getSystemPropertyAsBoolean("enigma.showSyntheticMembers", false));
        this.mapper = new EntryRemapper(this.jarIndex);
    }

    public Deobfuscator(JarFile jar, Consumer<String> listener) throws IOException {
        this(new ParsedJar(jar), listener);
    }

    public Deobfuscator(ParsedJar jar) throws IOException {
        this(jar, (String msg) -> {});
    }

    public Deobfuscator(JarFile jar) throws IOException {
        this(jar, (String msg) -> {});
    }

    public ServiceLoader<EnigmaPlugin> getPlugins() {
        return this.plugins;
    }

    public ParsedJar getJar() {
        return this.parsedJar;
    }

    public JarIndex getJarIndex() {
        return this.jarIndex;
    }

    public IndexTreeBuilder getIndexTreeBuilder() {
        return this.indexTreeBuilder;
    }

    public EntryRemapper getMapper() {
        return this.mapper;
    }

    public void setMappings(EntryTree<EntryMapping> mappings) {
        if (mappings != null) {
            Collection<Entry<?>> dropped = this.dropMappings(mappings);
            this.mapper = new EntryRemapper(this.jarIndex, mappings);
            DeltaTrackingTree<EntryMapping> deobfToObf = this.mapper.getDeobfToObf();
            for (Entry<?> entry : dropped) {
                deobfToObf.trackDeletion(entry);
            }
        } else {
            this.mapper = new EntryRemapper(this.jarIndex);
        }
    }

    private Collection<Entry<?>> dropMappings(EntryTree<EntryMapping> mappings) {
        MappingsChecker checker = new MappingsChecker(this.jarIndex, mappings);
        MappingsChecker.Dropped dropped = checker.dropBrokenMappings();
        Map<Entry<?>, String> droppedMappings = dropped.getDroppedMappings();
        for (Map.Entry<Entry<?>, String> mapping : droppedMappings.entrySet()) {
            System.out.println("WARNING: Couldn't find " + mapping.getKey() + " (" + mapping.getValue() + ") in jar. Mapping was dropped.");
        }
        return droppedMappings.keySet();
    }

    public void getSeparatedClasses(List<ClassEntry> obfClasses, List<ClassEntry> deobfClasses) {
        for (ClassEntry obfClassEntry : this.jarIndex.getEntryIndex().getClasses()) {
            if (obfClassEntry.isInnerClass()) continue;
            ClassEntry deobfClassEntry = this.mapper.deobfuscate(obfClassEntry);
            if (!deobfClassEntry.equals(obfClassEntry)) {
                deobfClasses.add(deobfClassEntry);
                continue;
            }
            if (obfClassEntry.getPackageName() != null) {
                deobfClasses.add(obfClassEntry);
                continue;
            }
            obfClasses.add(obfClassEntry);
        }
    }

    public TranslatingTypeLoader createTypeLoader() {
        return new TranslatingTypeLoader(this.parsedJar, this.jarIndex, this.entryPool, this.mapper.getObfuscator(), this.mapper.getDeobfuscator());
    }

    public CompilationUnit getSourceTree(String className) {
        return this.getSourceTree(className, this.createTypeLoader());
    }

    public CompilationUnit getSourceTree(String className, ITranslatingTypeLoader loader) {
        return this.getSourceTree(className, loader, new NoRetryMetadataSystem(loader));
    }

    public CompilationUnit getSourceTree(String className, ITranslatingTypeLoader loader, MetadataSystem metadataSystem) {
        String deobfClassName = this.mapper.deobfuscate(new ClassEntry(className)).getFullName();
        this.settings.setTypeLoader(loader);
        TypeReference type = metadataSystem.lookupType(deobfClassName);
        if (type == null) {
            throw new Error(String.format("Unable to find desc: %s (deobf: %s)\nTried class names: %s", className, deobfClassName, loader.getClassNamesToTry(deobfClassName)));
        }
        TypeDefinition resolvedType = type.resolve();
        DecompilerContext context = new DecompilerContext();
        context.setCurrentType(resolvedType);
        context.setSettings(this.settings);
        AstBuilder builder = new AstBuilder(context);
        builder.addType(resolvedType);
        builder.runTransformations(null);
        Deobfuscator.runCustomTransforms(builder, context);
        return builder.getCompilationUnit();
    }

    public SourceIndex getSourceIndex(CompilationUnit sourceTree, String source) {
        return this.getSourceIndex(sourceTree, source, true);
    }

    public SourceIndex getSourceIndex(CompilationUnit sourceTree, String source, boolean ignoreBadTokens) {
        SourceIndex index = new SourceIndex(source, ignoreBadTokens);
        sourceTree.acceptVisitor(new SourceIndexVisitor(this.entryPool), index);
        EntryResolver resolver = this.mapper.getDeobfResolver();
        ArrayList<Token> tokens = Lists.newArrayList(index.referenceTokens());
        for (Token token : tokens) {
            EntryReference<Entry<?>, Entry<?>> deobfReference = index.getDeobfReference(token);
            index.replaceDeobfReference(token, resolver.resolveFirstReference(deobfReference, ResolutionStrategy.RESOLVE_CLOSEST));
        }
        return index;
    }

    public String getSource(CompilationUnit sourceTree) {
        StringWriter buf = new StringWriter();
        sourceTree.acceptVisitor(new InsertParenthesesVisitor(), null);
        sourceTree.acceptVisitor(new JavaOutputVisitor(new PlainTextOutput(buf), this.settings), null);
        return buf.toString();
    }

    public void writeSources(File dirOut, ProgressListener progress) {
        Set classEntries = this.jarIndex.getEntryIndex().getClasses().stream().filter(classEntry -> !classEntry.isInnerClass()).collect(Collectors.toSet());
        if (progress != null) {
            progress.init(classEntries.size(), "Decompiling classes...");
        }
        SynchronizedTypeLoader typeLoader = new SynchronizedTypeLoader(this.createTypeLoader());
        NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem(typeLoader);
        metadataSystem.setEagerMethodLoadingEnabled(true);
        Stopwatch stopwatch = Stopwatch.createStarted();
        AtomicInteger count = new AtomicInteger();
        classEntries.parallelStream().forEach(obfClassEntry -> {
            ClassEntry deobfClassEntry = this.mapper.deobfuscate(obfClassEntry);
            if (progress != null) {
                progress.step(count.getAndIncrement(), deobfClassEntry.toString());
            }
            try {
                CompilationUnit sourceTree = this.getSourceTree(obfClassEntry.getName(), typeLoader, metadataSystem);
                File file = new File(dirOut, deobfClassEntry.getName().replace('.', '/') + ".java");
                file.getParentFile().mkdirs();
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    sourceTree.acceptVisitor(new InsertParenthesesVisitor(), null);
                    sourceTree.acceptVisitor(new JavaOutputVisitor(new PlainTextOutput(writer), this.settings), null);
                }
            }
            catch (Throwable t) {
                System.err.println("Unable to decompile class " + deobfClassEntry + " (" + obfClassEntry + ")");
                t.printStackTrace(System.err);
            }
        });
        stopwatch.stop();
        System.out.println("writeSources Done in : " + stopwatch.toString());
        if (progress != null) {
            progress.step(count.get(), "Done:");
        }
    }

    public void writeJar(File out, ProgressListener progress) {
        this.transformJar(out, progress, this.createTypeLoader()::transformInto);
    }

    public void transformJar(File out, ProgressListener progress, ClassTransformer transformer) {
        try (JarOutputStream outJar = new JarOutputStream(new FileOutputStream(out));){
            if (progress != null) {
                progress.init(this.parsedJar.getClassCount(), "Transforming classes...");
            }
            AtomicInteger i = new AtomicInteger();
            this.parsedJar.visitNode(node -> {
                if (progress != null) {
                    progress.step(i.getAndIncrement(), node.name);
                }
                try {
                    ClassWriter writer = new ClassWriter(0);
                    String transformedName = transformer.transform((ClassNode)node, writer);
                    outJar.putNextEntry(new JarEntry(transformedName.replace('.', '/') + ".class"));
                    outJar.write(writer.toByteArray());
                    outJar.closeEntry();
                }
                catch (Throwable t) {
                    throw new Error("Unable to transform class " + node.name, t);
                }
            });
            if (progress != null) {
                progress.step(i.get(), "Done!");
            }
        }
        catch (IOException ex) {
            throw new Error("Unable to write to Jar file!");
        }
    }

    public AccessModifier getModifier(Entry<?> entry) {
        EntryMapping mapping = this.mapper.getDeobfMapping(entry);
        if (mapping == null) {
            return AccessModifier.UNCHANGED;
        }
        return mapping.getAccessModifier();
    }

    public void changeModifier(Entry<?> entry, AccessModifier modifier) {
        EntryMapping mapping = this.mapper.getDeobfMapping(entry);
        if (mapping != null) {
            this.mapper.mapFromObf(entry, new EntryMapping(mapping.getTargetName(), modifier));
        } else {
            this.mapper.mapFromObf(entry, new EntryMapping(entry.getName(), modifier));
        }
    }

    public boolean isObfuscatedIdentifier(Entry<?> obfEntry) {
        if (obfEntry instanceof MethodEntry) {
            MethodEntry obfMethodEntry = (MethodEntry)obfEntry;
            String name = obfMethodEntry.getName();
            String sig = obfMethodEntry.getDesc().toString();
            if (name.equals("clone") && sig.equals("()Ljava/lang/Object;")) {
                return false;
            }
            if (name.equals("equals") && sig.equals("(Ljava/lang/Object;)Z")) {
                return false;
            }
            if (name.equals("finalize") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("getClass") && sig.equals("()Ljava/lang/Class;")) {
                return false;
            }
            if (name.equals("hashCode") && sig.equals("()I")) {
                return false;
            }
            if (name.equals("notify") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("notifyAll") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("toString") && sig.equals("()Ljava/lang/String;")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(J)V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(JI)V")) {
                return false;
            }
        }
        return this.jarIndex.getEntryIndex().hasEntry(obfEntry);
    }

    public boolean isRenameable(EntryReference<Entry<?>, Entry<?>> obfReference) {
        return obfReference.isNamed() && this.isObfuscatedIdentifier(obfReference.getNameableEntry());
    }

    public boolean hasDeobfuscatedName(Entry<?> obfEntry) {
        return this.mapper.hasDeobfMapping(obfEntry);
    }

    public void rename(Entry<?> obfEntry, String newName) {
        this.mapper.mapFromObf(obfEntry, new EntryMapping(newName));
    }

    public void removeMapping(Entry<?> obfEntry) {
        this.mapper.removeByObf(obfEntry);
    }

    public void markAsDeobfuscated(Entry<?> obfEntry) {
        this.mapper.mapFromObf(obfEntry, new EntryMapping(this.mapper.deobfuscate(obfEntry).getName()));
    }

    public static void runCustomTransforms(AstBuilder builder, DecompilerContext context) {
        List<IAstTransform> transformers = Arrays.asList(new ObfuscatedEnumSwitchRewriterTransform(context), new VarargsFixer(context), new RemoveObjectCasts(context), new Java8Generics(), new InvalidIdentifierFix());
        for (IAstTransform transform : transformers) {
            transform.run(builder.getCompilationUnit());
        }
    }

    public static class NoRetryMetadataSystem
    extends MetadataSystem {
        private final Set<String> _failedTypes = Collections.newSetFromMap(new ConcurrentHashMap());

        public NoRetryMetadataSystem(ITypeLoader typeLoader) {
            super(typeLoader);
        }

        @Override
        protected synchronized TypeDefinition resolveType(String descriptor, boolean mightBePrimitive) {
            if (this._failedTypes.contains(descriptor)) {
                return null;
            }
            TypeDefinition result = super.resolveType(descriptor, mightBePrimitive);
            if (result == null) {
                this._failedTypes.add(descriptor);
            }
            return result;
        }

        @Override
        public synchronized TypeDefinition resolve(TypeReference type) {
            return super.resolve(type);
        }
    }

    public static interface ClassTransformer {
        public String transform(ClassNode var1, ClassWriter var2);
    }
}

