/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.jar.JarFile;

public class Main {
    public static void main(String[] args) throws Exception {
        Gui gui = new Gui();
        if (args.length >= 1) {
            gui.getController().openJar(new JarFile(Main.getFile(args[0])));
        }
        if (args.length >= 2) {
            Path mappingsFile = Main.getFile(args[1]).toPath();
            if (Files.isDirectory(mappingsFile, new LinkOption[0])) {
                gui.getController().openMappings(MappingFormat.ENIGMA_DIRECTORY, mappingsFile);
            } else {
                gui.getController().openMappings(MappingFormat.ENIGMA_FILE, mappingsFile);
            }
        }
    }

    private static File getFile(String path) {
        if (path.startsWith("~")) {
            File dirHome = new File(System.getProperty("user.home"));
            if (path.startsWith("~/")) {
                return new File(dirHome, path.substring(2));
            }
            return new File(dirHome.getParentFile(), path.substring(1));
        }
        return new File(path);
    }
}

