/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.translation.representation.ReferencedEntryPool;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.HashMap;
import java.util.Map;

public class SourceIndexMethodVisitor
extends SourceIndexVisitor {
    private final ReferencedEntryPool entryPool;
    private final MethodDefEntry methodEntry;
    private Multimap<String, Identifier> unmatchedIdentifier = HashMultimap.create();
    private Map<String, Entry<?>> identifierEntryCache = new HashMap();

    public SourceIndexMethodVisitor(ReferencedEntryPool entryPool, MethodDefEntry methodEntry) {
        super(entryPool);
        this.entryPool = entryPool;
        this.methodEntry = methodEntry;
    }

    @Override
    public Void visitInvocationExpression(InvocationExpression node, SourceIndex index) {
        MemberReference ref = node.getUserData(Keys.MEMBER_REFERENCE);
        ClassEntry classEntry = this.entryPool.getClass(ref.getDeclaringType().getInternalName());
        MethodEntry methodEntry = null;
        if (ref instanceof MethodReference) {
            methodEntry = this.entryPool.getMethod(classEntry, ref.getName(), ref.getErasedSignature());
        }
        if (methodEntry != null) {
            AstNode tokenNode = null;
            if (node.getTarget() instanceof MemberReferenceExpression) {
                tokenNode = ((MemberReferenceExpression)node.getTarget()).getMemberNameToken();
            } else if (node.getTarget() instanceof SuperReferenceExpression) {
                tokenNode = node.getTarget();
            } else if (node.getTarget() instanceof ThisReferenceExpression) {
                tokenNode = node.getTarget();
            }
            if (tokenNode != null) {
                index.addReference(tokenNode, methodEntry, this.methodEntry);
            }
        }
        node.getArguments().stream().filter(expression -> expression instanceof IdentifierExpression).forEach(expression -> this.checkIdentifier((IdentifierExpression)expression, index));
        return this.recurse(node, index);
    }

    @Override
    public Void visitMemberReferenceExpression(MemberReferenceExpression node, SourceIndex index) {
        MemberReference ref = node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref instanceof FieldReference) {
            String erasedSignature = ref.getErasedSignature();
            if (erasedSignature.indexOf(40) >= 0) {
                throw new Error("Expected a field here! got " + ref);
            }
            ClassEntry classEntry = this.entryPool.getClass(ref.getDeclaringType().getInternalName());
            FieldEntry fieldEntry = this.entryPool.getField(classEntry, ref.getName(), new TypeDescriptor(erasedSignature));
            if (fieldEntry == null) {
                throw new Error("Failed to find field " + ref.getName() + " on " + classEntry.getFullName());
            }
            index.addReference(node.getMemberNameToken(), fieldEntry, this.methodEntry);
        }
        return this.recurse(node, index);
    }

    @Override
    public Void visitSimpleType(SimpleType node, SourceIndex index) {
        TypeReference ref = node.getUserData(Keys.TYPE_REFERENCE);
        if (node.getIdentifierToken().getStartLocation() != TextLocation.EMPTY) {
            ClassEntry classEntry = this.entryPool.getClass(ref.getInternalName());
            index.addReference(node.getIdentifierToken(), classEntry, this.methodEntry);
        }
        return this.recurse(node, index);
    }

    @Override
    public Void visitParameterDeclaration(ParameterDeclaration node, SourceIndex index) {
        ParameterDefinition def = node.getUserData(Keys.PARAMETER_DEFINITION);
        int parameterIndex = def.getSlot();
        if (parameterIndex >= 0) {
            LocalVariableEntry localVariableEntry = new LocalVariableEntry(this.methodEntry, parameterIndex, node.getName(), true);
            Identifier identifier = node.getNameToken();
            this.identifierEntryCache.put(identifier.getName(), localVariableEntry);
            index.addDeclaration(identifier, localVariableEntry);
        }
        return this.recurse(node, index);
    }

    @Override
    public Void visitIdentifierExpression(IdentifierExpression node, SourceIndex index) {
        MemberReference ref = node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            ClassEntry classEntry = this.entryPool.getClass(ref.getDeclaringType().getInternalName());
            FieldEntry fieldEntry = this.entryPool.getField(classEntry, ref.getName(), new TypeDescriptor(ref.getErasedSignature()));
            if (fieldEntry == null) {
                throw new Error("Failed to find field " + ref.getName() + " on " + classEntry.getFullName());
            }
            index.addReference(node.getIdentifierToken(), fieldEntry, this.methodEntry);
        } else {
            this.checkIdentifier(node, index);
        }
        return this.recurse(node, index);
    }

    private void checkIdentifier(IdentifierExpression node, SourceIndex index) {
        if (this.identifierEntryCache.containsKey(node.getIdentifier())) {
            index.addDeclaration(node.getIdentifierToken(), this.identifierEntryCache.get(node.getIdentifier()));
        } else {
            this.unmatchedIdentifier.put(node.getIdentifier(), node.getIdentifierToken());
        }
    }

    private void addDeclarationToUnmatched(String key, SourceIndex index) {
        Entry<?> entry = this.identifierEntryCache.get(key);
        if (entry == null) {
            return;
        }
        for (Identifier identifier : this.unmatchedIdentifier.get(key)) {
            index.addDeclaration(identifier, entry);
        }
        this.unmatchedIdentifier.removeAll(key);
    }

    @Override
    public Void visitObjectCreationExpression(ObjectCreationExpression node, SourceIndex index) {
        MemberReference ref = node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            ClassEntry classEntry = this.entryPool.getClass(ref.getDeclaringType().getInternalName());
            MethodEntry constructorEntry = this.entryPool.getMethod(classEntry, "<init>", ref.getErasedSignature());
            if (node.getType() instanceof SimpleType) {
                SimpleType simpleTypeNode = (SimpleType)node.getType();
                index.addReference(simpleTypeNode.getIdentifierToken(), constructorEntry, this.methodEntry);
            }
        }
        return this.recurse(node, index);
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclarationStatement node, SourceIndex index) {
        VariableInitializer initializer;
        AstNodeCollection<VariableInitializer> variables = node.getVariables();
        if (variables.size() == 1 && (initializer = variables.firstOrNullObject()) != null && node.getType() instanceof SimpleType) {
            int variableIndex;
            VariableDefinition originalVariable;
            Identifier identifier = initializer.getNameToken();
            Variable variable = initializer.getUserData(Keys.VARIABLE);
            if (variable != null && (originalVariable = variable.getOriginalVariable()) != null && (variableIndex = originalVariable.getSlot()) >= 0) {
                LocalVariableEntry localVariableEntry = new LocalVariableEntry(this.methodEntry, variableIndex, initializer.getName(), false);
                this.identifierEntryCache.put(identifier.getName(), localVariableEntry);
                this.addDeclarationToUnmatched(identifier.getName(), index);
                index.addDeclaration(identifier, localVariableEntry);
            }
        }
        return this.recurse(node, index);
    }

    @Override
    public Void visitMethodGroupExpression(MethodGroupExpression node, SourceIndex index) {
        MemberReference ref = node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref instanceof MethodReference) {
            ClassEntry classEntry = this.entryPool.getClass(ref.getDeclaringType().getInternalName());
            MethodEntry methodEntry = null;
            methodEntry = this.entryPool.getMethod(classEntry, ref.getName(), ref.getErasedSignature());
            AstNode tokenNode = node.getMethodNameToken();
            if (tokenNode == null || tokenNode.getRegion().getBeginLine() == 0 || tokenNode.getRegion().getEndLine() == 0) {
                tokenNode = node.getTarget();
            }
            if (tokenNode != null) {
                index.addReference(tokenNode, methodEntry, this.methodEntry);
            }
        }
        return this.recurse(node, index);
    }
}

