/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;

public class CodeReader
extends JEditorPane {
    private static final long serialVersionUID = 3673180950485748810L;
    private static final Object lock = new Object();
    private SourceIndex sourceIndex;
    private SelectionListener selectionListener;

    public CodeReader() {
        this.setEditable(false);
        this.setContentType("text/java");
        DefaultSyntaxKit kit = (DefaultSyntaxKit)this.getEditorKit();
        kit.toggleComponent(this, "de.sciss.syntaxpane.components.TokenMarker");
        this.addCaretListener(event -> {
            if (this.selectionListener != null && this.sourceIndex != null) {
                Token token = this.sourceIndex.getReferenceToken(event.getDot());
                if (token != null) {
                    this.selectionListener.onSelect(this.sourceIndex.getDeobfReference(token));
                } else {
                    this.selectionListener.onSelect(null);
                }
            }
        });
    }

    public static void navigateToToken(final JEditorPane editor, final Token token, final Highlighter.HighlightPainter highlightPainter) {
        editor.setCaretPosition(token.start);
        editor.grabFocus();
        try {
            Rectangle start = editor.modelToView(token.start);
            Rectangle end = editor.modelToView(token.end);
            Rectangle show = start.union(end);
            show.grow(start.width * 10, start.height * 6);
            SwingUtilities.invokeLater(() -> editor.scrollRectToVisible(show));
        }
        catch (BadLocationException ex) {
            throw new Error(ex);
        }
        Timer timer = new Timer(200, new ActionListener(){
            private int counter = 0;
            private Object highlight = null;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (this.counter % 2 == 0) {
                    try {
                        this.highlight = editor.getHighlighter().addHighlight(token.start, token.end, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (this.highlight != null) {
                    editor.getHighlighter().removeHighlight(this.highlight);
                }
                if (this.counter++ > 6) {
                    Timer timer = (Timer)event.getSource();
                    timer.stop();
                }
            }
        });
        timer.start();
    }

    public void setSelectionListener(SelectionListener val) {
        this.selectionListener = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCode(String code) {
        Object object = lock;
        synchronized (object) {
            this.setText(code);
        }
    }

    public SourceIndex getSourceIndex() {
        return this.sourceIndex;
    }

    public void decompileClass(ClassEntry classEntry, Deobfuscator deobfuscator) {
        this.decompileClass(classEntry, deobfuscator, null);
    }

    public void decompileClass(ClassEntry classEntry, Deobfuscator deobfuscator, Runnable callback) {
        this.decompileClass(classEntry, deobfuscator, null, callback);
    }

    public void decompileClass(ClassEntry classEntry, Deobfuscator deobfuscator, Boolean ignoreBadTokens, Runnable callback) {
        if (classEntry == null) {
            this.setCode(null);
            return;
        }
        this.setCode("(decompiling...)");
        new Thread(() -> {
            CompilationUnit sourceTree = deobfuscator.getSourceTree(classEntry.getName());
            String source = deobfuscator.getSource(sourceTree);
            this.setCode(source);
            this.sourceIndex = deobfuscator.getSourceIndex(sourceTree, source, ignoreBadTokens);
            if (callback != null) {
                callback.run();
            }
        }).start();
    }

    public static interface SelectionListener {
        public void onSelect(EntryReference<Entry<?>, Entry<?>> var1);
    }
}

