/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CrashDialog {
    private static CrashDialog instance = null;
    private JFrame frame = new JFrame("Enigma - Crash Report");
    private JTextArea text;

    private CrashDialog(JFrame parent) {
        Container pane = this.frame.getContentPane();
        pane.setLayout(new BorderLayout());
        JLabel label = new JLabel("Enigma has crashed! =(");
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.add((Component)label, "North");
        this.text = new JTextArea();
        this.text.setTabSize(2);
        pane.add((Component)new JScrollPane(this.text), "Center");
        JPanel buttonsPanel = new JPanel();
        FlowLayout buttonsLayout = new FlowLayout();
        buttonsLayout.setAlignment(2);
        buttonsPanel.setLayout(buttonsLayout);
        buttonsPanel.add(Utils.unboldLabel(new JLabel("If you choose exit, you will lose any unsaved work.")));
        JButton ignoreButton = new JButton("Ignore");
        ignoreButton.addActionListener(event -> this.frame.setVisible(false));
        buttonsPanel.add(ignoreButton);
        JButton exitButton = new JButton("Exit");
        exitButton.addActionListener(event -> System.exit(1));
        buttonsPanel.add(exitButton);
        pane.add((Component)buttonsPanel, "South");
        this.frame.setSize(600, 400);
        this.frame.setLocationRelativeTo(parent);
        this.frame.setDefaultCloseOperation(0);
    }

    public static void init(JFrame parent) {
        instance = new CrashDialog(parent);
    }

    public static void show(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        String report = buf.toString();
        CrashDialog.instance.text.setText(report);
        CrashDialog.instance.frame.doLayout();
        CrashDialog.instance.frame.setVisible(true);
    }
}

