/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import cuchaz.enigma.config.Config;
import cuchaz.enigma.config.Themes;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.dialog.AboutDialog;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    public final JMenuItem closeJarMenu;
    public final JMenuItem openEnigmaMappingsMenu;
    public final JMenuItem openTinyMappingsMenu;
    public final JMenuItem saveMappingsMenu;
    public final JMenuItem saveMappingEnigmaFileMenu;
    public final JMenuItem saveMappingEnigmaDirectoryMenu;
    public final JMenuItem saveMappingsSrgMenu;
    public final JMenuItem closeMappingsMenu;
    public final JMenuItem exportSourceMenu;
    public final JMenuItem exportJarMenu;
    private final Gui gui;

    public MenuBar(Gui gui) {
        this.gui = gui;
        JMenu menu = new JMenu("File");
        this.add(menu);
        JMenuItem item = new JMenuItem("Open Jar...");
        menu.add(item);
        item.addActionListener(event -> {
            this.gui.jarFileChooser.setVisible(true);
            File file = new File(this.gui.jarFileChooser.getDirectory() + File.separator + this.gui.jarFileChooser.getFile());
            if (file.exists()) {
                new Thread(() -> {
                    try {
                        gui.getController().openJar(new JarFile(file));
                    }
                    catch (IOException ex) {
                        throw new Error(ex);
                    }
                }).start();
            }
        });
        item = new JMenuItem("Close Jar");
        menu.add(item);
        item.addActionListener(event -> this.gui.getController().closeJar());
        this.closeJarMenu = item;
        menu.addSeparator();
        JMenu openMenu = new JMenu("Open Mappings...");
        menu.add(openMenu);
        JMenuItem item2 = new JMenuItem("Enigma");
        openMenu.add(item2);
        item2.addActionListener(event -> {
            if (this.gui.enigmaMappingsFileChooser.showOpenDialog(this.gui.getFrame()) == 0) {
                try {
                    File selectedFile = this.gui.enigmaMappingsFileChooser.getSelectedFile();
                    MappingFormat format = selectedFile.isDirectory() ? MappingFormat.ENIGMA_DIRECTORY : MappingFormat.ENIGMA_FILE;
                    this.gui.getController().openMappings(format, selectedFile.toPath());
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
                catch (MappingParseException ex) {
                    JOptionPane.showMessageDialog(this.gui.getFrame(), ex.getMessage());
                }
            }
        });
        this.openEnigmaMappingsMenu = item2;
        item2 = new JMenuItem("Tiny");
        openMenu.add(item2);
        item2.addActionListener(event -> {
            this.gui.tinyMappingsFileChooser.setVisible(true);
            File file = new File(this.gui.tinyMappingsFileChooser.getDirectory() + File.separator + this.gui.tinyMappingsFileChooser.getFile());
            if (file.exists()) {
                try {
                    this.gui.getController().openMappings(MappingFormat.TINY_FILE, file.toPath());
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
                catch (MappingParseException ex) {
                    JOptionPane.showMessageDialog(this.gui.getFrame(), ex.getMessage());
                }
            }
        });
        this.openTinyMappingsMenu = item2;
        item2 = new JMenuItem("Save Mappings");
        menu.add(item2);
        item2.addActionListener(event -> this.gui.getController().saveMappings(this.gui.enigmaMappingsFileChooser.getSelectedFile().toPath()));
        item2.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.saveMappingsMenu = item2;
        JMenu saveMenu = new JMenu("Save Mappings As...");
        menu.add(saveMenu);
        JMenuItem item3 = new JMenuItem("Enigma (single file)");
        saveMenu.add(item3);
        item3.addActionListener(event -> {
            if (this.gui.enigmaMappingsFileChooser.showSaveDialog(this.gui.getFrame()) == 0) {
                this.gui.getController().saveMappings(MappingFormat.ENIGMA_FILE, this.gui.enigmaMappingsFileChooser.getSelectedFile().toPath());
                this.saveMappingsMenu.setEnabled(true);
            }
        });
        this.saveMappingEnigmaFileMenu = item3;
        item3 = new JMenuItem("Enigma (directory)");
        saveMenu.add(item3);
        item3.addActionListener(event -> {
            if (this.gui.enigmaMappingsFileChooser.showSaveDialog(this.gui.getFrame()) == 0) {
                this.gui.getController().saveMappings(MappingFormat.ENIGMA_DIRECTORY, this.gui.enigmaMappingsFileChooser.getSelectedFile().toPath());
                this.saveMappingsMenu.setEnabled(true);
            }
        });
        item3.setAccelerator(KeyStroke.getKeyStroke(83, 192));
        this.saveMappingEnigmaDirectoryMenu = item3;
        item3 = new JMenuItem("SRG (single file)");
        saveMenu.add(item3);
        item3.addActionListener(event -> {
            if (this.gui.enigmaMappingsFileChooser.showSaveDialog(this.gui.getFrame()) == 0) {
                this.gui.getController().saveMappings(MappingFormat.SRG_FILE, this.gui.enigmaMappingsFileChooser.getSelectedFile().toPath());
                this.saveMappingsMenu.setEnabled(true);
            }
        });
        this.saveMappingsSrgMenu = item3;
        item3 = new JMenuItem("Close Mappings");
        menu.add(item3);
        item3.addActionListener(event -> {
            if (this.gui.getController().isDirty()) {
                this.gui.showDiscardDiag(response -> {
                    if (response == 0) {
                        try {
                            gui.saveMapping();
                            this.gui.getController().closeMappings();
                        }
                        catch (IOException e) {
                            throw new Error(e);
                        }
                    } else if (response == 1) {
                        this.gui.getController().closeMappings();
                    }
                    return null;
                }, "Save and close", "Discard changes", "Cancel");
            } else {
                this.gui.getController().closeMappings();
            }
        });
        this.closeMappingsMenu = item3;
        menu.addSeparator();
        item3 = new JMenuItem("Export Source...");
        menu.add(item3);
        item3.addActionListener(event -> {
            if (this.gui.exportSourceFileChooser.showSaveDialog(this.gui.getFrame()) == 0) {
                this.gui.getController().exportSource(this.gui.exportSourceFileChooser.getSelectedFile());
            }
        });
        this.exportSourceMenu = item3;
        item3 = new JMenuItem("Export Jar...");
        menu.add(item3);
        item3.addActionListener(event -> {
            this.gui.tinyMappingsFileChooser.setVisible(true);
            if (this.gui.tinyMappingsFileChooser.getFile() != null) {
                File file = new File(this.gui.tinyMappingsFileChooser.getDirectory() + File.separator + this.gui.tinyMappingsFileChooser.getFile());
                this.gui.getController().exportJar(file);
            }
        });
        this.exportJarMenu = item3;
        menu.addSeparator();
        item3 = new JMenuItem("Exit");
        menu.add(item3);
        item3.addActionListener(event -> this.gui.close());
        menu = new JMenu("View");
        this.add(menu);
        JMenu themes = new JMenu("Themes");
        menu.add(themes);
        for (Config.LookAndFeel lookAndFeel : Config.LookAndFeel.values()) {
            JMenuItem theme = new JMenuItem(lookAndFeel.getName());
            themes.add(theme);
            theme.addActionListener(event -> Themes.setLookAndFeel(gui, lookAndFeel));
        }
        menu = new JMenu("Help");
        this.add(menu);
        item = new JMenuItem("About");
        menu.add(item);
        item.addActionListener(event -> AboutDialog.show(this.gui.getFrame()));
    }
}

