/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.Entry;

public class MappingDelta
implements Translatable {
    public static final Object PLACEHOLDER = new Object();
    private final EntryTree<Object> additions;
    private final EntryTree<Object> deletions;

    public MappingDelta(EntryTree<Object> additions, EntryTree<Object> deletions) {
        this.additions = additions;
        this.deletions = deletions;
    }

    public MappingDelta() {
        this(new HashEntryTree<Object>(), new HashEntryTree<Object>());
    }

    public static MappingDelta added(EntryTree<EntryMapping> mappings) {
        HashEntryTree<Object> additions = new HashEntryTree<Object>();
        for (Entry<?> entry : mappings.getAllEntries()) {
            additions.insert(entry, PLACEHOLDER);
        }
        return new MappingDelta(additions, new HashEntryTree<Object>());
    }

    public EntryTree<?> getAdditions() {
        return this.additions;
    }

    public EntryTree<?> getDeletions() {
        return this.deletions;
    }

    @Override
    public MappingDelta translate(Translator translator, EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        return new MappingDelta(this.translate(translator, this.additions), this.translate(translator, this.deletions));
    }

    private EntryTree<Object> translate(Translator translator, EntryTree<Object> tree) {
        HashEntryTree<Object> translatedTree = new HashEntryTree<Object>();
        for (Entry<?> entry : tree.getAllEntries()) {
            translatedTree.insert(translator.translate(entry), PLACEHOLDER);
        }
        return translatedTree;
    }
}

