/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.Collection;
import java.util.Set;

public class MappingValidator {
    private final EntryTree<EntryMapping> deobfToObf;
    private final Translator deobfuscator;
    private final EntryResolver entryResolver;

    public MappingValidator(EntryTree<EntryMapping> deobfToObf, Translator deobfuscator, EntryResolver entryResolver) {
        this.deobfToObf = deobfToObf;
        this.deobfuscator = deobfuscator;
        this.entryResolver = entryResolver;
    }

    public void validateRename(Entry<?> entry, String name) throws IllegalNameException {
        Set<Entry<?>> equivalentEntries = this.entryResolver.resolveEquivalentEntries(entry);
        for (Entry entry2 : equivalentEntries) {
            entry2.validateName(name);
            this.validateUnique(entry2, name);
        }
    }

    private void validateUnique(Entry<?> entry, String name) {
        Collection<Entry<?>> siblings;
        Entry<?> translatedEntry = this.deobfuscator.translate(entry);
        if (!this.isUnique(translatedEntry, siblings = this.deobfToObf.getSiblings(translatedEntry), name)) {
            throw new IllegalNameException(name, "Name is not unique in " + translatedEntry.getParent() + "!");
        }
    }

    private boolean isUnique(Entry<?> entry, Collection<Entry<?>> siblings, String name) {
        for (Entry<?> child : siblings) {
            if (!entry.canConflictWith(child) || !child.getName().equals(name)) continue;
            return false;
        }
        return true;
    }
}

