/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import com.google.common.base.Charsets;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingPair;
import cuchaz.enigma.translation.mapping.serde.MappingsReader;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public enum TinyMappingsReader implements MappingsReader
{
    INSTANCE;


    @Override
    public EntryTree<EntryMapping> read(Path path) throws IOException, MappingParseException {
        return this.read(path, Files.readAllLines(path, Charsets.UTF_8));
    }

    private EntryTree<EntryMapping> read(Path path, List<String> lines) throws MappingParseException {
        HashEntryTree<EntryMapping> mappings = new HashEntryTree<EntryMapping>();
        lines.remove(0);
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber);
            try {
                MappingPair<?, EntryMapping> mapping = this.parseLine(line);
                mappings.insert((Entry<?>)mapping.getEntry(), mapping.getMapping());
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new MappingParseException(path::toString, lineNumber, t.toString());
            }
        }
        return mappings;
    }

    private MappingPair<?, EntryMapping> parseLine(String line) {
        String key;
        String[] tokens = line.split("\t");
        switch (key = tokens[0]) {
            case "CLASS": {
                return this.parseClass(tokens);
            }
            case "FIELD": {
                return this.parseField(tokens);
            }
            case "METHOD": {
                return this.parseMethod(tokens);
            }
            case "MTH-ARG": {
                return this.parseArgument(tokens);
            }
        }
        throw new RuntimeException("Unknown token '" + key + "'!");
    }

    private MappingPair<ClassEntry, EntryMapping> parseClass(String[] tokens) {
        ClassEntry obfuscatedEntry = new ClassEntry(tokens[1]);
        String mapping = tokens[2];
        return new MappingPair<ClassEntry, EntryMapping>(obfuscatedEntry, new EntryMapping(mapping));
    }

    private MappingPair<FieldEntry, EntryMapping> parseField(String[] tokens) {
        ClassEntry ownerClass = new ClassEntry(tokens[1]);
        TypeDescriptor descriptor = new TypeDescriptor(tokens[2]);
        FieldEntry obfuscatedEntry = new FieldEntry(ownerClass, tokens[3], descriptor);
        String mapping = tokens[4];
        return new MappingPair<FieldEntry, EntryMapping>(obfuscatedEntry, new EntryMapping(mapping));
    }

    private MappingPair<MethodEntry, EntryMapping> parseMethod(String[] tokens) {
        ClassEntry ownerClass = new ClassEntry(tokens[1]);
        MethodDescriptor descriptor = new MethodDescriptor(tokens[2]);
        MethodEntry obfuscatedEntry = new MethodEntry(ownerClass, tokens[3], descriptor);
        String mapping = tokens[4];
        return new MappingPair<MethodEntry, EntryMapping>(obfuscatedEntry, new EntryMapping(mapping));
    }

    private MappingPair<LocalVariableEntry, EntryMapping> parseArgument(String[] tokens) {
        ClassEntry ownerClass = new ClassEntry(tokens[1]);
        MethodDescriptor ownerDescriptor = new MethodDescriptor(tokens[2]);
        MethodEntry ownerMethod = new MethodEntry(ownerClass, tokens[3], ownerDescriptor);
        int variableIndex = Integer.parseInt(tokens[4]);
        String mapping = tokens[5];
        LocalVariableEntry obfuscatedEntry = new LocalVariableEntry(ownerMethod, variableIndex, "", true);
        return new MappingPair<LocalVariableEntry, EntryMapping>(obfuscatedEntry, new EntryMapping(mapping));
    }
}

