/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.tree;

import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public class DeltaTrackingTree<T>
implements EntryTree<T> {
    private final EntryTree<T> delegate;
    private EntryTree<Object> additions = new HashEntryTree<Object>();
    private EntryTree<Object> deletions = new HashEntryTree<Object>();

    public DeltaTrackingTree(EntryTree<T> delegate) {
        this.delegate = delegate;
    }

    public DeltaTrackingTree() {
        this(new HashEntryTree());
    }

    @Override
    public void insert(Entry<?> entry, T value) {
        if (value != null) {
            this.trackAddition(entry);
        } else {
            this.trackDeletion(entry);
        }
        this.delegate.insert(entry, value);
    }

    @Override
    @Nullable
    public T remove(Entry<?> entry) {
        Object value = this.delegate.remove(entry);
        this.trackDeletion(entry);
        return value;
    }

    public void trackAddition(Entry<?> entry) {
        this.deletions.remove(entry);
        this.additions.insert(entry, MappingDelta.PLACEHOLDER);
    }

    public void trackDeletion(Entry<?> entry) {
        this.additions.remove(entry);
        this.deletions.insert(entry, MappingDelta.PLACEHOLDER);
    }

    @Override
    @Nullable
    public T get(Entry<?> entry) {
        return this.delegate.get(entry);
    }

    @Override
    public Collection<Entry<?>> getChildren(Entry<?> entry) {
        return this.delegate.getChildren(entry);
    }

    @Override
    public Collection<Entry<?>> getSiblings(Entry<?> entry) {
        return this.delegate.getSiblings(entry);
    }

    @Override
    @Nullable
    public EntryTreeNode<T> findNode(Entry<?> entry) {
        return this.delegate.findNode(entry);
    }

    @Override
    public Collection<EntryTreeNode<T>> getAllNodes() {
        return this.delegate.getAllNodes();
    }

    @Override
    public Collection<Entry<?>> getRootEntries() {
        return this.delegate.getRootEntries();
    }

    @Override
    public Collection<Entry<?>> getAllEntries() {
        return this.delegate.getAllEntries();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<EntryTreeNode<T>> iterator() {
        return this.delegate.iterator();
    }

    public MappingDelta takeDelta() {
        MappingDelta delta = new MappingDelta(this.additions, this.deletions);
        this.resetDelta();
        return delta;
    }

    private void resetDelta() {
        this.additions = new HashEntryTree<Object>();
        this.deletions = new HashEntryTree<Object>();
    }

    public boolean isDirty() {
        return !this.additions.isEmpty() || !this.deletions.isEmpty();
    }
}

