/*
 * Decompiled with CFR 0.152.
 */
package oml;

import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ITypeLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;

public class ExtraClasspathTypeLoader
implements ITypeLoader {
    private final ClassLoader _loader;

    public ExtraClasspathTypeLoader(String extraClasspath) {
        this._loader = new URLClassLoader((URL[])Arrays.stream(extraClasspath.split(File.pathSeparator)).map(path -> {
            try {
                return new File((String)path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLoadType(String internalName, Buffer buffer) {
        String path = internalName.concat(".class");
        URL resource = this._loader.getResource(path);
        if (resource == null) {
            return false;
        }
        try (InputStream stream = this._loader.getResourceAsStream(path);){
            int bytesRead;
            byte[] temp = new byte[4096];
            while ((bytesRead = stream.read(temp, 0, temp.length)) > 0) {
                buffer.putByteArray(temp, 0, bytesRead);
            }
            buffer.flip();
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }
}

