/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.SwingUtilities2;

public class DarculaButtonUI
extends BasicButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component c) {
        return c instanceof JButton && "square".equals(((JButton)c).getClientProperty("JButton.buttonType"));
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Border border = c.getBorder();
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
        boolean square = DarculaButtonUI.isSquare(c);
        if (c.isEnabled() && border != null && button.isContentAreaFilled() && !(c instanceof JToggleButton)) {
            Insets ins = border.getBorderInsets(c);
            int yOff = (ins.top + ins.bottom) / 4;
            if (!square) {
                if (c instanceof JButton && ((JButton)c).isDefaultButton() || model.isSelected()) {
                    ((Graphics2D)g2).setPaint(new GradientPaint(0.0f, 0.0f, this.getSelectedButtonColor1(), 0.0f, c.getHeight(), this.getSelectedButtonColor2()));
                } else {
                    ((Graphics2D)g2).setPaint(new GradientPaint(0.0f, 0.0f, this.getButtonColor1(), 0.0f, c.getHeight(), this.getButtonColor2()));
                }
            }
            g2.fillRoundRect(square ? 2 : 4, yOff, c.getWidth() - 8, c.getHeight() - 2 * yOff, square ? 3 : 5, square ? 3 : 5);
        }
        config.restore();
        super.paint(g2, c);
    }

    @Override
    protected void paintText(Graphics g2, JComponent c, Rectangle textRect, String text) {
        Color selectedFg;
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Color fg = button.getForeground();
        if (fg instanceof UIResource && button instanceof JButton && ((JButton)button).isDefaultButton() && (selectedFg = UIManager.getColor("Button.darcula.selectedButtonForeground")) != null) {
            fg = selectedFg;
        }
        g2.setColor(fg);
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g2);
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c, g2, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            g2.setColor(UIManager.getColor("Button.darcula.disabledText.shadow"));
            SwingUtilities2.drawStringUnderlineCharAt(c, g2, text, -1, textRect.x + this.getTextShiftOffset() + 1, textRect.y + metrics.getAscent() + this.getTextShiftOffset() + 1);
            g2.setColor(UIManager.getColor("Button.disabledText"));
            SwingUtilities2.drawStringUnderlineCharAt(c, g2, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        }
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        super.update(g2, c);
        if (c instanceof JButton && ((JButton)c).isDefaultButton() && !SystemInfo.isMac && !c.getFont().isBold()) {
            c.setFont(c.getFont().deriveFont(1));
        }
    }

    protected Color getButtonColor1() {
        return UIManager.getColor("Button.darcula.color1");
    }

    protected Color getButtonColor2() {
        return UIManager.getColor("Button.darcula.color2");
    }

    protected Color getSelectedButtonColor1() {
        return UIManager.getColor("Button.darcula.selection.color1");
    }

    protected Color getSelectedButtonColor2() {
        return UIManager.getColor("Button.darcula.selection.color2");
    }
}

