/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.darcula.ui.DarculaTextBorder;
import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class DarculaTextFieldUI
extends BasicTextFieldUI {
    private final FocusListener myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            DarculaTextFieldUI.this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarculaTextFieldUI.this.getComponent().repaint();
        }
    };
    private final MouseMotionListener myMouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            if (DarculaTextFieldUI.this.getComponent() != null && DarculaTextFieldUI.isSearchField(DarculaTextFieldUI.this.getComponent())) {
                if (DarculaTextFieldUI.this.getActionUnder(e) != null) {
                    DarculaTextFieldUI.this.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    DarculaTextFieldUI.this.getComponent().setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        }
    };
    private final MouseListener myMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            SearchAction action;
            if (DarculaTextFieldUI.isSearchField(DarculaTextFieldUI.this.getComponent()) && (action = DarculaTextFieldUI.this.getActionUnder(e)) != null) {
                switch (action) {
                    case POPUP: {
                        DarculaTextFieldUI.this.showSearchPopup();
                        break;
                    }
                    case CLEAR: {
                        DarculaTextFieldUI.this.getComponent().setText("");
                    }
                }
                e.consume();
            }
        }
    };
    protected JLabel myClearIcon;
    protected JLabel myRecentIcon;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTextFieldUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent c = this.getComponent();
        c.addFocusListener(this.myFocusListener);
        c.addMouseMotionListener(this.myMouseMotionListener);
        c.addMouseListener(this.myMouseListener);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent c = this.getComponent();
        c.removeMouseListener(this.myMouseListener);
        c.removeMouseMotionListener(this.myMouseMotionListener);
        c.removeFocusListener(this.myFocusListener);
        super.uninstallListeners();
    }

    protected void showSearchPopup() {
        Object value = this.getComponent().getClientProperty("JTextField.Search.FindPopup");
        if (value instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)value;
            popup.show(this.getComponent(), this.getSearchIconCoord().x, this.getComponent().getHeight());
        }
    }

    private SearchAction getActionUnder(MouseEvent e) {
        Point cPoint = this.getClearIconCoord();
        Point sPoint = this.getSearchIconCoord();
        cPoint.x += 8;
        cPoint.y += 8;
        sPoint.x += 8;
        sPoint.y += 8;
        Point ePoint = e.getPoint();
        return cPoint.distance(ePoint) <= 8.0 ? SearchAction.CLEAR : (sPoint.distance(ePoint) <= 8.0 ? SearchAction.POPUP : null);
    }

    protected Rectangle getDrawingRect() {
        JTextComponent c = this.getComponent();
        Insets i = c.getInsets();
        int x = i.right - 4 - 16;
        int y = i.top - 3;
        int w = c.getWidth() - i.left - i.right + 32 + 14 - 5;
        int h2 = c.getBounds().height - i.top - i.bottom + 8 - 3;
        if (h2 % 2 == 1) {
            ++h2;
        }
        return new Rectangle(x, y, w, h2);
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + 3, r.y + (r.height - 16) / 2 + 1);
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + r.width - 16 - 1, r.y + (r.height - 16) / 2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        Rectangle r = this.getDrawingRect();
        if (c.isOpaque() && parent != null) {
            g2.setColor(parent.getBackground());
            g2.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        GraphicsConfig config = new GraphicsConfig(g2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Border border = c.getBorder();
        if (DarculaTextFieldUI.isSearchField(c)) {
            Icon searchIcon;
            g2.setColor(c.getBackground());
            int radius = r.height - 1;
            g2.fillRoundRect(r.x, r.y, r.width, r.height - 1, radius, radius);
            g2.setColor(c.isEnabled() ? Gray._100 : new Color(0x535353));
            if (c.getClientProperty("JTextField.Search.noBorderRing") != Boolean.TRUE) {
                if (c.hasFocus()) {
                    DarculaUIUtil.paintSearchFocusRing(g2, r);
                } else {
                    g2.drawRoundRect(r.x, r.y, r.width, r.height - 1, radius, radius);
                }
            }
            Point p = this.getSearchIconCoord();
            Icon icon = searchIcon = this.getComponent().getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu ? UIManager.getIcon("TextField.darcula.searchWithHistory.icon") : UIManager.getIcon("TextField.darcula.search.icon");
            if (searchIcon == null) {
                searchIcon = IconLoader.findIcon("/com/bulenkov/darcula/icons/search.png", DarculaTextFieldUI.class, true);
            }
            searchIcon.paintIcon(null, g2, p.x, p.y);
            if (this.getComponent().hasFocus() && this.getComponent().getText().length() > 0) {
                p = this.getClearIconCoord();
                Icon clearIcon = UIManager.getIcon("TextField.darcula.clear.icon");
                if (clearIcon == null) {
                    clearIcon = IconLoader.findIcon("/com/bulenkov/darcula/icons/clear.png", DarculaTextFieldUI.class, true);
                }
                clearIcon.paintIcon(null, g2, p.x, p.y);
            }
        } else if (border instanceof DarculaTextBorder) {
            if (c.isEnabled() && c.isEditable()) {
                g2.setColor(c.getBackground());
            }
            int width = c.getWidth();
            int height = c.getHeight();
            Insets i = border.getBorderInsets(c);
            if (c.hasFocus()) {
                g2.fillRoundRect(i.left - 5, i.top - 2, width - i.right - i.left + 10, height - i.top - i.bottom + 6, 5, 5);
            } else {
                g2.fillRect(i.left - 5, i.top - 2, width - i.right - i.left + 12, height - i.top - i.bottom + 6);
            }
        } else {
            super.paintBackground(g2);
        }
        config.restore();
    }

    @Override
    protected void paintSafely(Graphics g2) {
        this.paintBackground(g2);
        super.paintSafely(g2);
    }

    public static boolean isSearchField(Component c) {
        return c instanceof JTextField && "search".equals(((JTextField)c).getClientProperty("JTextField.variant"));
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        return DarculaTextFieldUI.isSearchField(c) && ((JTextField)c).getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu;
    }

    private static enum SearchAction {
        POPUP,
        CLEAR;

    }
}

