/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.EnumValueDeclaration;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexMethodVisitor;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;

public class SourceIndexClassVisitor
extends SourceIndexVisitor {
    private ClassDefEntry classEntry;

    public SourceIndexClassVisitor(ClassDefEntry classEntry) {
        this.classEntry = classEntry;
    }

    @Override
    public Void visitTypeDeclaration(TypeDeclaration node, SourceIndex index) {
        TypeDefinition def = node.getUserData(Keys.TYPE_DEFINITION);
        ClassDefEntry classEntry = ClassDefEntry.parse(def);
        if (!classEntry.equals(this.classEntry)) {
            index.addDeclaration(node.getNameToken(), classEntry);
            return node.acceptVisitor(new SourceIndexClassVisitor(classEntry), index);
        }
        return this.recurse(node, index);
    }

    @Override
    public Void visitSimpleType(SimpleType node, SourceIndex index) {
        TypeReference ref = node.getUserData(Keys.TYPE_REFERENCE);
        if (node.getIdentifierToken().getStartLocation() != TextLocation.EMPTY) {
            ClassEntry classEntry = new ClassEntry(ref.getInternalName());
            index.addReference(node.getIdentifierToken(), classEntry, this.classEntry);
        }
        return this.recurse(node, index);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, SourceIndex index) {
        MethodDefinition def = node.getUserData(Keys.METHOD_DEFINITION);
        MethodDefEntry methodEntry = MethodDefEntry.parse(def);
        AstNode tokenNode = node.getNameToken();
        if (methodEntry.isConstructor() && methodEntry.getName().equals("<clinit>")) {
            tokenNode = node.getModifiers().firstOrNullObject();
        }
        index.addDeclaration(tokenNode, methodEntry);
        return node.acceptVisitor(new SourceIndexMethodVisitor(methodEntry), index);
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, SourceIndex index) {
        MethodDefinition def = node.getUserData(Keys.METHOD_DEFINITION);
        MethodDefEntry methodEntry = MethodDefEntry.parse(def);
        index.addDeclaration(node.getNameToken(), methodEntry);
        return node.acceptVisitor(new SourceIndexMethodVisitor(methodEntry), index);
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, SourceIndex index) {
        FieldDefinition def = node.getUserData(Keys.FIELD_DEFINITION);
        FieldDefEntry fieldEntry = FieldDefEntry.parse(def);
        assert (node.getVariables().size() == 1);
        VariableInitializer variable = node.getVariables().firstOrNullObject();
        index.addDeclaration(variable.getNameToken(), fieldEntry);
        return this.recurse(node, index);
    }

    @Override
    public Void visitEnumValueDeclaration(EnumValueDeclaration node, SourceIndex index) {
        FieldDefinition def = node.getUserData(Keys.FIELD_DEFINITION);
        FieldDefEntry fieldEntry = FieldDefEntry.parse(def);
        index.addDeclaration(node.getNameToken(), fieldEntry);
        return this.recurse(node, index);
    }
}

