/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class BridgeMethodIndex
implements JarIndexer {
    private final EntryIndex entryIndex;
    private final InheritanceIndex inheritanceIndex;
    private final ReferenceIndex referenceIndex;
    private final Set<MethodEntry> bridgeToSpecialized = Sets.newHashSet();
    private final Map<MethodEntry, MethodEntry> specializedToBridge = Maps.newHashMap();

    public BridgeMethodIndex(EntryIndex entryIndex, InheritanceIndex inheritanceIndex, ReferenceIndex referenceIndex) {
        this.entryIndex = entryIndex;
        this.inheritanceIndex = inheritanceIndex;
        this.referenceIndex = referenceIndex;
    }

    public void findBridgeMethods() {
        for (MethodEntry methodEntry : this.entryIndex.getMethods()) {
            MethodDefEntry methodDefEntry = (MethodDefEntry)methodEntry;
            AccessFlags access = methodDefEntry.getAccess();
            if (access == null || !access.isSynthetic()) continue;
            this.indexSyntheticMethod(methodDefEntry, access);
        }
    }

    @Override
    public void processIndex(JarIndex index) {
        HashMap<MethodEntry, MethodEntry> copiedAccessToBridge = new HashMap<MethodEntry, MethodEntry>(this.specializedToBridge);
        for (Map.Entry entry : copiedAccessToBridge.entrySet()) {
            MethodEntry specializedEntry = (MethodEntry)entry.getKey();
            MethodEntry bridgeEntry = (MethodEntry)entry.getValue();
            if (bridgeEntry.getName().equals(specializedEntry.getName())) continue;
            MethodEntry renamedSpecializedEntry = specializedEntry.withName(bridgeEntry.getName());
            this.bridgeToSpecialized.add(renamedSpecializedEntry);
            this.specializedToBridge.put(renamedSpecializedEntry, this.specializedToBridge.get(specializedEntry));
        }
    }

    private void indexSyntheticMethod(MethodDefEntry syntheticMethod, AccessFlags access) {
        MethodEntry specializedMethod = this.findSpecializedMethod(syntheticMethod);
        if (specializedMethod == null) {
            return;
        }
        if (access.isBridge() || this.isPotentialBridge(syntheticMethod, specializedMethod)) {
            this.bridgeToSpecialized.add(syntheticMethod);
            this.specializedToBridge.put(specializedMethod, syntheticMethod);
        }
    }

    private MethodEntry findSpecializedMethod(MethodEntry method) {
        Collection<MethodEntry> referencedMethods = this.referenceIndex.getMethodsReferencedBy(method);
        if (referencedMethods.size() != 1) {
            return null;
        }
        return referencedMethods.stream().findFirst().orElse(null);
    }

    private boolean isPotentialBridge(MethodDefEntry bridgeMethod, MethodEntry specializedMethod) {
        AccessFlags bridgeAccess = bridgeMethod.getAccess();
        if (bridgeAccess.isPrivate() || bridgeAccess.isFinal() || bridgeAccess.isStatic()) {
            return false;
        }
        MethodDescriptor bridgeDesc = bridgeMethod.getDesc();
        MethodDescriptor specializedDesc = specializedMethod.getDesc();
        List<TypeDescriptor> bridgeArguments = bridgeDesc.getArgumentDescs();
        List<TypeDescriptor> specializedArguments = specializedDesc.getArgumentDescs();
        if (bridgeArguments.size() != specializedArguments.size()) {
            return false;
        }
        for (int i = 0; i < bridgeArguments.size(); ++i) {
            if (this.areTypesBridgeCompatible(bridgeArguments.get(i), specializedArguments.get(i))) continue;
            return false;
        }
        return this.areTypesBridgeCompatible(bridgeDesc.getReturnDesc(), specializedDesc.getReturnDesc());
    }

    private boolean areTypesBridgeCompatible(TypeDescriptor bridgeDesc, TypeDescriptor specializedDesc) {
        if (bridgeDesc.equals(specializedDesc)) {
            return true;
        }
        if (bridgeDesc.isType() && specializedDesc.isType()) {
            ClassEntry bridgeType = bridgeDesc.getTypeEntry();
            ClassEntry accessedType = specializedDesc.getTypeEntry();
            InheritanceIndex.Relation relation = this.inheritanceIndex.computeClassRelation(accessedType, bridgeType);
            return relation != InheritanceIndex.Relation.UNRELATED;
        }
        return false;
    }

    public boolean isBridgeMethod(MethodEntry entry) {
        return this.bridgeToSpecialized.contains(entry);
    }

    public boolean isSpecializedMethod(MethodEntry entry) {
        return this.specializedToBridge.containsKey(entry);
    }

    @Nullable
    public MethodEntry getBridgeFromSpecialized(MethodEntry specialized) {
        return this.specializedToBridge.get(specialized);
    }

    public Map<MethodEntry, MethodEntry> getSpecializedToBridge() {
        return Collections.unmodifiableMap(this.specializedToBridge);
    }
}

