/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.Lambda;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.Signature;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class IndexReferenceVisitor
extends ClassVisitor {
    private final JarIndexer indexer;
    private ClassEntry classEntry;

    public IndexReferenceVisitor(JarIndexer indexer, int api) {
        super(api);
        this.indexer = indexer;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classEntry = new ClassEntry(name);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDefEntry entry = new MethodDefEntry(this.classEntry, name, new MethodDescriptor(desc), Signature.createSignature(signature), new AccessFlags(access));
        return new Method(this.indexer, entry, this.api);
    }

    private static class Method
    extends MethodVisitor {
        private final JarIndexer indexer;
        private final MethodDefEntry callerEntry;

        public Method(JarIndexer indexer, MethodDefEntry callerEntry, int api) {
            super(api);
            this.indexer = indexer;
            this.callerEntry = callerEntry;
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            FieldEntry fieldEntry = FieldEntry.parse(owner, name, desc);
            this.indexer.indexFieldReference(this.callerEntry, fieldEntry);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            MethodEntry methodEntry = MethodEntry.parse(owner, name, desc);
            this.indexer.indexMethodReference(this.callerEntry, methodEntry);
        }

        private static ParentedEntry<?> getHandleEntry(Handle handle) {
            switch (handle.getTag()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return FieldEntry.parse(handle.getOwner(), handle.getName(), handle.getDesc());
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return MethodEntry.parse(handle.getOwner(), handle.getName(), handle.getDesc());
                }
            }
            throw new RuntimeException("Invalid handle tag " + handle.getTag());
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if ("java/lang/invoke/LambdaMetafactory".equals(bsm.getOwner()) && "metafactory".equals(bsm.getName())) {
                Type samMethodType = (Type)bsmArgs[0];
                Handle implMethod = (Handle)bsmArgs[1];
                Type instantiatedMethodType = (Type)bsmArgs[2];
                this.indexer.indexLambda(this.callerEntry, new Lambda(name, new MethodDescriptor(desc), new MethodDescriptor(samMethodType.getDescriptor()), Method.getHandleEntry(implMethod), new MethodDescriptor(instantiatedMethodType.getDescriptor())));
            }
        }
    }
}

