/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackageVisibilityIndex
implements JarIndexer {
    private final HashMultimap<ClassEntry, ClassEntry> connections = HashMultimap.create();
    private final List<Set<ClassEntry>> partitions = Lists.newArrayList();
    private final Map<ClassEntry, Set<ClassEntry>> classPartitions = Maps.newHashMap();

    private static boolean requiresSamePackage(AccessFlags entryAcc, EntryReference ref, InheritanceIndex inheritanceIndex) {
        if (entryAcc.isPublic()) {
            return false;
        }
        if (entryAcc.isProtected()) {
            Set<ClassEntry> callerAncestors = inheritanceIndex.getAncestors(ref.context.getContainingClass());
            return !callerAncestors.contains(ref.entry.getContainingClass());
        }
        return !entryAcc.isPrivate();
    }

    private void addConnection(ClassEntry classA, ClassEntry classB) {
        this.connections.put((Object)classA, (Object)classB);
        this.connections.put((Object)classB, (Object)classA);
    }

    private void buildPartition(Set<ClassEntry> unassignedClasses, Set<ClassEntry> partition, ClassEntry member) {
        for (ClassEntry connected : this.connections.get((Object)member)) {
            if (!unassignedClasses.remove(connected)) continue;
            partition.add(connected);
            this.buildPartition(unassignedClasses, partition, connected);
        }
    }

    private void addConnections(EntryIndex entryIndex, ReferenceIndex referenceIndex, InheritanceIndex inheritanceIndex) {
        AccessFlags entryAcc;
        for (FieldEntry fieldEntry : entryIndex.getFields()) {
            entryAcc = entryIndex.getFieldAccess(fieldEntry);
            if (entryAcc.isPublic() || entryAcc.isPrivate()) continue;
            for (EntryReference<FieldEntry, MethodDefEntry> entryReference : referenceIndex.getReferencesToField(fieldEntry)) {
                if (!PackageVisibilityIndex.requiresSamePackage(entryAcc, entryReference, inheritanceIndex)) continue;
                this.addConnection(((FieldEntry)entryReference.entry).getContainingClass(), ((MethodDefEntry)entryReference.context).getContainingClass());
            }
        }
        for (MethodEntry methodEntry : entryIndex.getMethods()) {
            entryAcc = entryIndex.getMethodAccess(methodEntry);
            if (entryAcc.isPublic() || entryAcc.isPrivate()) continue;
            for (EntryReference<ParentedEntry, MethodDefEntry> entryReference : referenceIndex.getReferencesToMethod(methodEntry)) {
                if (!PackageVisibilityIndex.requiresSamePackage(entryAcc, entryReference, inheritanceIndex)) continue;
                this.addConnection(((MethodEntry)entryReference.entry).getContainingClass(), ((MethodDefEntry)entryReference.context).getContainingClass());
            }
        }
        for (ClassEntry classEntry : entryIndex.getClasses()) {
            entryAcc = entryIndex.getClassAccess(classEntry);
            if (!entryAcc.isPublic() && !entryAcc.isPrivate()) {
                for (EntryReference entryReference : referenceIndex.getFieldTypeReferencesToClass(classEntry)) {
                    if (!PackageVisibilityIndex.requiresSamePackage(entryAcc, entryReference, inheritanceIndex)) continue;
                    this.addConnection(((ClassEntry)entryReference.entry).getContainingClass(), ((FieldDefEntry)entryReference.context).getContainingClass());
                }
                for (EntryReference entryReference : referenceIndex.getMethodTypeReferencesToClass(classEntry)) {
                    if (!PackageVisibilityIndex.requiresSamePackage(entryAcc, entryReference, inheritanceIndex)) continue;
                    this.addConnection(((ClassEntry)entryReference.entry).getContainingClass(), ((MethodDefEntry)entryReference.context).getContainingClass());
                }
            }
            for (ClassEntry classEntry2 : inheritanceIndex.getParents(classEntry)) {
                AccessFlags parentAcc = entryIndex.getClassAccess(classEntry2);
                if (parentAcc == null || parentAcc.isPublic() || parentAcc.isPrivate()) continue;
                this.addConnection(classEntry, classEntry2);
            }
            ClassEntry outerClass = classEntry.getOuterClass();
            if (outerClass == null) continue;
            this.addConnection(classEntry, outerClass);
        }
    }

    private void addPartitions(EntryIndex entryIndex) {
        HashSet<ClassEntry> unassignedClasses = Sets.newHashSet(entryIndex.getClasses());
        while (!unassignedClasses.isEmpty()) {
            Iterator iterator = unassignedClasses.iterator();
            ClassEntry initialEntry = (ClassEntry)iterator.next();
            iterator.remove();
            HashSet<ClassEntry> partition = Sets.newHashSet();
            partition.add(initialEntry);
            this.buildPartition(unassignedClasses, partition, initialEntry);
            this.partitions.add(partition);
            for (ClassEntry entry : partition) {
                this.classPartitions.put(entry, partition);
            }
        }
    }

    public Collection<Set<ClassEntry>> getPartitions() {
        return this.partitions;
    }

    public Set<ClassEntry> getPartition(ClassEntry classEntry) {
        return this.classPartitions.get(classEntry);
    }

    @Override
    public void processIndex(JarIndex index) {
        EntryIndex entryIndex = index.getEntryIndex();
        ReferenceIndex referenceIndex = index.getReferenceIndex();
        InheritanceIndex inheritanceIndex = index.getInheritanceIndex();
        this.addConnections(entryIndex, referenceIndex, inheritanceIndex);
        this.addPartitions(entryIndex);
    }
}

