/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.command;

import cuchaz.enigma.command.Command;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import java.io.File;
import java.nio.file.Path;
import java.util.Locale;

public class ConvertMappingsCommand
extends Command {
    public ConvertMappingsCommand() {
        super("convertmappings");
    }

    @Override
    public String getUsage() {
        return "<enigma mappings> <converted mappings> <ENIGMA_FILE|ENIGMA_DIRECTORY|SRG_FILE>";
    }

    @Override
    public boolean isValidArgument(int length) {
        return length == 3;
    }

    @Override
    public void run(String ... args) throws Exception {
        MappingFormat saveFormat;
        Path fileMappings = ConvertMappingsCommand.getReadablePath(ConvertMappingsCommand.getArg(args, 0, "enigma mappings", true));
        File result = ConvertMappingsCommand.getWritableFile(ConvertMappingsCommand.getArg(args, 1, "converted mappings", true));
        String name = ConvertMappingsCommand.getArg(args, 2, "format desc", true);
        try {
            saveFormat = MappingFormat.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(name + "is not a valid mapping format!");
        }
        System.out.println("Reading mappings...");
        MappingFormat readFormat = ConvertMappingsCommand.chooseEnigmaFormat(fileMappings);
        EntryTree<EntryMapping> mappings = readFormat.read(fileMappings, new Command.ConsoleProgressListener());
        System.out.println("Saving new mappings...");
        saveFormat.write(mappings, result.toPath(), new Command.ConsoleProgressListener());
    }
}

