/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.api.EnigmaPlugin;
import cuchaz.enigma.gui.SourceRemapper;
import cuchaz.enigma.gui.highlight.TokenHighlightType;
import cuchaz.enigma.translation.LocalNameGenerator;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DecompiledClassSource {
    private final ClassEntry classEntry;
    private final SourceIndex obfuscatedIndex;
    private SourceIndex remappedIndex;
    private final Map<TokenHighlightType, Collection<Token>> highlightedTokens = new EnumMap<TokenHighlightType, Collection<Token>>(TokenHighlightType.class);

    public DecompiledClassSource(ClassEntry classEntry, SourceIndex index) {
        this.classEntry = classEntry;
        this.obfuscatedIndex = index;
        this.remappedIndex = index;
    }

    public static DecompiledClassSource text(ClassEntry classEntry, String text) {
        return new DecompiledClassSource(classEntry, new SourceIndex(text));
    }

    public void remapSource(Deobfuscator deobfuscator, Translator translator) {
        this.highlightedTokens.clear();
        SourceRemapper remapper = new SourceRemapper(this.obfuscatedIndex.getSource(), this.obfuscatedIndex.referenceTokens());
        SourceRemapper.Result remapResult = remapper.remap((token, movedToken) -> this.remapToken(deobfuscator, token, movedToken, translator));
        this.remappedIndex = this.obfuscatedIndex.remapTo(remapResult);
    }

    private String remapToken(Deobfuscator deobfuscator, Token token, Token movedToken, Translator translator) {
        String defaultName;
        EntryReference<Entry<?>, Entry<?>> reference = this.obfuscatedIndex.getReference(token);
        Entry<?> entry = reference.getNameableEntry();
        Entry<?> translatedEntry = translator.translate(entry);
        if (deobfuscator.isRenamable(reference)) {
            if (this.isDeobfuscated(entry, translatedEntry)) {
                this.highlightToken(movedToken, TokenHighlightType.DEOBFUSCATED);
                return translatedEntry.getSourceRemapName();
            }
            String proposedName = this.proposeName(deobfuscator, entry);
            if (proposedName != null) {
                this.highlightToken(movedToken, TokenHighlightType.PROPOSED);
                return proposedName;
            }
            this.highlightToken(movedToken, TokenHighlightType.OBFUSCATED);
        }
        if ((defaultName = this.generateDefaultName(translatedEntry)) != null) {
            return defaultName;
        }
        return null;
    }

    @Nullable
    private String proposeName(Deobfuscator deobfuscator, Entry<?> entry) {
        if (entry instanceof FieldEntry) {
            for (EnigmaPlugin plugin : deobfuscator.getPlugins()) {
                String owner;
                String proposal = plugin.proposeFieldName(owner = entry.getContainingClass().getFullName(), entry.getName(), ((FieldEntry)entry).getDesc().toString());
                if (proposal == null) continue;
                return proposal;
            }
        }
        return null;
    }

    @Nullable
    private String generateDefaultName(Entry<?> entry) {
        if (entry instanceof LocalVariableDefEntry) {
            LocalVariableDefEntry localVariable = (LocalVariableDefEntry)entry;
            int index = localVariable.getIndex();
            if (localVariable.isArgument()) {
                List<TypeDescriptor> arguments = ((MethodEntry)localVariable.getParent()).getDesc().getArgumentDescs();
                return LocalNameGenerator.generateArgumentName(index, localVariable.getDesc(), arguments);
            }
            return LocalNameGenerator.generateLocalVariableName(index, localVariable.getDesc());
        }
        return null;
    }

    private boolean isDeobfuscated(Entry<?> entry, Entry<?> translatedEntry) {
        return !entry.getName().equals(translatedEntry.getName());
    }

    public ClassEntry getEntry() {
        return this.classEntry;
    }

    public SourceIndex getIndex() {
        return this.remappedIndex;
    }

    public Map<TokenHighlightType, Collection<Token>> getHighlightedTokens() {
        return this.highlightedTokens;
    }

    private void highlightToken(Token token, TokenHighlightType highlightType) {
        this.highlightedTokens.computeIfAbsent(highlightType, t -> new ArrayList()).add(token);
    }

    public String toString() {
        return this.remappedIndex.getSource();
    }
}

