/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.SourceProvider;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.ClassReferenceTreeNode;
import cuchaz.enigma.analysis.DropImportAstTransform;
import cuchaz.enigma.analysis.DropVarModifiersAstTransform;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.config.Config;
import cuchaz.enigma.gui.DecompiledClassSource;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.dialog.ProgressDialog;
import cuchaz.enigma.gui.util.History;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.ReadableToken;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.JOptionPane;

public class GuiController {
    private static final ExecutorService DECOMPILER_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("decompiler-thread").build());
    private final Gui gui;
    private Deobfuscator deobfuscator;
    private DecompiledClassSource currentSource;
    private Path loadedMappingPath;
    private MappingFormat loadedMappingFormat;

    public GuiController(Gui gui) {
        this.gui = gui;
    }

    public boolean isDirty() {
        if (this.deobfuscator == null) {
            return false;
        }
        return this.deobfuscator.getMapper().isDirty();
    }

    public void openJar(JarFile jar) throws IOException {
        this.gui.onStartOpenJar("Loading JAR...");
        this.deobfuscator = new Deobfuscator(jar, this.gui::onStartOpenJar);
        this.gui.onFinishOpenJar(jar.getName());
        this.refreshClasses();
    }

    public void closeJar() {
        this.deobfuscator = null;
        this.gui.onCloseJar();
    }

    public void openMappings(MappingFormat format, Path path) {
        if (this.deobfuscator == null) {
            return;
        }
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> {
            try {
                EntryTree<EntryMapping> mappings = format.read(path, progress);
                this.deobfuscator.setMappings(mappings, progress);
                this.gui.setMappingsFile(path);
                this.loadedMappingFormat = format;
                this.loadedMappingPath = path;
                this.refreshClasses();
                this.refreshCurrentClass();
            }
            catch (MappingParseException e) {
                JOptionPane.showMessageDialog(this.gui.getFrame(), e.getMessage());
            }
        });
    }

    public void saveMappings(Path path) {
        this.saveMappings(this.loadedMappingFormat, path);
    }

    public void saveMappings(MappingFormat format, Path path) {
        if (this.deobfuscator == null) {
            return;
        }
        EntryRemapper mapper = this.deobfuscator.getMapper();
        MappingDelta<EntryMapping> delta = mapper.takeMappingDelta();
        boolean saveAll = !path.equals(this.loadedMappingPath);
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> {
            if (saveAll) {
                format.write(mapper.getObfToDeobf(), path, progress);
            } else {
                format.write(mapper.getObfToDeobf(), delta, path, progress);
            }
        });
        this.loadedMappingFormat = format;
        this.loadedMappingPath = path;
    }

    public void closeMappings() {
        if (this.deobfuscator == null) {
            return;
        }
        this.deobfuscator.setMappings(null);
        this.gui.setMappingsFile(null);
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public void exportSource(File dirOut) {
        if (this.deobfuscator == null) {
            return;
        }
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> this.deobfuscator.writeSources(dirOut.toPath(), progress));
    }

    public void exportJar(File fileOut) {
        if (this.deobfuscator == null) {
            return;
        }
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> this.deobfuscator.writeTransformedJar(fileOut, progress));
    }

    public Token getToken(int pos) {
        if (this.currentSource == null) {
            return null;
        }
        return this.currentSource.getIndex().getReferenceToken(pos);
    }

    @Nullable
    public EntryReference<Entry<?>, Entry<?>> getReference(Token token) {
        if (this.currentSource == null) {
            return null;
        }
        return this.currentSource.getIndex().getReference(token);
    }

    public ReadableToken getReadableToken(Token token) {
        if (this.currentSource == null) {
            return null;
        }
        SourceIndex index = this.currentSource.getIndex();
        return new ReadableToken(index.getLineNumber(token.start), index.getColumnNumber(token.start), index.getColumnNumber(token.end));
    }

    public boolean entryIsInJar(Entry<?> entry) {
        if (entry == null || this.deobfuscator == null) {
            return false;
        }
        return this.deobfuscator.isRenamable(entry);
    }

    public ClassInheritanceTreeNode getClassInheritance(ClassEntry entry) {
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        ClassInheritanceTreeNode rootNode = this.deobfuscator.getIndexTreeBuilder().buildClassInheritance(translator, entry);
        return ClassInheritanceTreeNode.findNode(rootNode, entry);
    }

    public ClassImplementationsTreeNode getClassImplementations(ClassEntry entry) {
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        return this.deobfuscator.getIndexTreeBuilder().buildClassImplementations(translator, entry);
    }

    public MethodInheritanceTreeNode getMethodInheritance(MethodEntry entry) {
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        MethodInheritanceTreeNode rootNode = this.deobfuscator.getIndexTreeBuilder().buildMethodInheritance(translator, entry);
        return MethodInheritanceTreeNode.findNode(rootNode, entry);
    }

    public MethodImplementationsTreeNode getMethodImplementations(MethodEntry entry) {
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        List<MethodImplementationsTreeNode> rootNodes = this.deobfuscator.getIndexTreeBuilder().buildMethodImplementations(translator, entry);
        if (rootNodes.isEmpty()) {
            return null;
        }
        if (rootNodes.size() > 1) {
            System.err.println("WARNING: Method " + entry + " implements multiple interfaces. Only showing first one.");
        }
        return MethodImplementationsTreeNode.findNode(rootNodes.get(0), entry);
    }

    public ClassReferenceTreeNode getClassReferences(ClassEntry entry) {
        Translator deobfuscator = this.deobfuscator.getMapper().getDeobfuscator();
        ClassReferenceTreeNode rootNode = new ClassReferenceTreeNode(deobfuscator, entry);
        rootNode.load(this.deobfuscator.getJarIndex(), true);
        return rootNode;
    }

    public FieldReferenceTreeNode getFieldReferences(FieldEntry entry) {
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        FieldReferenceTreeNode rootNode = new FieldReferenceTreeNode(translator, entry);
        rootNode.load(this.deobfuscator.getJarIndex(), true);
        return rootNode;
    }

    public MethodReferenceTreeNode getMethodReferences(MethodEntry entry, boolean recursive) {
        Translator translator = this.deobfuscator.getMapper().getDeobfuscator();
        MethodReferenceTreeNode rootNode = new MethodReferenceTreeNode(translator, entry);
        rootNode.load(this.deobfuscator.getJarIndex(), true, recursive);
        return rootNode;
    }

    public void rename(EntryReference<Entry<?>, Entry<?>> reference, String newName, boolean refreshClassTree) {
        this.deobfuscator.rename(reference.getNameableEntry(), newName);
        if (refreshClassTree && reference.entry instanceof ClassEntry && !((ClassEntry)reference.entry).isInnerClass()) {
            this.gui.moveClassTree(reference, newName);
        }
        this.refreshCurrentClass(reference);
    }

    public void removeMapping(EntryReference<Entry<?>, Entry<?>> reference) {
        this.deobfuscator.removeMapping(reference.getNameableEntry());
        if (reference.entry instanceof ClassEntry) {
            this.gui.moveClassTree(reference, false, true);
        }
        this.refreshCurrentClass(reference);
    }

    public void markAsDeobfuscated(EntryReference<Entry<?>, Entry<?>> reference) {
        this.deobfuscator.markAsDeobfuscated(reference.getNameableEntry());
        if (reference.entry instanceof ClassEntry && !((ClassEntry)reference.entry).isInnerClass()) {
            this.gui.moveClassTree(reference, true, false);
        }
        this.refreshCurrentClass(reference);
    }

    public void openDeclaration(Entry<?> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.openReference(new EntryReference(entry, entry.getName()));
    }

    public void openReference(EntryReference<Entry<?>, Entry<?>> reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null!");
        }
        if (this.gui.referenceHistory == null) {
            this.gui.referenceHistory = new History(reference);
        } else if (!reference.equals(this.gui.referenceHistory.getCurrent())) {
            this.gui.referenceHistory.push(reference);
        }
        this.setReference(reference);
    }

    private void setReference(EntryReference<Entry<?>, Entry<?>> reference) {
        ClassEntry classEntry = reference.getLocationClassEntry();
        if (!this.deobfuscator.isRenamable(classEntry)) {
            throw new IllegalArgumentException("Obfuscated class " + classEntry + " was not found in the jar!");
        }
        if (this.currentSource == null || !this.currentSource.getEntry().equals(classEntry)) {
            this.loadClass(classEntry, () -> this.showReference(reference));
        } else {
            this.showReference(reference);
        }
    }

    private void showReference(EntryReference<Entry<?>, Entry<?>> reference) {
        Collection<Token> tokens = this.getTokensForReference(reference);
        if (tokens.isEmpty()) {
            System.err.println(String.format("WARNING: no tokens found for %s in %s", reference, this.currentSource.getEntry()));
        } else {
            this.gui.showTokens(tokens);
        }
    }

    public Collection<Token> getTokensForReference(EntryReference<Entry<?>, Entry<?>> reference) {
        EntryRemapper mapper = this.deobfuscator.getMapper();
        SourceIndex index = this.currentSource.getIndex();
        return mapper.getObfResolver().resolveReference(reference, ResolutionStrategy.RESOLVE_CLOSEST).stream().flatMap(r -> index.getReferenceTokens((EntryReference<Entry<?>, Entry<?>>)r).stream()).collect(Collectors.toList());
    }

    public void openPreviousReference() {
        if (this.hasPreviousReference()) {
            this.setReference(this.gui.referenceHistory.goBack());
        }
    }

    public boolean hasPreviousReference() {
        return this.gui.referenceHistory != null && this.gui.referenceHistory.canGoBack();
    }

    public void openNextReference() {
        if (this.hasNextReference()) {
            this.setReference(this.gui.referenceHistory.goForward());
        }
    }

    public boolean hasNextReference() {
        return this.gui.referenceHistory != null && this.gui.referenceHistory.canGoForward();
    }

    public void navigateTo(Entry<?> entry) {
        if (!this.entryIsInJar(entry)) {
            return;
        }
        this.openDeclaration(entry);
    }

    public void navigateTo(EntryReference<Entry<?>, Entry<?>> reference) {
        if (!this.entryIsInJar(reference.getLocationClassEntry())) {
            return;
        }
        this.openReference(reference);
    }

    private void refreshClasses() {
        ArrayList<ClassEntry> obfClasses = Lists.newArrayList();
        ArrayList<ClassEntry> deobfClasses = Lists.newArrayList();
        this.deobfuscator.getSeparatedClasses(obfClasses, deobfClasses);
        this.gui.setObfClasses(obfClasses);
        this.gui.setDeobfClasses(deobfClasses);
    }

    public void refreshCurrentClass() {
        this.refreshCurrentClass(null);
    }

    private void refreshCurrentClass(EntryReference<Entry<?>, Entry<?>> reference) {
        if (this.currentSource != null) {
            this.loadClass(this.currentSource.getEntry(), () -> {
                if (reference != null) {
                    this.showReference(reference);
                }
            });
        }
    }

    private void loadClass(ClassEntry classEntry, Runnable callback) {
        boolean requiresDecompile;
        ClassEntry targetClass = classEntry.getOutermostClass();
        boolean bl = requiresDecompile = this.currentSource == null || !this.currentSource.getEntry().equals(targetClass);
        if (requiresDecompile) {
            this.gui.setEditorText("(decompiling...)");
        }
        DECOMPILER_SERVICE.submit(() -> {
            try {
                if (requiresDecompile) {
                    this.currentSource = this.decompileSource(targetClass, this.deobfuscator.getObfSourceProvider());
                }
                this.remapSource(this.deobfuscator.getMapper().getDeobfuscator());
                callback.run();
            }
            catch (Throwable t) {
                System.err.println("An exception was thrown while decompiling class " + classEntry.getFullName());
                t.printStackTrace(System.err);
            }
        });
    }

    private DecompiledClassSource decompileSource(ClassEntry targetClass, SourceProvider sourceProvider) {
        try {
            CompilationUnit sourceTree = sourceProvider.getSources(targetClass.getFullName());
            if (sourceTree == null) {
                this.gui.setEditorText("Unable to find class: " + targetClass);
                return DecompiledClassSource.text(targetClass, "Unable to find class");
            }
            DropImportAstTransform.INSTANCE.run(sourceTree);
            DropVarModifiersAstTransform.INSTANCE.run(sourceTree);
            String sourceString = sourceProvider.writeSourceToString(sourceTree);
            SourceIndex index = SourceIndex.buildIndex(sourceString, sourceTree, true);
            index.resolveReferences(this.deobfuscator.getMapper().getObfResolver());
            return new DecompiledClassSource(targetClass, index);
        }
        catch (Throwable t) {
            StringWriter traceWriter = new StringWriter();
            t.printStackTrace(new PrintWriter(traceWriter));
            return DecompiledClassSource.text(targetClass, traceWriter.toString());
        }
    }

    private void remapSource(Translator translator) {
        if (this.currentSource == null) {
            return;
        }
        this.currentSource.remapSource(this.deobfuscator, translator);
        this.gui.setEditorTheme(Config.getInstance().lookAndFeel);
        this.gui.setSource(this.currentSource);
    }

    public Deobfuscator getDeobfuscator() {
        return this.deobfuscator;
    }

    public void modifierChange(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.deobfuscator.changeModifier((Entry<?>)this.gui.cursorReference.entry, (AccessModifier)((Object)event.getItem()));
            this.refreshCurrentClass();
        }
    }
}

