/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class MappingsChecker {
    private final JarIndex index;
    private final EntryTree<EntryMapping> mappings;

    public MappingsChecker(JarIndex index, EntryTree<EntryMapping> mappings) {
        this.index = index;
        this.mappings = mappings;
    }

    public Dropped dropBrokenMappings(ProgressListener progress) {
        Dropped dropped = new Dropped();
        Collection obfEntries = this.mappings.getAllEntries().filter(e -> e instanceof ClassEntry || e instanceof MethodEntry || e instanceof FieldEntry).collect(Collectors.toList());
        progress.init(obfEntries.size(), "Checking for dropped mappings");
        int steps = 0;
        for (Entry entry : obfEntries) {
            progress.step(steps++, entry.toString());
            this.tryDropEntry(dropped, entry);
        }
        dropped.apply(this.mappings);
        return dropped;
    }

    private void tryDropEntry(Dropped dropped, Entry<?> entry) {
        EntryMapping mapping;
        if (this.shouldDropEntry(entry) && (mapping = (EntryMapping)this.mappings.get(entry)) != null) {
            dropped.drop(entry, mapping);
        }
    }

    private boolean shouldDropEntry(Entry<?> entry) {
        if (!this.index.getEntryIndex().hasEntry(entry)) {
            return true;
        }
        Collection<Entry<?>> resolvedEntries = this.index.getEntryResolver().resolveEntry(entry, ResolutionStrategy.RESOLVE_ROOT);
        return !resolvedEntries.contains(entry);
    }

    public static class Dropped {
        private final Map<Entry<?>, String> droppedMappings = new HashMap();

        public void drop(Entry<?> entry, EntryMapping mapping) {
            this.droppedMappings.put(entry, mapping.getTargetName());
        }

        void apply(EntryTree<EntryMapping> mappings) {
            for (Entry<?> entry : this.droppedMappings.keySet()) {
                EntryTreeNode<EntryMapping> node = mappings.findNode(entry);
                if (node == null) continue;
                for (Entry<?> childEntry : node.getChildrenRecursively()) {
                    mappings.remove(childEntry);
                }
            }
        }

        public Map<Entry<?>, String> getDroppedMappings() {
            return this.droppedMappings;
        }
    }
}

