/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.serde.EnigmaMappingsReader;
import cuchaz.enigma.translation.mapping.serde.EnigmaMappingsWriter;
import cuchaz.enigma.translation.mapping.serde.MappingsReader;
import cuchaz.enigma.translation.mapping.serde.MappingsWriter;
import cuchaz.enigma.translation.mapping.serde.SrgMappingsWriter;
import cuchaz.enigma.translation.mapping.serde.TinyMappingsReader;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;

public enum MappingFormat {
    ENIGMA_FILE(EnigmaMappingsWriter.FILE, EnigmaMappingsReader.FILE),
    ENIGMA_DIRECTORY(EnigmaMappingsWriter.DIRECTORY, EnigmaMappingsReader.DIRECTORY),
    TINY_FILE(null, TinyMappingsReader.INSTANCE),
    SRG_FILE(SrgMappingsWriter.INSTANCE, null);

    private final MappingsWriter writer;
    private final MappingsReader reader;

    private MappingFormat(MappingsWriter writer, MappingsReader reader) {
        this.writer = writer;
        this.reader = reader;
    }

    public void write(EntryTree<EntryMapping> mappings, Path path, ProgressListener progressListener) {
        this.write(mappings, MappingDelta.added(mappings), path, progressListener);
    }

    public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> delta, Path path, ProgressListener progressListener) {
        if (this.writer == null) {
            throw new IllegalStateException(this.name() + " does not support writing");
        }
        this.writer.write(mappings, delta, path, progressListener);
    }

    public EntryTree<EntryMapping> read(Path path, ProgressListener progressListener) throws IOException, MappingParseException {
        if (this.reader == null) {
            throw new IllegalStateException(this.name() + " does not support reading");
        }
        return this.reader.read(path, progressListener);
    }

    @Nullable
    public MappingsWriter getWriter() {
        return this.writer;
    }

    @Nullable
    public MappingsReader getReader() {
        return this.reader;
    }
}

