/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.base.Functions;
import com.google.common.base.Stopwatch;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.CompiledSourceTypeLoader;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.SourceProvider;
import cuchaz.enigma.SynchronizedTypeLoader;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.IndexTreeBuilder;
import cuchaz.enigma.analysis.ParsedJar;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.api.EnigmaPlugin;
import cuchaz.enigma.bytecode.translators.TranslationClassVisitor;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.MappingsChecker;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.tree.DeltaTrackingTree;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class Deobfuscator {
    private final ServiceLoader<EnigmaPlugin> plugins = ServiceLoader.load(EnigmaPlugin.class);
    private final ParsedJar parsedJar;
    private final JarIndex jarIndex;
    private final IndexTreeBuilder indexTreeBuilder;
    private final SourceProvider obfSourceProvider;
    private EntryRemapper mapper;

    public Deobfuscator(ParsedJar jar, Consumer<String> listener) {
        this.parsedJar = jar;
        this.jarIndex = JarIndex.empty();
        this.jarIndex.indexJar(this.parsedJar, listener);
        listener.accept("Initializing plugins...");
        for (EnigmaPlugin plugin : this.getPlugins()) {
            plugin.onClassesLoaded(this.parsedJar.getClassDataMap(), this.parsedJar::getClassNode);
        }
        this.indexTreeBuilder = new IndexTreeBuilder(this.jarIndex);
        listener.accept("Preparing...");
        this.obfSourceProvider = new SourceProvider(SourceProvider.createSettings(), new CompiledSourceTypeLoader(this.parsedJar));
        this.mapper = new EntryRemapper(this.jarIndex);
    }

    public Deobfuscator(JarFile jar, Consumer<String> listener) throws IOException {
        this(new ParsedJar(jar), listener);
    }

    public Deobfuscator(ParsedJar jar) {
        this(jar, (String msg) -> {});
    }

    public Deobfuscator(JarFile jar) throws IOException {
        this(jar, (String msg) -> {});
    }

    public ServiceLoader<EnigmaPlugin> getPlugins() {
        return this.plugins;
    }

    public ParsedJar getJar() {
        return this.parsedJar;
    }

    public JarIndex getJarIndex() {
        return this.jarIndex;
    }

    public IndexTreeBuilder getIndexTreeBuilder() {
        return this.indexTreeBuilder;
    }

    public EntryRemapper getMapper() {
        return this.mapper;
    }

    public void setMappings(EntryTree<EntryMapping> mappings) {
        if (mappings != null) {
            Collection<Entry<?>> dropped = this.dropMappings(mappings);
            this.mapper = new EntryRemapper(this.jarIndex, mappings);
            DeltaTrackingTree<EntryMapping> obfToDeobf = this.mapper.getObfToDeobf();
            for (Entry<?> entry : dropped) {
                obfToDeobf.trackDeletion(entry);
            }
        } else {
            this.mapper = new EntryRemapper(this.jarIndex);
        }
    }

    private Collection<Entry<?>> dropMappings(EntryTree<EntryMapping> mappings) {
        MappingsChecker checker = new MappingsChecker(this.jarIndex, mappings);
        MappingsChecker.Dropped dropped = checker.dropBrokenMappings();
        Map<Entry<?>, String> droppedMappings = dropped.getDroppedMappings();
        for (Map.Entry<Entry<?>, String> mapping : droppedMappings.entrySet()) {
            System.out.println("WARNING: Couldn't find " + mapping.getKey() + " (" + mapping.getValue() + ") in jar. Mapping was dropped.");
        }
        return droppedMappings.keySet();
    }

    public void getSeparatedClasses(List<ClassEntry> obfClasses, List<ClassEntry> deobfClasses) {
        for (ClassEntry obfClassEntry : this.jarIndex.getEntryIndex().getClasses()) {
            if (obfClassEntry.isInnerClass()) continue;
            ClassEntry deobfClassEntry = this.mapper.deobfuscate(obfClassEntry);
            if (!deobfClassEntry.equals(obfClassEntry)) {
                deobfClasses.add(obfClassEntry);
                continue;
            }
            if (obfClassEntry.getPackageName() != null) {
                deobfClasses.add(obfClassEntry);
                continue;
            }
            obfClasses.add(obfClassEntry);
        }
    }

    public SourceProvider getObfSourceProvider() {
        return this.obfSourceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSources(Path outputDirectory, ProgressListener progress) {
        Collection<ClassEntry> classEntries = this.jarIndex.getEntryIndex().getClasses();
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Translator deobfuscator = this.mapper.getDeobfuscator();
            Map<String, ClassNode> translatedNodes = this.deobfuscateClasses(progress, classEntries, deobfuscator);
            this.decompileClasses(outputDirectory, progress, translatedNodes);
        }
        finally {
            stopwatch.stop();
            System.out.println("writeSources Done in : " + stopwatch.toString());
        }
    }

    private Map<String, ClassNode> deobfuscateClasses(ProgressListener progress, Collection<ClassEntry> classEntries, Translator translator) {
        AtomicInteger count = new AtomicInteger();
        if (progress != null) {
            progress.init(classEntries.size(), "Deobfuscating classes...");
        }
        return classEntries.parallelStream().map(entry -> {
            ClassNode node;
            ClassEntry translatedEntry = translator.translate(entry);
            if (progress != null) {
                progress.step(count.getAndIncrement(), translatedEntry.toString());
            }
            if ((node = this.parsedJar.getClassNode(entry.getFullName())) != null) {
                ClassNode translatedNode = new ClassNode();
                node.accept((ClassVisitor)new TranslationClassVisitor(translator, 327680, (ClassVisitor)translatedNode));
                return translatedNode;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(n -> n.name, Functions.identity()));
    }

    private void decompileClasses(Path outputDirectory, ProgressListener progress, Map<String, ClassNode> translatedClasses) {
        Collection decompileClasses = translatedClasses.values().stream().filter(classNode -> classNode.name.indexOf(36) == -1).collect(Collectors.toList());
        if (progress != null) {
            progress.init(decompileClasses.size(), "Decompiling classes...");
        }
        SynchronizedTypeLoader typeLoader = new SynchronizedTypeLoader(new CompiledSourceTypeLoader(translatedClasses::get));
        NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem(typeLoader);
        metadataSystem.setEagerMethodLoadingEnabled(true);
        DecompilerSettings settings = SourceProvider.createSettings();
        SourceProvider sourceProvider = new SourceProvider(settings, typeLoader, metadataSystem);
        AtomicInteger count = new AtomicInteger();
        decompileClasses.parallelStream().forEach(translatedNode -> {
            if (progress != null) {
                progress.step(count.getAndIncrement(), translatedNode.name);
            }
            this.decompileClass(outputDirectory, (ClassNode)translatedNode, sourceProvider);
        });
    }

    private void decompileClass(Path outputDirectory, ClassNode translatedNode, SourceProvider sourceProvider) {
        try {
            CompilationUnit sourceTree = sourceProvider.getSources(translatedNode.name);
            Path path = outputDirectory.resolve(translatedNode.name.replace('.', '/') + ".java");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                sourceProvider.writeSource(writer, sourceTree);
            }
        }
        catch (Throwable t) {
            System.err.println("Unable to decompile class " + translatedNode.name);
            t.printStackTrace(System.err);
        }
    }

    public void writeTransformedJar(File out, ProgressListener progress) {
        Translator deobfuscator = this.mapper.getDeobfuscator();
        this.writeTransformedJar(out, progress, (node, visitor) -> {
            ClassEntry entry = new ClassEntry(node.name);
            node.accept((ClassVisitor)new TranslationClassVisitor(deobfuscator, 327680, visitor));
            return deobfuscator.translate(entry).getFullName();
        });
    }

    public void writeTransformedJar(File out, ProgressListener progress, ClassTransformer transformer) {
        try (JarOutputStream outJar = new JarOutputStream(new FileOutputStream(out));){
            if (progress != null) {
                progress.init(this.parsedJar.getClassCount(), "Transforming classes...");
            }
            AtomicInteger count = new AtomicInteger();
            this.parsedJar.visitNode(node -> {
                if (progress != null) {
                    progress.step(count.getAndIncrement(), node.name);
                }
                try {
                    ClassWriter writer = new ClassWriter(0);
                    String transformedName = transformer.transform((ClassNode)node, (ClassVisitor)writer);
                    outJar.putNextEntry(new JarEntry(transformedName.replace('.', '/') + ".class"));
                    outJar.write(writer.toByteArray());
                    outJar.closeEntry();
                }
                catch (Throwable t) {
                    throw new Error("Unable to transform class " + node.name, t);
                }
            });
        }
        catch (IOException ex) {
            throw new Error("Unable to write to Jar file!");
        }
    }

    public AccessModifier getModifier(Entry<?> entry) {
        EntryMapping mapping = this.mapper.getDeobfMapping(entry);
        if (mapping == null) {
            return AccessModifier.UNCHANGED;
        }
        return mapping.getAccessModifier();
    }

    public void changeModifier(Entry<?> entry, AccessModifier modifier) {
        EntryMapping mapping = this.mapper.getDeobfMapping(entry);
        if (mapping != null) {
            this.mapper.mapFromObf(entry, new EntryMapping(mapping.getTargetName(), modifier));
        } else {
            this.mapper.mapFromObf(entry, new EntryMapping(entry.getName(), modifier));
        }
    }

    public boolean isRenamable(Entry<?> obfEntry) {
        if (obfEntry instanceof MethodEntry) {
            MethodEntry obfMethodEntry = (MethodEntry)obfEntry;
            String name = obfMethodEntry.getName();
            String sig = obfMethodEntry.getDesc().toString();
            if (name.equals("clone") && sig.equals("()Ljava/lang/Object;")) {
                return false;
            }
            if (name.equals("equals") && sig.equals("(Ljava/lang/Object;)Z")) {
                return false;
            }
            if (name.equals("finalize") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("getClass") && sig.equals("()Ljava/lang/Class;")) {
                return false;
            }
            if (name.equals("hashCode") && sig.equals("()I")) {
                return false;
            }
            if (name.equals("notify") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("notifyAll") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("toString") && sig.equals("()Ljava/lang/String;")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(J)V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(JI)V")) {
                return false;
            }
        } else if (obfEntry instanceof LocalVariableEntry && !((LocalVariableEntry)obfEntry).isArgument()) {
            return false;
        }
        return this.jarIndex.getEntryIndex().hasEntry(obfEntry);
    }

    public boolean isRenamable(EntryReference<Entry<?>, Entry<?>> obfReference) {
        return obfReference.isNamed() && this.isRenamable(obfReference.getNameableEntry());
    }

    public boolean isRemapped(Entry<?> entry) {
        EntryResolver resolver = this.mapper.getObfResolver();
        DeltaTrackingTree<EntryMapping> mappings = this.mapper.getObfToDeobf();
        return resolver.resolveEntry(entry, ResolutionStrategy.RESOLVE_ROOT).stream().anyMatch(mappings::contains);
    }

    public void rename(Entry<?> obfEntry, String newName) {
        this.mapper.mapFromObf(obfEntry, new EntryMapping(newName));
    }

    public void removeMapping(Entry<?> obfEntry) {
        this.mapper.removeByObf(obfEntry);
    }

    public void markAsDeobfuscated(Entry<?> obfEntry) {
        this.mapper.mapFromObf(obfEntry, new EntryMapping(this.mapper.deobfuscate(obfEntry).getName()));
    }

    public <T extends Translatable> T deobfuscate(T translatable) {
        return this.mapper.deobfuscate(translatable);
    }

    public static class NoRetryMetadataSystem
    extends MetadataSystem {
        private final Set<String> _failedTypes = Collections.newSetFromMap(new ConcurrentHashMap());

        public NoRetryMetadataSystem(ITypeLoader typeLoader) {
            super(typeLoader);
        }

        protected synchronized TypeDefinition resolveType(String descriptor, boolean mightBePrimitive) {
            if (this._failedTypes.contains(descriptor)) {
                return null;
            }
            TypeDefinition result = super.resolveType(descriptor, mightBePrimitive);
            if (result == null) {
                this._failedTypes.add(descriptor);
            }
            return result;
        }

        public synchronized TypeDefinition resolve(TypeReference type) {
            return super.resolve(type);
        }
    }

    public static interface ClassTransformer {
        public String transform(ClassNode var1, ClassVisitor var2);
    }
}

