/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.List;

public class IndexTreeBuilder {
    private final JarIndex index;

    public IndexTreeBuilder(JarIndex index) {
        this.index = index;
    }

    public ClassInheritanceTreeNode buildClassInheritance(Translator translator, ClassEntry obfClassEntry) {
        ArrayList ancestry = Lists.newArrayList();
        ancestry.add(obfClassEntry.getFullName());
        for (ClassEntry classEntry : this.index.getInheritanceIndex().getAncestors(obfClassEntry)) {
            ancestry.add(classEntry.getFullName());
        }
        ClassInheritanceTreeNode rootNode = new ClassInheritanceTreeNode(translator, (String)ancestry.get(ancestry.size() - 1));
        rootNode.load(this.index.getInheritanceIndex(), true);
        return rootNode;
    }

    public ClassImplementationsTreeNode buildClassImplementations(Translator translator, ClassEntry obfClassEntry) {
        if (this.index.getInheritanceIndex().isParent(obfClassEntry)) {
            ClassImplementationsTreeNode node = new ClassImplementationsTreeNode(translator, obfClassEntry);
            node.load(this.index);
            return node;
        }
        return null;
    }

    public MethodInheritanceTreeNode buildMethodInheritance(Translator translator, MethodEntry obfMethodEntry) {
        MethodEntry resolvedEntry = this.index.getEntryResolver().resolveFirstEntry(obfMethodEntry, ResolutionStrategy.RESOLVE_ROOT);
        MethodInheritanceTreeNode rootNode = new MethodInheritanceTreeNode(translator, resolvedEntry, this.index.getEntryIndex().hasMethod(resolvedEntry));
        rootNode.load(this.index, true);
        return rootNode;
    }

    public List<MethodImplementationsTreeNode> buildMethodImplementations(Translator translator, MethodEntry obfMethodEntry) {
        EntryIndex entryIndex = this.index.getEntryIndex();
        ArrayList ancestorMethodEntries = Lists.newArrayList();
        if (entryIndex.hasMethod(obfMethodEntry)) {
            ancestorMethodEntries.add(obfMethodEntry);
        }
        for (ClassEntry ancestorEntry : this.index.getInheritanceIndex().getAncestors((ClassEntry)obfMethodEntry.getParent())) {
            MethodEntry ancestorMethod = obfMethodEntry.withParent(ancestorEntry);
            if (!entryIndex.hasMethod(ancestorMethod)) continue;
            ancestorMethodEntries.add(ancestorMethod);
        }
        ArrayList nodes = Lists.newArrayList();
        if (!ancestorMethodEntries.isEmpty()) {
            for (MethodEntry interfaceMethodEntry : ancestorMethodEntries) {
                MethodImplementationsTreeNode node = new MethodImplementationsTreeNode(translator, interfaceMethodEntry);
                node.load(this.index);
                nodes.add(node);
            }
        }
        return nodes;
    }
}

