/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.io.ByteStreams;
import cuchaz.enigma.CompiledSource;
import cuchaz.enigma.bytecode.translators.LocalVariableFixVisitor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ParsedJar
implements CompiledSource {
    private final Map<String, byte[]> classBytes;
    private final Map<String, ClassNode> nodeCache = new HashMap<String, ClassNode>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedJar(JarFile jar) throws IOException {
        LinkedHashMap<String, byte[]> uClassBytes = new LinkedHashMap<String, byte[]>();
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                BufferedInputStream input = new BufferedInputStream(jar.getInputStream(entry));
                Throwable throwable = null;
                try {
                    String path = entry.getName().substring(0, entry.getName().length() - ".class".length());
                    uClassBytes.put(path, ByteStreams.toByteArray((InputStream)input));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)input).close();
                }
            }
        }
        finally {
            jar.close();
            this.classBytes = Collections.unmodifiableMap(uClassBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedJar(JarInputStream jar) throws IOException {
        LinkedHashMap<String, byte[]> uClassBytes = new LinkedHashMap<String, byte[]>();
        try {
            JarEntry entry;
            while ((entry = jar.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                String path = entry.getName().substring(0, entry.getName().length() - ".class".length());
                uClassBytes.put(path, ByteStreams.toByteArray((InputStream)jar));
                jar.closeEntry();
            }
        }
        finally {
            jar.close();
            this.classBytes = Collections.unmodifiableMap(uClassBytes);
        }
    }

    public void visitReader(Function<String, ClassVisitor> visitorFunction, int options) {
        for (String s : this.classBytes.keySet()) {
            ClassNode nodeCached = this.nodeCache.get(s);
            if (nodeCached != null) {
                nodeCached.accept(visitorFunction.apply(s));
                continue;
            }
            new ClassReader(this.classBytes.get(s)).accept(visitorFunction.apply(s), options);
        }
    }

    public void visitNode(Consumer<ClassNode> consumer) {
        for (String s : this.classBytes.keySet()) {
            consumer.accept(this.getClassNode(s));
        }
    }

    public int getClassCount() {
        return this.classBytes.size();
    }

    @Override
    @Nullable
    public ClassNode getClassNode(String name) {
        return this.nodeCache.computeIfAbsent(name, n -> {
            byte[] bytes = this.classBytes.get(name);
            if (bytes == null) {
                return null;
            }
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            LocalVariableFixVisitor visitor = new LocalVariableFixVisitor(327680, (ClassVisitor)node);
            reader.accept((ClassVisitor)visitor, 0);
            return node;
        });
    }

    public List<ClassEntry> getClassEntries() {
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>(this.classBytes.size());
        for (String s : this.classBytes.keySet()) {
            entries.add(new ClassEntry(s));
        }
        return entries;
    }

    public Map<String, byte[]> getClassDataMap() {
        return this.classBytes;
    }
}

