/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.strobel.decompiler.languages.Region;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.gui.SourceRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SourceIndex {
    private static Pattern ANONYMOUS_INNER = Pattern.compile("\\$\\d+$");
    private String source;
    private TreeMap<Token, EntryReference<Entry<?>, Entry<?>>> tokenToReference;
    private Multimap<EntryReference<Entry<?>, Entry<?>>, Token> referenceToTokens;
    private Map<Entry<?>, Token> declarationToToken;
    private List<Integer> lineOffsets;
    private boolean ignoreBadTokens;

    public SourceIndex(String source) {
        this(source, true);
    }

    public SourceIndex(String source, boolean ignoreBadTokens) {
        this.source = source;
        this.ignoreBadTokens = ignoreBadTokens;
        this.tokenToReference = new TreeMap();
        this.referenceToTokens = HashMultimap.create();
        this.declarationToToken = Maps.newHashMap();
        this.calculateLineOffsets();
    }

    public static SourceIndex buildIndex(String sourceString, CompilationUnit sourceTree, boolean ignoreBadTokens) {
        SourceIndex index = new SourceIndex(sourceString, ignoreBadTokens);
        sourceTree.acceptVisitor((IAstVisitor)new SourceIndexVisitor(), (Object)index);
        return index;
    }

    private void calculateLineOffsets() {
        this.lineOffsets = Lists.newArrayList();
        this.lineOffsets.add(0);
        for (int i = 0; i < this.source.length(); ++i) {
            if (this.source.charAt(i) != '\n') continue;
            this.lineOffsets.add(i + 1);
        }
    }

    public SourceIndex remapTo(SourceRemapper.Result result) {
        SourceIndex remapped = new SourceIndex(result.getSource(), this.ignoreBadTokens);
        for (Map.Entry<Entry<?>, Token> entry : this.declarationToToken.entrySet()) {
            remapped.declarationToToken.put(entry.getKey(), result.getRemappedToken(entry.getValue()));
        }
        for (Map.Entry<Entry<Object>, Token> entry : this.referenceToTokens.asMap().entrySet()) {
            EntryReference reference = (EntryReference)((Object)entry.getKey());
            Collection oldTokens = (Collection)((Object)entry.getValue());
            Collection newTokens = oldTokens.stream().map(result::getRemappedToken).collect(Collectors.toList());
            remapped.referenceToTokens.putAll((Object)reference, (Iterable)newTokens);
        }
        for (Map.Entry<Object, Object> entry : this.tokenToReference.entrySet()) {
            remapped.tokenToReference.put(result.getRemappedToken((Token)entry.getKey()), (EntryReference<Entry<?>, Entry<?>>)entry.getValue());
        }
        return remapped;
    }

    public String getSource() {
        return this.source;
    }

    public Token getToken(AstNode node) {
        Region region;
        String name = "";
        if (node instanceof Identifier) {
            name = ((Identifier)node).getName();
        }
        if ((region = node.getRegion()).getBeginLine() == 0 || region.getEndLine() == 0) {
            System.err.println(String.format("WARNING: %s \"%s\" has invalid region: %s", node.getNodeType(), name, region));
            return null;
        }
        Token token = new Token(this.toPos(region.getBeginLine(), region.getBeginColumn()), this.toPos(region.getEndLine(), region.getEndColumn()), this.source);
        if (token.start == 0) {
            System.err.println(String.format("WARNING: %s \"%s\" has invalid start: %s", node.getNodeType(), name, region));
            return null;
        }
        if (node instanceof Identifier && name.indexOf(36) >= 0 && node.getParent() instanceof ConstructorDeclaration && name.lastIndexOf(36) >= 0 && !ANONYMOUS_INNER.matcher(name).matches()) {
            TypeDeclaration type;
            TypeDeclaration typeDeclaration = type = node.getParent().getParent() instanceof TypeDeclaration ? (TypeDeclaration)node.getParent().getParent() : null;
            if (type != null) {
                name = type.getName();
                token.end = token.start + name.length();
            }
        }
        if (name.lastIndexOf(36) >= 0 && this.ignoreBadTokens) {
            System.err.println(String.format("WARNING: %s \"%s\" is probably a bad token. It was ignored", node.getNodeType(), name));
            return null;
        }
        return token;
    }

    public void addReference(AstNode node, Entry<?> deobfEntry, Entry<?> deobfContext) {
        Token token = this.getToken(node);
        if (token != null) {
            EntryReference deobfReference = new EntryReference(deobfEntry, token.text, deobfContext);
            this.tokenToReference.put(token, deobfReference);
            this.referenceToTokens.put(deobfReference, (Object)token);
        }
    }

    public void addDeclaration(AstNode node, Entry<?> deobfEntry) {
        Token token = this.getToken(node);
        if (token != null) {
            EntryReference reference = new EntryReference(deobfEntry, token.text);
            this.tokenToReference.put(token, reference);
            this.referenceToTokens.put(reference, (Object)token);
            this.declarationToToken.put(deobfEntry, token);
        }
    }

    public Token getReferenceToken(int pos) {
        Token token = this.tokenToReference.floorKey(new Token(pos, pos, null));
        if (token != null && token.contains(pos)) {
            return token;
        }
        return null;
    }

    public Collection<Token> getReferenceTokens(EntryReference<Entry<?>, Entry<?>> deobfReference) {
        return this.referenceToTokens.get(deobfReference);
    }

    @Nullable
    public EntryReference<Entry<?>, Entry<?>> getReference(Token token) {
        if (token == null) {
            return null;
        }
        return this.tokenToReference.get(token);
    }

    public Iterable<Token> referenceTokens() {
        return this.tokenToReference.keySet();
    }

    public Iterable<Token> declarationTokens() {
        return this.declarationToToken.values();
    }

    public Iterable<Entry<?>> declarations() {
        return this.declarationToToken.keySet();
    }

    public Token getDeclarationToken(Entry<?> entry) {
        return this.declarationToToken.get(entry);
    }

    public int getLineNumber(int pos) {
        int line = 0;
        for (Integer offset : this.lineOffsets) {
            if (offset > pos) break;
            ++line;
        }
        return line;
    }

    public int getColumnNumber(int pos) {
        return pos - this.lineOffsets.get(this.getLineNumber(pos) - 1) + 1;
    }

    private int toPos(int line, int col) {
        return this.lineOffsets.get(line - 1) + col - 1;
    }

    public void resolveReferences(EntryResolver resolver) {
        for (Token token : Lists.newArrayList((Iterable)this.referenceToTokens.values())) {
            EntryReference<Entry<?>, Entry<?>> reference = this.tokenToReference.get(token);
            EntryReference<Entry<?>, Entry<?>> resolvedReference = resolver.resolveFirstReference(reference, ResolutionStrategy.RESOLVE_CLOSEST);
            this.tokenToReference.replace(token, resolvedReference);
            Collection tokens = this.referenceToTokens.removeAll(reference);
            this.referenceToTokens.putAll(resolvedReference, (Iterable)tokens);
        }
    }
}

