/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.EnumValueDeclaration;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexMethodVisitor;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.translation.representation.ProcyonEntryFactory;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;

public class SourceIndexClassVisitor
extends SourceIndexVisitor {
    private final ProcyonEntryFactory entryFactory = new ProcyonEntryFactory();
    private ClassDefEntry classEntry;

    public SourceIndexClassVisitor(ClassDefEntry classEntry) {
        this.classEntry = classEntry;
    }

    @Override
    public Void visitTypeDeclaration(TypeDeclaration node, SourceIndex index) {
        TypeDefinition def = (TypeDefinition)node.getUserData(Keys.TYPE_DEFINITION);
        ClassDefEntry classEntry = ClassDefEntry.parse(def);
        if (!classEntry.equals(this.classEntry)) {
            index.addDeclaration((AstNode)node.getNameToken(), classEntry);
            return (Void)node.acceptVisitor((IAstVisitor)new SourceIndexClassVisitor(classEntry), (Object)index);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitSimpleType(SimpleType node, SourceIndex index) {
        TypeReference ref = (TypeReference)node.getUserData(Keys.TYPE_REFERENCE);
        if (node.getIdentifierToken().getStartLocation() != TextLocation.EMPTY) {
            ClassEntry classEntry = new ClassEntry(ref.getInternalName());
            index.addReference((AstNode)node.getIdentifierToken(), classEntry, this.classEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, SourceIndex index) {
        MethodDefinition def = (MethodDefinition)node.getUserData(Keys.METHOD_DEFINITION);
        MethodDefEntry methodEntry = this.entryFactory.getMethodDefEntry(def);
        Identifier tokenNode = node.getNameToken();
        if (methodEntry.isConstructor() && methodEntry.getName().equals("<clinit>")) {
            tokenNode = node.getModifiers().firstOrNullObject();
        }
        index.addDeclaration((AstNode)tokenNode, methodEntry);
        return (Void)node.acceptVisitor((IAstVisitor)new SourceIndexMethodVisitor(methodEntry), (Object)index);
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, SourceIndex index) {
        MethodDefinition def = (MethodDefinition)node.getUserData(Keys.METHOD_DEFINITION);
        MethodDefEntry methodEntry = this.entryFactory.getMethodDefEntry(def);
        index.addDeclaration((AstNode)node.getNameToken(), methodEntry);
        return (Void)node.acceptVisitor((IAstVisitor)new SourceIndexMethodVisitor(methodEntry), (Object)index);
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, SourceIndex index) {
        FieldDefinition def = (FieldDefinition)node.getUserData(Keys.FIELD_DEFINITION);
        FieldDefEntry fieldEntry = this.entryFactory.getFieldDefEntry(def);
        assert (node.getVariables().size() == 1);
        VariableInitializer variable = (VariableInitializer)node.getVariables().firstOrNullObject();
        index.addDeclaration((AstNode)variable.getNameToken(), fieldEntry);
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitEnumValueDeclaration(EnumValueDeclaration node, SourceIndex index) {
        FieldDefinition def = (FieldDefinition)node.getUserData(Keys.FIELD_DEFINITION);
        FieldDefEntry fieldEntry = this.entryFactory.getFieldDefEntry(def);
        index.addDeclaration((AstNode)node.getNameToken(), fieldEntry);
        return this.recurse((AstNode)node, index);
    }
}

