/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class InheritanceIndex
implements JarIndexer {
    private Multimap<ClassEntry, ClassEntry> classParents = HashMultimap.create();
    private Multimap<ClassEntry, ClassEntry> classChildren = HashMultimap.create();

    @Override
    public void indexClass(ClassDefEntry classEntry) {
        ClassEntry superClass = classEntry.getSuperClass();
        if (superClass != null) {
            this.indexParent(classEntry, superClass);
        }
        for (ClassEntry interfaceEntry : classEntry.getInterfaces()) {
            this.indexParent(classEntry, interfaceEntry);
        }
    }

    private void indexParent(ClassEntry childEntry, ClassEntry parentEntry) {
        if (childEntry.isJre() || parentEntry.isJre()) {
            return;
        }
        this.classParents.put((Object)childEntry, (Object)parentEntry);
        this.classChildren.put((Object)parentEntry, (Object)childEntry);
    }

    public Collection<ClassEntry> getParents(ClassEntry classEntry) {
        return this.classParents.get((Object)classEntry);
    }

    public Collection<ClassEntry> getChildren(ClassEntry classEntry) {
        return this.classChildren.get((Object)classEntry);
    }

    public Set<ClassEntry> getAncestors(ClassEntry classEntry) {
        HashSet ancestors = Sets.newHashSet();
        LinkedList<ClassEntry> ancestorQueue = new LinkedList<ClassEntry>();
        ancestorQueue.push(classEntry);
        while (!ancestorQueue.isEmpty()) {
            ClassEntry ancestor = (ClassEntry)ancestorQueue.pop();
            Collection<ClassEntry> parents = this.getParents(ancestor);
            parents.forEach(ancestorQueue::push);
            ancestors.addAll(parents);
        }
        return ancestors;
    }

    public boolean isParent(ClassEntry classEntry) {
        return this.classChildren.containsKey((Object)classEntry);
    }

    public boolean hasParents(ClassEntry classEntry) {
        Collection parents = this.classParents.get((Object)classEntry);
        return parents != null && !parents.isEmpty();
    }
}

