/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.ParsedJar;
import cuchaz.enigma.analysis.index.BridgeMethodIndex;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.IndexClassVisitor;
import cuchaz.enigma.analysis.index.IndexReferenceVisitor;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.IndexEntryResolver;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;

public class JarIndex
implements JarIndexer {
    private final EntryIndex entryIndex;
    private final InheritanceIndex inheritanceIndex;
    private final ReferenceIndex referenceIndex;
    private final BridgeMethodIndex bridgeMethodIndex;
    private final EntryResolver entryResolver;
    private final Collection<JarIndexer> indexers;
    private final Multimap<String, MethodDefEntry> methodImplementations = HashMultimap.create();

    public JarIndex(EntryIndex entryIndex, InheritanceIndex inheritanceIndex, ReferenceIndex referenceIndex, BridgeMethodIndex bridgeMethodIndex) {
        this.entryIndex = entryIndex;
        this.inheritanceIndex = inheritanceIndex;
        this.referenceIndex = referenceIndex;
        this.bridgeMethodIndex = bridgeMethodIndex;
        this.indexers = Arrays.asList(entryIndex, inheritanceIndex, referenceIndex, bridgeMethodIndex);
        this.entryResolver = new IndexEntryResolver(this);
    }

    public static JarIndex empty() {
        EntryIndex entryIndex = new EntryIndex();
        InheritanceIndex inheritanceIndex = new InheritanceIndex();
        ReferenceIndex referenceIndex = new ReferenceIndex();
        BridgeMethodIndex bridgeMethodIndex = new BridgeMethodIndex(entryIndex, referenceIndex);
        return new JarIndex(entryIndex, inheritanceIndex, referenceIndex, bridgeMethodIndex);
    }

    public void indexJar(ParsedJar jar, Consumer<String> progress) {
        progress.accept("Indexing entries (1/3)");
        jar.visitReader(name -> new IndexClassVisitor(this, 327680), 1);
        progress.accept("Indexing entry references (2/3)");
        jar.visitReader(name -> new IndexReferenceVisitor(this, 327680), 4);
        progress.accept("Processing index (3/3)");
        this.processIndex(this.entryResolver);
    }

    @Override
    public void processIndex(EntryResolver resolver) {
        this.indexers.forEach(indexer -> indexer.processIndex(this.entryResolver));
    }

    @Override
    public void indexClass(ClassDefEntry classEntry) {
        if (classEntry.isJre()) {
            return;
        }
        for (ClassEntry interfaceEntry : classEntry.getInterfaces()) {
            if (!classEntry.equals(interfaceEntry)) continue;
            throw new IllegalArgumentException("Class cannot be its own interface! " + classEntry);
        }
        this.indexers.forEach(indexer -> indexer.indexClass(classEntry));
    }

    @Override
    public void indexField(FieldDefEntry fieldEntry) {
        if (((ClassEntry)fieldEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexField(fieldEntry));
    }

    @Override
    public void indexMethod(MethodDefEntry methodEntry) {
        if (((ClassEntry)methodEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexMethod(methodEntry));
        if (!methodEntry.isConstructor()) {
            this.methodImplementations.put((Object)((ClassEntry)methodEntry.getParent()).getFullName(), (Object)methodEntry);
        }
    }

    @Override
    public void indexMethodReference(MethodDefEntry callerEntry, MethodEntry referencedEntry) {
        if (((ClassEntry)callerEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexMethodReference(callerEntry, referencedEntry));
    }

    @Override
    public void indexFieldReference(MethodDefEntry callerEntry, FieldEntry referencedEntry) {
        if (((ClassEntry)callerEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexFieldReference(callerEntry, referencedEntry));
    }

    public EntryIndex getEntryIndex() {
        return this.entryIndex;
    }

    public InheritanceIndex getInheritanceIndex() {
        return this.inheritanceIndex;
    }

    public ReferenceIndex getReferenceIndex() {
        return this.referenceIndex;
    }

    public BridgeMethodIndex getBridgeMethodIndex() {
        return this.bridgeMethodIndex;
    }

    public EntryResolver getEntryResolver() {
        return this.entryResolver;
    }
}

