/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Map;

public class ReferenceIndex
implements JarIndexer {
    private Multimap<MethodEntry, MethodEntry> methodReferences = HashMultimap.create();
    private Multimap<MethodEntry, EntryReference<MethodEntry, MethodDefEntry>> referencesToMethods = HashMultimap.create();
    private Multimap<ClassEntry, EntryReference<ClassEntry, MethodDefEntry>> referencesToClasses = HashMultimap.create();
    private Multimap<FieldEntry, EntryReference<FieldEntry, MethodDefEntry>> referencesToFields = HashMultimap.create();

    @Override
    public void indexMethodReference(MethodDefEntry callerEntry, MethodEntry referencedEntry) {
        this.referencesToMethods.put((Object)referencedEntry, new EntryReference<MethodEntry, MethodDefEntry>(referencedEntry, referencedEntry.getName(), callerEntry));
        this.methodReferences.put((Object)callerEntry, (Object)referencedEntry);
        if (referencedEntry.isConstructor()) {
            ClassEntry referencedClass = (ClassEntry)referencedEntry.getParent();
            this.referencesToClasses.put((Object)referencedClass, new EntryReference<ClassEntry, MethodDefEntry>(referencedClass, referencedEntry.getName(), callerEntry));
        }
    }

    @Override
    public void indexFieldReference(MethodDefEntry callerEntry, FieldEntry referencedEntry) {
        this.referencesToFields.put((Object)referencedEntry, new EntryReference<FieldEntry, MethodDefEntry>(referencedEntry, referencedEntry.getName(), callerEntry));
    }

    @Override
    public void processIndex(EntryResolver resolver) {
        this.methodReferences = this.resolveReferences(resolver, this.methodReferences);
        this.referencesToMethods = this.resolveReferencesTo(resolver, this.referencesToMethods);
        this.referencesToClasses = this.resolveReferencesTo(resolver, this.referencesToClasses);
        this.referencesToFields = this.resolveReferencesTo(resolver, this.referencesToFields);
    }

    private <K extends Entry<?>, V extends Entry<?>> Multimap<K, V> resolveReferences(EntryResolver resolver, Multimap<K, V> multimap) {
        HashMultimap resolved = HashMultimap.create();
        for (Map.Entry entry : multimap.entries()) {
            resolved.put((Object)this.resolve(resolver, (Entry)entry.getKey()), (Object)this.resolve(resolver, (Entry)entry.getValue()));
        }
        return resolved;
    }

    private <E extends Entry<?>, C extends Entry<?>> Multimap<E, EntryReference<E, C>> resolveReferencesTo(EntryResolver resolver, Multimap<E, EntryReference<E, C>> multimap) {
        HashMultimap resolved = HashMultimap.create();
        for (Map.Entry entry : multimap.entries()) {
            resolved.put((Object)this.resolve(resolver, (Entry)entry.getKey()), this.resolve(resolver, (EntryReference)entry.getValue()));
        }
        return resolved;
    }

    private <E extends Entry<?>> E resolve(EntryResolver resolver, E entry) {
        return resolver.resolveFirstEntry(entry, ResolutionStrategy.RESOLVE_CLOSEST);
    }

    private <E extends Entry<?>, C extends Entry<?>> EntryReference<E, C> resolve(EntryResolver resolver, EntryReference<E, C> reference) {
        return resolver.resolveFirstReference(reference, ResolutionStrategy.RESOLVE_CLOSEST);
    }

    public Collection<MethodEntry> getMethodsReferencedBy(MethodEntry entry) {
        return this.methodReferences.get((Object)entry);
    }

    public Collection<EntryReference<FieldEntry, MethodDefEntry>> getReferencesToField(FieldEntry entry) {
        return this.referencesToFields.get((Object)entry);
    }

    public Collection<EntryReference<ClassEntry, MethodDefEntry>> getReferencesToClass(ClassEntry entry) {
        return this.referencesToClasses.get((Object)entry);
    }

    public Collection<EntryReference<MethodEntry, MethodDefEntry>> getReferencesToMethod(MethodEntry entry) {
        return this.referencesToMethods.get((Object)entry);
    }
}

