/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.analysis.Token;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;

public class CodeReader
extends JEditorPane {
    private static final long serialVersionUID = 3673180950485748810L;

    public static void navigateToToken(final JEditorPane editor, final Token token, final Highlighter.HighlightPainter highlightPainter) {
        Document document = editor.getDocument();
        int clampedPosition = Math.min(Math.max(token.start, 0), document.getLength());
        editor.setCaretPosition(clampedPosition);
        editor.grabFocus();
        try {
            Rectangle start = editor.modelToView(token.start);
            Rectangle end = editor.modelToView(token.end);
            Rectangle show = start.union(end);
            show.grow(start.width * 10, start.height * 6);
            SwingUtilities.invokeLater(() -> editor.scrollRectToVisible(show));
        }
        catch (BadLocationException ex) {
            throw new Error(ex);
        }
        Timer timer = new Timer(200, new ActionListener(){
            private int counter = 0;
            private Object highlight = null;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (this.counter % 2 == 0) {
                    try {
                        this.highlight = editor.getHighlighter().addHighlight(token.start, token.end, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (this.highlight != null) {
                    editor.getHighlighter().removeHighlight(this.highlight);
                }
                if (this.counter++ > 6) {
                    Timer timer = (Timer)event.getSource();
                    timer.stop();
                }
            }
        });
        timer.start();
    }
}

