/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.Entry;

public class MappingDelta<T>
implements Translatable {
    public static final Object PLACEHOLDER = new Object();
    private final EntryTree<T> baseMappings;
    private final EntryTree<Object> additions;
    private final EntryTree<Object> deletions;

    public MappingDelta(EntryTree<T> baseMappings, EntryTree<Object> additions, EntryTree<Object> deletions) {
        this.baseMappings = baseMappings;
        this.additions = additions;
        this.deletions = deletions;
    }

    public MappingDelta(EntryTree<T> baseMappings) {
        this(baseMappings, new HashEntryTree<Object>(), new HashEntryTree<Object>());
    }

    public static <T> MappingDelta<T> added(EntryTree<T> mappings) {
        HashEntryTree<Object> additions = new HashEntryTree<Object>();
        for (Entry<?> entry : mappings.getAllEntries()) {
            additions.insert(entry, PLACEHOLDER);
        }
        return new MappingDelta(new HashEntryTree(), additions, new HashEntryTree<Object>());
    }

    public EntryTree<T> getBaseMappings() {
        return this.baseMappings;
    }

    public EntryTree<?> getAdditions() {
        return this.additions;
    }

    public EntryTree<?> getDeletions() {
        return this.deletions;
    }

    @Override
    public MappingDelta<T> translate(Translator translator, EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        return new MappingDelta<T>(translator.translate(this.baseMappings), translator.translate(this.additions), translator.translate(this.deletions));
    }
}

