/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class MappingValidator {
    private final EntryTree<EntryMapping> obfToDeobf;
    private final Translator deobfuscator;
    private final EntryResolver entryResolver;

    public MappingValidator(EntryTree<EntryMapping> obfToDeobf, Translator deobfuscator, EntryResolver entryResolver) {
        this.obfToDeobf = obfToDeobf;
        this.deobfuscator = deobfuscator;
        this.entryResolver = entryResolver;
    }

    public void validateRename(Entry<?> entry, String name) throws IllegalNameException {
        Set<Entry<?>> equivalentEntries = this.entryResolver.resolveEquivalentEntries(entry);
        for (Entry entry2 : equivalentEntries) {
            entry2.validateName(name);
            this.validateUnique(entry2, name);
        }
    }

    private void validateUnique(Entry<?> entry, String name) {
        Entry<?> translatedEntry = this.deobfuscator.translate(entry);
        Collection translatedSiblings = this.obfToDeobf.getSiblings(entry).stream().map(this.deobfuscator::translate).collect(Collectors.toList());
        if (!this.isUnique(translatedEntry, translatedSiblings, name)) {
            throw new IllegalNameException(name, "Name is not unique in " + translatedEntry.getParent() + "!");
        }
    }

    private boolean isUnique(Entry<?> entry, Collection<Entry<?>> siblings, String name) {
        for (Entry<?> child : siblings) {
            if (!entry.canConflictWith(child) || !child.getName().equals(name)) continue;
            return false;
        }
        return true;
    }
}

