/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.translation.MappingTranslator;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.VoidEntryResolver;
import cuchaz.enigma.translation.mapping.serde.MappingsWriter;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.LFPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public enum EnigmaMappingsWriter implements MappingsWriter
{
    FILE{

        @Override
        public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> delta, Path path, ProgressListener progress) {
            Collection classes = mappings.getRootEntries().stream().filter(entry -> entry instanceof ClassEntry).map(entry -> (ClassEntry)entry).collect(Collectors.toList());
            progress.init(classes.size(), "Writing classes");
            int steps = 0;
            try (LFPrintWriter writer = new LFPrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
                for (ClassEntry classEntry : classes) {
                    progress.step(steps++, classEntry.getFullName());
                    this.writeRoot(writer, mappings, classEntry);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
    ,
    DIRECTORY{

        @Override
        public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> delta, Path path, ProgressListener progress) {
            this.applyDeletions(delta.getBaseMappings(), delta.getDeletions(), path);
            Collection classes = delta.getAdditions().getRootEntries().stream().filter(entry -> entry instanceof ClassEntry).map(entry -> (ClassEntry)entry).collect(Collectors.toList());
            progress.init(classes.size(), "Writing classes");
            MappingTranslator translator = new MappingTranslator(mappings, VoidEntryResolver.INSTANCE);
            AtomicInteger steps = new AtomicInteger();
            classes.parallelStream().forEach(classEntry -> {
                progress.step(steps.getAndIncrement(), classEntry.getFullName());
                try {
                    Path classPath = this.resolve(path, translator.translate(classEntry));
                    Files.createDirectories(classPath.getParent(), new FileAttribute[0]);
                    Files.deleteIfExists(classPath);
                    try (LFPrintWriter writer = new LFPrintWriter(Files.newBufferedWriter(classPath, new OpenOption[0]));){
                        this.writeRoot(writer, mappings, (ClassEntry)classEntry);
                    }
                }
                catch (Throwable t) {
                    System.err.println("Failed to write class '" + classEntry.getFullName() + "'");
                    t.printStackTrace();
                }
            });
        }

        private void applyDeletions(EntryTree<EntryMapping> baseMappings, EntryTree<?> deletions, Path root) {
            MappingTranslator oldMappingTranslator = new MappingTranslator(baseMappings, VoidEntryResolver.INSTANCE);
            Collection deletedClasses = deletions.getRootEntries().stream().filter(e -> e instanceof ClassEntry).map(e -> oldMappingTranslator.translate((ClassEntry)e)).collect(Collectors.toList());
            for (ClassEntry classEntry : deletedClasses) {
                try {
                    Files.deleteIfExists(this.resolve(root, classEntry));
                }
                catch (IOException e2) {
                    System.err.println("Failed to delete deleted class '" + classEntry + "'");
                    e2.printStackTrace();
                }
            }
            for (ClassEntry classEntry : deletedClasses) {
                String packageName = classEntry.getPackageName();
                if (packageName == null) continue;
                Path packagePath = Paths.get(packageName, new String[0]);
                try {
                    this.deleteDeadPackages(root, packagePath);
                }
                catch (IOException e3) {
                    System.err.println("Failed to delete dead package '" + packageName + "'");
                    e3.printStackTrace();
                }
            }
        }

        private void deleteDeadPackages(Path root, Path packagePath) throws IOException {
            for (int i = packagePath.getNameCount() - 1; i >= 0; --i) {
                Path subPath = packagePath.subpath(0, i + 1);
                Path packagePart = root.resolve(subPath);
                if (!this.isEmpty(packagePart)) continue;
                Files.deleteIfExists(packagePart);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isEmpty(Path path) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                boolean bl = !stream.iterator().hasNext();
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        }

        private Path resolve(Path root, ClassEntry classEntry) {
            return root.resolve(classEntry.getFullName() + ".mapping");
        }
    };


    protected void writeRoot(PrintWriter writer, EntryTree<EntryMapping> mappings, ClassEntry classEntry) {
        Collection<Entry<?>> children = this.groupChildren(mappings.getChildren(classEntry));
        writer.println(this.writeClass(classEntry, (EntryMapping)mappings.get(classEntry)).trim());
        for (Entry<?> child : children) {
            this.writeEntry(writer, mappings, child, 1);
        }
    }

    protected void writeEntry(PrintWriter writer, EntryTree<EntryMapping> mappings, Entry<?> entry, int depth) {
        String line;
        EntryTreeNode<EntryMapping> node = mappings.findNode(entry);
        if (node == null) {
            return;
        }
        EntryMapping mapping = node.getValue();
        if (entry instanceof ClassEntry) {
            line = this.writeClass((ClassEntry)entry, mapping);
            writer.println(this.indent(line, depth));
        } else if (entry instanceof MethodEntry) {
            line = this.writeMethod((MethodEntry)entry, mapping);
            writer.println(this.indent(line, depth));
        } else if (entry instanceof FieldEntry) {
            line = this.writeField((FieldEntry)entry, mapping);
            writer.println(this.indent(line, depth));
        } else if (entry instanceof LocalVariableEntry) {
            line = this.writeArgument((LocalVariableEntry)entry, mapping);
            writer.println(this.indent(line, depth));
        }
        Collection<Entry<?>> children = this.groupChildren(node.getChildren());
        for (Entry<?> child : children) {
            this.writeEntry(writer, mappings, child, depth + 1);
        }
    }

    private Collection<Entry<?>> groupChildren(Collection<Entry<?>> children) {
        ArrayList result = new ArrayList(children.size());
        children.stream().filter(e -> e instanceof ClassEntry).map(e -> (ClassEntry)e).sorted().forEach(result::add);
        children.stream().filter(e -> e instanceof FieldEntry).map(e -> (FieldEntry)e).sorted().forEach(result::add);
        children.stream().filter(e -> e instanceof MethodEntry).map(e -> (MethodEntry)e).sorted().forEach(result::add);
        children.stream().filter(e -> e instanceof LocalVariableEntry).map(e -> (LocalVariableEntry)e).sorted().forEach(result::add);
        return result;
    }

    protected String writeClass(ClassEntry entry, EntryMapping mapping) {
        StringBuilder builder = new StringBuilder("CLASS ");
        builder.append(entry.getFullName()).append(' ');
        this.writeMapping(builder, mapping);
        return builder.toString();
    }

    protected String writeMethod(MethodEntry entry, EntryMapping mapping) {
        StringBuilder builder = new StringBuilder("METHOD ");
        builder.append(entry.getName()).append(' ');
        this.writeMapping(builder, mapping);
        builder.append(entry.getDesc().toString());
        return builder.toString();
    }

    protected String writeField(FieldEntry entry, EntryMapping mapping) {
        StringBuilder builder = new StringBuilder("FIELD ");
        builder.append(entry.getName()).append(' ');
        this.writeMapping(builder, mapping);
        builder.append(entry.getDesc().toString());
        return builder.toString();
    }

    protected String writeArgument(LocalVariableEntry entry, EntryMapping mapping) {
        StringBuilder builder = new StringBuilder("ARG ");
        builder.append(entry.getIndex()).append(' ');
        String mappedName = mapping != null ? mapping.getTargetName() : entry.getName();
        builder.append(mappedName);
        return builder.toString();
    }

    private void writeMapping(StringBuilder builder, EntryMapping mapping) {
        if (mapping != null) {
            builder.append(mapping.getTargetName()).append(' ');
            if (mapping.getAccessModifier() != AccessModifier.UNCHANGED) {
                builder.append(mapping.getAccessModifier().getFormattedName()).append(' ');
            }
        }
    }

    private String indent(String line, int depth) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            builder.append("\t");
        }
        builder.append(line.trim());
        return builder.toString();
    }
}

